/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.admin.handler;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.Constants;
import org.apache.eventmesh.common.utils.LogUtils;
import org.apache.eventmesh.common.utils.NetUtils;
import org.apache.eventmesh.runtime.admin.controller.HttpHandlerManager;
import org.apache.eventmesh.runtime.admin.handler.AbstractHttpHandler;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.common.EventHttpHandler;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.EventMeshTcp2Client;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.group.ClientSessionGroupMapping;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventHttpHandler(path="/clientManage/redirectClientBySubSystem")
public class RedirectClientBySubSystemHandler
extends AbstractHttpHandler {
    private static final Logger log = LoggerFactory.getLogger(RedirectClientBySubSystemHandler.class);
    private final transient EventMeshTCPServer eventMeshTCPServer;

    public RedirectClientBySubSystemHandler(EventMeshTCPServer eventMeshTCPServer, HttpHandlerManager httpHandlerManager) {
        super(httpHandlerManager);
        this.eventMeshTCPServer = eventMeshTCPServer;
    }

    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        Objects.requireNonNull(httpExchange, "httpExchange can not be null");
        try (OutputStream out = httpExchange.getResponseBody();){
            Map queryStringInfo = NetUtils.formData2Dic((String)httpExchange.getRequestURI().getQuery());
            String subSystem = (String)queryStringInfo.get("subsystem");
            String destEventMeshIp = (String)queryStringInfo.get("desteventmeshIp");
            String destEventMeshPort = (String)queryStringInfo.get("desteventmeshport");
            if (!StringUtils.isNumeric((CharSequence)subSystem) || StringUtils.isBlank((CharSequence)destEventMeshIp) || StringUtils.isBlank((CharSequence)destEventMeshPort) || !StringUtils.isNumeric((CharSequence)destEventMeshPort)) {
                NetUtils.sendSuccessResponseHeaders((HttpExchange)httpExchange);
                out.write("params illegal!".getBytes(Constants.DEFAULT_CHARSET));
                return;
            }
            LogUtils.info((Logger)log, (String)"redirectClientBySubSystem in admin,subsys:{},destIp:{},destPort:{}====================", (Object[])new Object[]{subSystem, destEventMeshIp, destEventMeshPort});
            ClientSessionGroupMapping clientSessionGroupMapping = this.eventMeshTCPServer.getClientSessionGroupMapping();
            ConcurrentHashMap<InetSocketAddress, Session> sessionMap = clientSessionGroupMapping.getSessionMap();
            StringBuilder redirectResult = new StringBuilder();
            try {
                if (!sessionMap.isEmpty()) {
                    for (Session session : sessionMap.values()) {
                        if (!session.getClient().getSubsystem().equals(subSystem)) continue;
                        redirectResult.append('|').append(EventMeshTcp2Client.redirectClient2NewEventMesh(this.eventMeshTCPServer.getTcpThreadPoolGroup(), destEventMeshIp, Integer.parseInt(destEventMeshPort), session, clientSessionGroupMapping));
                    }
                }
            }
            catch (Exception e) {
                log.error("clientManage|redirectClientBySubSystem|fail|subSystem={}|destEventMeshIp={}|destEventMeshPort={}", new Object[]{subSystem, destEventMeshIp, destEventMeshPort, e});
                NetUtils.sendSuccessResponseHeaders((HttpExchange)httpExchange);
                out.write(String.format("redirectClientBySubSystem fail! sessionMap size {%d}, {subSystem=%s destEventMeshIp=%s destEventMeshPort=%s}, result {%s}, errorMsg : %s", sessionMap.size(), subSystem, destEventMeshIp, destEventMeshPort, redirectResult, e.getMessage()).getBytes(Constants.DEFAULT_CHARSET));
                if (out != null) {
                    if (var3_4 != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable) {
                            var3_4.addSuppressed(throwable);
                        }
                    } else {
                        out.close();
                    }
                }
                return;
            }
            NetUtils.sendSuccessResponseHeaders((HttpExchange)httpExchange);
            out.write(String.format("redirectClientBySubSystem success! sessionMap size {%d}, {subSystem=%s destEventMeshIp=%s destEventMeshPort=%s}, result {%s} ", sessionMap.size(), subSystem, destEventMeshIp, destEventMeshPort, redirectResult).getBytes(Constants.DEFAULT_CHARSET));
        }
        catch (Exception e) {
            log.error("redirectClientBySubSystem fail...", (Throwable)e);
        }
    }
}

