/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.boot;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.eventmesh.common.config.CommonConfiguration;
import org.apache.eventmesh.common.config.ConfigService;
import org.apache.eventmesh.common.utils.AssertUtils;
import org.apache.eventmesh.common.utils.ConfigurationContextUtil;
import org.apache.eventmesh.common.utils.LogUtils;
import org.apache.eventmesh.runtime.acl.Acl;
import org.apache.eventmesh.runtime.admin.controller.ClientManageController;
import org.apache.eventmesh.runtime.boot.EventMeshBootstrap;
import org.apache.eventmesh.runtime.boot.EventMeshGrpcBootstrap;
import org.apache.eventmesh.runtime.boot.EventMeshGrpcServer;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.boot.EventMeshHttpBootstrap;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.boot.EventMeshTcpBootstrap;
import org.apache.eventmesh.runtime.common.ServiceState;
import org.apache.eventmesh.runtime.core.protocol.http.producer.ProducerTopicManager;
import org.apache.eventmesh.runtime.meta.MetaStorage;
import org.apache.eventmesh.runtime.storage.StorageResource;
import org.apache.eventmesh.runtime.trace.Trace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMeshServer {
    private static final Logger log = LoggerFactory.getLogger(EventMeshServer.class);
    private final Acl acl;
    private MetaStorage metaStorage;
    private static Trace trace;
    private final StorageResource storageResource;
    private ServiceState serviceState;
    private ProducerTopicManager producerTopicManager;
    private final CommonConfiguration configuration = (CommonConfiguration)configService.buildConfigInstance(CommonConfiguration.class);
    private transient ClientManageController clientManageController;
    private static final List<EventMeshBootstrap> BOOTSTRAP_LIST;
    private static final String SERVER_STATE_MSG = "server state:{}";
    private static final ConfigService configService;

    public EventMeshServer() {
        AssertUtils.notNull((Object)this.configuration, (String)"configuration is null");
        this.acl = Acl.getInstance(this.configuration.getEventMeshSecurityPluginType());
        this.metaStorage = MetaStorage.getInstance(this.configuration.getEventMeshMetaStoragePluginType());
        trace = Trace.getInstance(this.configuration.getEventMeshTracePluginType(), this.configuration.isEventMeshServerTraceEnable());
        this.storageResource = StorageResource.getInstance(this.configuration.getEventMeshStoragePluginType());
        List provideServerProtocols = this.configuration.getEventMeshProvideServerProtocols();
        for (String provideServerProtocol : provideServerProtocols) {
            switch (provideServerProtocol.toUpperCase()) {
                case "HTTP": {
                    BOOTSTRAP_LIST.add(new EventMeshHttpBootstrap(this));
                    break;
                }
                case "TCP": {
                    BOOTSTRAP_LIST.add(new EventMeshTcpBootstrap(this));
                    break;
                }
                case "GRPC": {
                    BOOTSTRAP_LIST.add(new EventMeshGrpcBootstrap(this));
                    break;
                }
            }
        }
        if (BOOTSTRAP_LIST.isEmpty()) {
            BOOTSTRAP_LIST.add(new EventMeshTcpBootstrap(this));
        }
    }

    public void init() throws Exception {
        this.storageResource.init();
        if (this.configuration.isEventMeshServerSecurityEnable()) {
            this.acl.init();
        }
        if (this.configuration.isEventMeshServerMetaStorageEnable()) {
            this.metaStorage.init();
        }
        if (this.configuration.isEventMeshServerTraceEnable()) {
            trace.init();
        }
        EventMeshTCPServer eventMeshTCPServer = null;
        EventMeshGrpcServer eventMeshGrpcServer = null;
        EventMeshHTTPServer eventMeshHTTPServer = null;
        for (EventMeshBootstrap eventMeshBootstrap : BOOTSTRAP_LIST) {
            eventMeshBootstrap.init();
            if (eventMeshBootstrap instanceof EventMeshTcpBootstrap) {
                eventMeshTCPServer = ((EventMeshTcpBootstrap)eventMeshBootstrap).getEventMeshTcpServer();
            }
            if (eventMeshBootstrap instanceof EventMeshHttpBootstrap) {
                eventMeshHTTPServer = ((EventMeshHttpBootstrap)eventMeshBootstrap).getEventMeshHttpServer();
            }
            if (!(eventMeshBootstrap instanceof EventMeshGrpcBootstrap)) continue;
            eventMeshGrpcServer = ((EventMeshGrpcBootstrap)eventMeshBootstrap).getEventMeshGrpcServer();
        }
        if (Objects.nonNull(eventMeshTCPServer) && Objects.nonNull(eventMeshHTTPServer) && Objects.nonNull(eventMeshGrpcServer)) {
            this.clientManageController = new ClientManageController(eventMeshTCPServer, eventMeshHTTPServer, eventMeshGrpcServer, this.metaStorage);
            this.clientManageController.setAdminWebHookConfigOperationManage(eventMeshTCPServer.getAdminWebHookConfigOperationManage());
        }
        String eventStore = System.getProperty("eventstore", System.getenv("EVENT_STORE"));
        LogUtils.info((Logger)log, (String)"eventStore : {}", (Object)eventStore);
        this.producerTopicManager = new ProducerTopicManager(this);
        this.producerTopicManager.init();
        this.serviceState = ServiceState.INITED;
        LogUtils.info((Logger)log, (String)SERVER_STATE_MSG, (Object)((Object)this.serviceState));
    }

    public void start() throws Exception {
        if (Objects.nonNull(this.configuration)) {
            if (this.configuration.isEventMeshServerSecurityEnable()) {
                this.acl.start();
            }
            if (this.configuration.isEventMeshServerMetaStorageEnable()) {
                this.metaStorage.start();
            }
        }
        for (EventMeshBootstrap eventMeshBootstrap : BOOTSTRAP_LIST) {
            eventMeshBootstrap.start();
        }
        if (Objects.nonNull(this.clientManageController)) {
            this.clientManageController.start();
        }
        this.producerTopicManager.start();
        this.serviceState = ServiceState.RUNNING;
        LogUtils.info((Logger)log, (String)SERVER_STATE_MSG, (Object)((Object)this.serviceState));
    }

    public void shutdown() throws Exception {
        this.serviceState = ServiceState.STOPPING;
        LogUtils.info((Logger)log, (String)SERVER_STATE_MSG, (Object)((Object)this.serviceState));
        for (EventMeshBootstrap eventMeshBootstrap : BOOTSTRAP_LIST) {
            eventMeshBootstrap.shutdown();
        }
        if (this.configuration != null && this.configuration.isEventMeshServerMetaStorageEnable()) {
            this.metaStorage.shutdown();
        }
        this.storageResource.release();
        if (this.configuration != null && this.configuration.isEventMeshServerSecurityEnable()) {
            this.acl.shutdown();
        }
        if (this.configuration != null && this.configuration.isEventMeshServerTraceEnable()) {
            trace.shutdown();
        }
        this.producerTopicManager.shutdown();
        ConfigurationContextUtil.clear();
        this.serviceState = ServiceState.STOPPED;
        LogUtils.info((Logger)log, (String)SERVER_STATE_MSG, (Object)((Object)this.serviceState));
    }

    public static Trace getTrace() {
        return trace;
    }

    public ServiceState getServiceState() {
        return this.serviceState;
    }

    public MetaStorage getMetaStorage() {
        return this.metaStorage;
    }

    public void setMetaStorage(MetaStorage metaStorage) {
        this.metaStorage = metaStorage;
    }

    public Acl getAcl() {
        return this.acl;
    }

    public ProducerTopicManager getProducerTopicManager() {
        return this.producerTopicManager;
    }

    public CommonConfiguration getConfiguration() {
        return this.configuration;
    }

    static {
        BOOTSTRAP_LIST = new CopyOnWriteArrayList<EventMeshBootstrap>();
        configService = ConfigService.getInstance();
    }
}

