/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.boot;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.api.meta.MetaServiceListener;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.common.utils.LogUtils;
import org.apache.eventmesh.filter.pattern.Pattern;
import org.apache.eventmesh.filter.patternbuild.PatternBuilder;
import org.apache.eventmesh.runtime.core.protocol.http.consumer.ConsumerGroupManager;
import org.apache.eventmesh.runtime.core.protocol.http.consumer.ConsumerManager;
import org.apache.eventmesh.runtime.core.protocol.producer.EventMeshProducer;
import org.apache.eventmesh.runtime.core.protocol.producer.ProducerManager;
import org.apache.eventmesh.runtime.meta.MetaStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterEngine {
    private static final Logger log = LoggerFactory.getLogger(FilterEngine.class);
    private final Map<String, Pattern> filterPatternMap = new HashMap<String, Pattern>();
    private final String filterPrefix = "filter-";
    private final MetaStorage metaStorage;
    private MetaServiceListener metaServiceListener;
    private final ProducerManager producerManager;
    private final ConsumerManager consumerManager;
    private final ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();

    public FilterEngine(MetaStorage metaStorage, ProducerManager producerManager, ConsumerManager consumerManager) {
        this.metaStorage = metaStorage;
        this.producerManager = producerManager;
        this.consumerManager = consumerManager;
    }

    public void start() {
        Map<String, String> filterMetaData = this.metaStorage.getMetaData("filter-", true);
        for (Map.Entry<String, String> filterDataEntry : filterMetaData.entrySet()) {
            String key = filterDataEntry.getKey();
            String value = filterDataEntry.getValue();
            this.updateFilterPatternMap(key, value);
        }
        this.metaServiceListener = this::updateFilterPatternMap;
        this.scheduledExecutorService.scheduleAtFixedRate(() -> {
            ConcurrentHashMap<String, EventMeshProducer> producerMap = this.producerManager.getProducerTable();
            for (String producerGroup : producerMap.keySet()) {
                for (String filterKey : this.filterPatternMap.keySet()) {
                    if (StringUtils.contains((CharSequence)filterKey, (CharSequence)producerGroup)) continue;
                    this.addFilterListener(producerGroup);
                    LogUtils.info((Logger)log, (String)("addFilterListener for producer group: " + producerGroup));
                }
            }
            ConcurrentHashMap<String, ConsumerGroupManager> consumerMap = this.consumerManager.getClientTable();
            for (String consumerGroup : consumerMap.keySet()) {
                for (String filterKey : this.filterPatternMap.keySet()) {
                    if (StringUtils.contains((CharSequence)filterKey, (CharSequence)consumerGroup)) continue;
                    this.addFilterListener(consumerGroup);
                    LogUtils.info((Logger)log, (String)("addFilterListener for consumer group: " + consumerGroup));
                }
            }
        }, 10000L, 5000L, TimeUnit.MILLISECONDS);
    }

    private void updateFilterPatternMap(String key, String value) {
        String group = StringUtils.substringAfter((String)key, (String)"filter-");
        JsonNode filterJsonNodeArray = JsonUtils.getJsonNode((String)value);
        if (filterJsonNodeArray != null) {
            for (JsonNode filterJsonNode : filterJsonNodeArray) {
                String topic = filterJsonNode.get("topic").asText();
                String filterCondition = filterJsonNode.get("condition").toString();
                Pattern filterPattern = PatternBuilder.build((String)filterCondition);
                this.filterPatternMap.put(group + "-" + topic, filterPattern);
            }
        }
        this.addFilterListener(group);
    }

    public void addFilterListener(String group) {
        String filterKey = "filter-" + group;
        try {
            this.metaStorage.getMetaDataWithListener(this.metaServiceListener, filterKey);
        }
        catch (Exception e) {
            throw new RuntimeException("addFilterListener exception", e);
        }
    }

    public void shutdown() {
        this.scheduledExecutorService.shutdown();
    }

    public Pattern getFilterPattern(String key) {
        return this.filterPatternMap.get(key);
    }
}

