/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.boot;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.api.meta.MetaServiceListener;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.common.utils.LogUtils;
import org.apache.eventmesh.runtime.core.protocol.http.consumer.ConsumerGroupManager;
import org.apache.eventmesh.runtime.core.protocol.http.consumer.ConsumerManager;
import org.apache.eventmesh.runtime.core.protocol.producer.EventMeshProducer;
import org.apache.eventmesh.runtime.core.protocol.producer.ProducerManager;
import org.apache.eventmesh.runtime.meta.MetaStorage;
import org.apache.eventmesh.transformer.Transformer;
import org.apache.eventmesh.transformer.TransformerBuilder;
import org.apache.eventmesh.transformer.TransformerParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformerEngine {
    private static final Logger log = LoggerFactory.getLogger(TransformerEngine.class);
    private final Map<String, Transformer> transformerMap = new HashMap<String, Transformer>();
    private final String transformerPrefix = "transformer-";
    private final MetaStorage metaStorage;
    private MetaServiceListener metaServiceListener;
    private final ProducerManager producerManager;
    private final ConsumerManager consumerManager;
    private final ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();

    public TransformerEngine(MetaStorage metaStorage, ProducerManager producerManager, ConsumerManager consumerManager) {
        this.metaStorage = metaStorage;
        this.producerManager = producerManager;
        this.consumerManager = consumerManager;
    }

    public void start() {
        Map<String, String> transformerMetaData = this.metaStorage.getMetaData("transformer-", true);
        for (Map.Entry<String, String> transformerDataEntry : transformerMetaData.entrySet()) {
            String key = transformerDataEntry.getKey();
            String value = transformerDataEntry.getValue();
            this.updateTransformerMap(key, value);
        }
        this.metaServiceListener = this::updateTransformerMap;
        this.scheduledExecutorService.scheduleAtFixedRate(() -> {
            ConcurrentHashMap<String, EventMeshProducer> producerMap = this.producerManager.getProducerTable();
            for (String producerGroup : producerMap.keySet()) {
                for (String transformerKey : this.transformerMap.keySet()) {
                    if (StringUtils.contains((CharSequence)transformerKey, (CharSequence)producerGroup)) continue;
                    this.addTransformerListener(producerGroup);
                    LogUtils.info((Logger)log, (String)("addTransformerListener for producer group: " + producerGroup));
                }
            }
            ConcurrentHashMap<String, ConsumerGroupManager> consumerMap = this.consumerManager.getClientTable();
            for (String consumerGroup : consumerMap.keySet()) {
                for (String transformerKey : this.transformerMap.keySet()) {
                    if (StringUtils.contains((CharSequence)transformerKey, (CharSequence)consumerGroup)) continue;
                    this.addTransformerListener(consumerGroup);
                    LogUtils.info((Logger)log, (String)("addTransformerListener for consumer group: " + consumerGroup));
                }
            }
        }, 10000L, 5000L, TimeUnit.MILLISECONDS);
    }

    private void updateTransformerMap(String key, String value) {
        String group = StringUtils.substringAfter((String)key, (String)"transformer-");
        JsonNode transformerJsonNodeArray = JsonUtils.getJsonNode((String)value);
        if (transformerJsonNodeArray != null) {
            for (JsonNode transformerJsonNode : transformerJsonNodeArray) {
                String topic = transformerJsonNode.get("topic").asText();
                String transformerParam = transformerJsonNode.get("transformerParam").toString();
                TransformerParam tfp = (TransformerParam)JsonUtils.parseObject((String)transformerParam, TransformerParam.class);
                Transformer transformer = TransformerBuilder.buildTransformer((TransformerParam)tfp);
                this.transformerMap.put(group + "-" + topic, transformer);
            }
        }
        this.addTransformerListener(group);
    }

    public void addTransformerListener(String group) {
        String transformerKey = "transformer-" + group;
        try {
            this.metaStorage.getMetaDataWithListener(this.metaServiceListener, transformerKey);
        }
        catch (Exception e) {
            throw new RuntimeException("addTransformerListener exception", e);
        }
    }

    public void shutdown() {
        this.scheduledExecutorService.shutdown();
    }

    public Transformer getTransformer(String key) {
        return this.transformerMap.get(key);
    }
}

