/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.consumer;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.protocol.SubscriptionItem;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.runtime.core.consumer.ClientInfo;
import org.apache.eventmesh.runtime.core.consumergroup.ConsumerGroupConf;
import org.apache.eventmesh.runtime.core.consumergroup.ConsumerGroupMetadata;
import org.apache.eventmesh.runtime.core.consumergroup.ConsumerGroupTopicConf;
import org.apache.eventmesh.runtime.core.consumergroup.ConsumerGroupTopicMetadata;
import org.apache.eventmesh.runtime.core.protocol.http.processor.inf.Client;
import org.apache.eventmesh.runtime.meta.MetaStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionManager {
    private static final Logger log = LoggerFactory.getLogger(SubscriptionManager.class);
    private final boolean isEventMeshServerMetaStorageEnable;
    private final MetaStorage metaStorage;
    private final ConcurrentHashMap<String, ConsumerGroupConf> localConsumerGroupMapping = new ConcurrentHashMap(64);
    private final ConcurrentHashMap<String, List<Client>> localClientInfoMapping = new ConcurrentHashMap(64);

    public SubscriptionManager(boolean isEventMeshServerMetaStorageEnable, MetaStorage metaStorage) {
        this.isEventMeshServerMetaStorageEnable = isEventMeshServerMetaStorageEnable;
        this.metaStorage = metaStorage;
    }

    public ConcurrentHashMap<String, ConsumerGroupConf> getLocalConsumerGroupMapping() {
        return this.localConsumerGroupMapping;
    }

    public ConcurrentHashMap<String, List<Client>> getLocalClientInfoMapping() {
        return this.localClientInfoMapping;
    }

    public void registerClient(ClientInfo clientInfo, String consumerGroup, List<SubscriptionItem> subscriptionItems, String url) {
        for (SubscriptionItem subscription : subscriptionItems) {
            String groupTopicKey = consumerGroup + "@" + subscription.getTopic();
            List<Client> localClients = this.localClientInfoMapping.get(groupTopicKey);
            if (localClients == null) {
                this.localClientInfoMapping.putIfAbsent(groupTopicKey, new ArrayList());
                localClients = this.localClientInfoMapping.get(groupTopicKey);
            }
            boolean isContains = false;
            for (Client localClient : localClients) {
                if (!StringUtils.equals((CharSequence)localClient.getUrl(), (CharSequence)url)) continue;
                isContains = true;
                localClient.setLastUpTime(new Date());
                break;
            }
            if (isContains) continue;
            Client client = new Client();
            client.setEnv(clientInfo.getEnv());
            client.setIdc(clientInfo.getIdc());
            client.setSys(clientInfo.getSys());
            client.setIp(clientInfo.getIp());
            client.setPid(clientInfo.getPid());
            client.setConsumerGroup(consumerGroup);
            client.setTopic(subscription.getTopic());
            client.setUrl(url);
            client.setLastUpTime(new Date());
            localClients.add(client);
        }
    }

    public void updateSubscription(ClientInfo clientInfo, String consumerGroup, String url, List<SubscriptionItem> subscriptionList) {
        for (SubscriptionItem subscription : subscriptionList) {
            ConsumerGroupTopicConf consumerGroupTopicConf;
            ConsumerGroupConf consumerGroupConf;
            List<Client> groupTopicClients = this.localClientInfoMapping.get(consumerGroup + "@" + subscription.getTopic());
            if (CollectionUtils.isEmpty(groupTopicClients)) {
                log.error("group {} topic {} clients is empty", (Object)consumerGroup, (Object)subscription);
            }
            if ((consumerGroupConf = this.localConsumerGroupMapping.get(consumerGroup)) == null) {
                ConsumerGroupConf prev = this.localConsumerGroupMapping.putIfAbsent(consumerGroup, new ConsumerGroupConf(consumerGroup));
                if (prev == null) {
                    log.info("add new subscription, consumer group: {}", (Object)consumerGroup);
                }
                consumerGroupConf = this.localConsumerGroupMapping.get(consumerGroup);
            }
            if ((consumerGroupTopicConf = consumerGroupConf.getConsumerGroupTopicConf().get(subscription.getTopic())) == null) {
                consumerGroupConf.getConsumerGroupTopicConf().computeIfAbsent(subscription.getTopic(), topic -> {
                    ConsumerGroupTopicConf newTopicConf = new ConsumerGroupTopicConf();
                    newTopicConf.setConsumerGroup(consumerGroup);
                    newTopicConf.setTopic((String)topic);
                    newTopicConf.setSubscriptionItem(subscription);
                    log.info("add new {}", (Object)newTopicConf);
                    return newTopicConf;
                });
                consumerGroupTopicConf = consumerGroupConf.getConsumerGroupTopicConf().get(subscription.getTopic());
            }
            consumerGroupTopicConf.getUrls().add(url);
            if (!consumerGroupTopicConf.getIdcUrls().containsKey(clientInfo.getIdc())) {
                consumerGroupTopicConf.getIdcUrls().putIfAbsent(clientInfo.getIdc(), new ArrayList());
            }
            consumerGroupTopicConf.getIdcUrls().get(clientInfo.getIdc()).add(url);
        }
    }

    public void updateMetaData() {
        if (!this.isEventMeshServerMetaStorageEnable) {
            return;
        }
        try {
            HashMap<String, String> metadata = new HashMap<String, String>(16);
            for (Map.Entry<String, ConsumerGroupConf> consumerGroupMap : this.getLocalConsumerGroupMapping().entrySet()) {
                String consumerGroupKey = consumerGroupMap.getKey();
                ConsumerGroupConf consumerGroupConf = consumerGroupMap.getValue();
                ConsumerGroupMetadata consumerGroupMetadata = new ConsumerGroupMetadata();
                consumerGroupMetadata.setConsumerGroup(consumerGroupKey);
                HashMap<String, ConsumerGroupTopicMetadata> consumerGroupTopicMetadataMap = new HashMap<String, ConsumerGroupTopicMetadata>(16);
                for (Map.Entry<String, ConsumerGroupTopicConf> consumerGroupTopicConfEntry : consumerGroupConf.getConsumerGroupTopicConf().entrySet()) {
                    String topic = consumerGroupTopicConfEntry.getKey();
                    ConsumerGroupTopicConf consumerGroupTopicConf = consumerGroupTopicConfEntry.getValue();
                    ConsumerGroupTopicMetadata consumerGroupTopicMetadata = new ConsumerGroupTopicMetadata();
                    consumerGroupTopicMetadata.setConsumerGroup(consumerGroupTopicConf.getConsumerGroup());
                    consumerGroupTopicMetadata.setTopic(consumerGroupTopicConf.getTopic());
                    consumerGroupTopicMetadata.setUrls(consumerGroupTopicConf.getUrls());
                    consumerGroupTopicMetadataMap.put(topic, consumerGroupTopicMetadata);
                }
                consumerGroupMetadata.setConsumerGroupTopicMetadataMap(consumerGroupTopicMetadataMap);
                metadata.put(consumerGroupKey, JsonUtils.toJSONString((Object)consumerGroupMetadata));
            }
            metadata.put("protocol", "http");
            this.metaStorage.updateMetaData(metadata);
        }
        catch (Exception e) {
            log.error("update eventmesh metadata error", (Throwable)e);
        }
    }
}

