/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol;

import io.cloudevents.CloudEvent;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.eventmesh.common.config.CommonConfiguration;
import org.apache.eventmesh.retry.api.conf.RetryConfiguration;
import org.apache.eventmesh.retry.api.strategy.RetryStrategy;
import org.apache.eventmesh.retry.api.timer.TimerTask;
import org.apache.eventmesh.runtime.core.protocol.consumer.HandleMessageContext;
import org.apache.eventmesh.runtime.core.protocol.producer.EventMeshProducer;
import org.apache.eventmesh.runtime.core.protocol.producer.ProducerManager;
import org.apache.eventmesh.spi.EventMeshExtensionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RetryContext
implements TimerTask {
    private static final Logger log = LoggerFactory.getLogger(RetryContext.class);
    private static final Set<String> RETRY_STRATEGY_PROCESSED_EVENT_LIST = Collections.synchronizedSet(new HashSet());
    public CloudEvent event;
    public String seq;
    public int retryTimes;
    public CommonConfiguration commonConfiguration;
    public long executeTime = System.currentTimeMillis();

    public void setEvent(CloudEvent event) {
        this.event = event;
    }

    public void setExecuteTimeHook(long executeTime) {
        this.executeTime = executeTime;
    }

    public final void run() throws Exception {
        String eventMeshRetryPluginType = Optional.ofNullable(this.commonConfiguration.getEventMeshRetryPluginType()).orElse("default");
        if ("default".equals(eventMeshRetryPluginType)) {
            log.warn("Because eventmesh retry plugin is default, retry in memory.");
            this.doRun();
            return;
        }
        if (!eventMeshRetryPluginType.equals(this.commonConfiguration.getEventMeshStoragePluginType())) {
            log.warn("Because eventmesh retry plugin type mismatched with storage plugin type, retry in memory.");
            this.doRun();
            return;
        }
        Optional<Object> retryStrategy = Optional.ofNullable(EventMeshExtensionFactory.getExtension(RetryStrategy.class, (String)this.commonConfiguration.getEventMeshRetryPluginType()));
        if (!retryStrategy.isPresent()) {
            log.warn("Storage retry SPI not found, retry in memory.");
            this.doRun();
            return;
        }
        if (!RETRY_STRATEGY_PROCESSED_EVENT_LIST.contains(this.event.getId())) {
            String consumerGroupName = this.getHandleMessageContext().getConsumerGroup();
            EventMeshProducer producer = this.getProducerManager().getEventMeshProducer(consumerGroupName);
            RetryConfiguration retryConfiguration = RetryConfiguration.builder().event(this.event).consumerGroupName(consumerGroupName).producer(producer.getMqProducerWrapper().getMeshMQProducer()).topic(this.getHandleMessageContext().getTopic()).build();
            ((RetryStrategy)retryStrategy.get()).retry(retryConfiguration);
            RETRY_STRATEGY_PROCESSED_EVENT_LIST.add(this.event.getId());
        } else {
            RETRY_STRATEGY_PROCESSED_EVENT_LIST.remove(this.event.getId());
            this.getHandleMessageContext().finish();
        }
    }

    protected HandleMessageContext getHandleMessageContext() throws Exception {
        throw new IllegalAccessException("method not supported.");
    }

    public abstract void doRun() throws Exception;

    protected ProducerManager getProducerManager() {
        throw new IllegalAccessException("method not supported.");
    }
}

