/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.grpc.consumer;

import io.cloudevents.CloudEvent;
import io.cloudevents.core.builder.CloudEventBuilder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.MapUtils;
import org.apache.eventmesh.api.AbstractContext;
import org.apache.eventmesh.api.EventListener;
import org.apache.eventmesh.api.EventMeshAction;
import org.apache.eventmesh.api.EventMeshAsyncConsumeContext;
import org.apache.eventmesh.api.SendCallback;
import org.apache.eventmesh.api.SendResult;
import org.apache.eventmesh.api.exception.OnExceptionContext;
import org.apache.eventmesh.common.protocol.SubscriptionItem;
import org.apache.eventmesh.common.protocol.SubscriptionMode;
import org.apache.eventmesh.common.protocol.grpc.common.GrpcType;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.common.utils.LogUtils;
import org.apache.eventmesh.common.utils.ThreadUtils;
import org.apache.eventmesh.runtime.boot.EventMeshGrpcServer;
import org.apache.eventmesh.runtime.common.ServiceState;
import org.apache.eventmesh.runtime.configuration.EventMeshGrpcConfiguration;
import org.apache.eventmesh.runtime.core.consumergroup.ConsumerGroupMetadata;
import org.apache.eventmesh.runtime.core.consumergroup.ConsumerGroupTopicMetadata;
import org.apache.eventmesh.runtime.core.plugin.MQConsumerWrapper;
import org.apache.eventmesh.runtime.core.protocol.grpc.consumer.consumergroup.ConsumerGroupClient;
import org.apache.eventmesh.runtime.core.protocol.grpc.consumer.consumergroup.ConsumerGroupTopicConfig;
import org.apache.eventmesh.runtime.core.protocol.grpc.consumer.consumergroup.StreamTopicConfig;
import org.apache.eventmesh.runtime.core.protocol.grpc.consumer.consumergroup.WebhookTopicConfig;
import org.apache.eventmesh.runtime.core.protocol.grpc.push.HandleMsgContext;
import org.apache.eventmesh.runtime.core.protocol.grpc.push.MessageHandler;
import org.apache.eventmesh.runtime.core.protocol.producer.EventMeshProducer;
import org.apache.eventmesh.runtime.core.protocol.producer.SendMessageContext;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMeshConsumer {
    private static final Logger log = LoggerFactory.getLogger(EventMeshConsumer.class);
    private final String consumerGroup;
    private final EventMeshGrpcServer eventMeshGrpcServer;
    private final EventMeshGrpcConfiguration eventMeshGrpcConfiguration;
    private final MQConsumerWrapper persistentMqConsumer;
    private final MQConsumerWrapper broadcastMqConsumer;
    private final MessageHandler messageHandler;
    private ServiceState serviceState;
    private final Map<String, ConsumerGroupTopicConfig> consumerGroupTopicConfig = new ConcurrentHashMap<String, ConsumerGroupTopicConfig>();

    public EventMeshConsumer(EventMeshGrpcServer eventMeshGrpcServer, String consumerGroup) {
        this.eventMeshGrpcServer = eventMeshGrpcServer;
        this.eventMeshGrpcConfiguration = eventMeshGrpcServer.getEventMeshGrpcConfiguration();
        this.consumerGroup = consumerGroup;
        this.messageHandler = new MessageHandler(consumerGroup, eventMeshGrpcServer.getPushMsgExecutor());
        this.persistentMqConsumer = new MQConsumerWrapper(this.eventMeshGrpcConfiguration.getEventMeshStoragePluginType());
        this.broadcastMqConsumer = new MQConsumerWrapper(this.eventMeshGrpcConfiguration.getEventMeshStoragePluginType());
    }

    public synchronized boolean registerClient(ConsumerGroupClient client) {
        boolean requireRestart = false;
        ConsumerGroupTopicConfig topicConfig = this.consumerGroupTopicConfig.get(client.getTopic());
        if (topicConfig == null) {
            topicConfig = ConsumerGroupTopicConfig.buildTopicConfig(this.consumerGroup, client.getTopic(), client.getSubscriptionMode(), client.getGrpcType());
            this.consumerGroupTopicConfig.put(client.getTopic(), topicConfig);
            requireRestart = true;
        }
        topicConfig.registerClient(client);
        this.updateMetaData();
        return requireRestart;
    }

    public synchronized boolean deregisterClient(ConsumerGroupClient client) {
        boolean requireRestart = false;
        ConsumerGroupTopicConfig topicConfig = this.consumerGroupTopicConfig.get(client.getTopic());
        if (topicConfig != null) {
            topicConfig.deregisterClient(client);
            if (topicConfig.getSize() == 0) {
                this.consumerGroupTopicConfig.remove(client.getTopic());
                requireRestart = true;
            }
        }
        this.updateMetaData();
        return requireRestart;
    }

    public void updateMetaData() {
        if (!this.eventMeshGrpcConfiguration.isEventMeshServerMetaStorageEnable()) {
            return;
        }
        try {
            HashMap<String, String> metadata = new HashMap<String, String>(16);
            for (Map.Entry<String, ConsumerGroupTopicConfig> consumerGroupMap : this.consumerGroupTopicConfig.entrySet()) {
                ConsumerGroupTopicMetadata consumerGroupTopicMetadata;
                String topic = consumerGroupMap.getKey();
                ConsumerGroupTopicConfig cgtConfig = consumerGroupMap.getValue();
                GrpcType grpcType = cgtConfig.getGrpcType();
                String consumerGroupKey = cgtConfig.getConsumerGroup();
                ConsumerGroupMetadata consumerGroupMetadata = new ConsumerGroupMetadata();
                HashMap<String, ConsumerGroupTopicMetadata> consumerGroupTopicMetadataMap = new HashMap<String, ConsumerGroupTopicMetadata>(16);
                consumerGroupMetadata.setConsumerGroup(consumerGroupKey);
                if (GrpcType.STREAM == grpcType) {
                    StreamTopicConfig streamTopicConfig = (StreamTopicConfig)cgtConfig;
                    consumerGroupTopicMetadata = new ConsumerGroupTopicMetadata();
                    consumerGroupTopicMetadata.setConsumerGroup(streamTopicConfig.getConsumerGroup());
                    consumerGroupTopicMetadata.setTopic(streamTopicConfig.getTopic());
                    HashSet<String> clientSet = new HashSet<String>();
                    streamTopicConfig.getIdcEmitterMap().values().forEach(stringEmitterMap -> clientSet.addAll(stringEmitterMap.keySet()));
                    consumerGroupTopicMetadata.setUrls(clientSet);
                    consumerGroupTopicMetadataMap.put(topic, consumerGroupTopicMetadata);
                } else {
                    WebhookTopicConfig webhookTopicConfig = (WebhookTopicConfig)cgtConfig;
                    consumerGroupTopicMetadata = new ConsumerGroupTopicMetadata();
                    consumerGroupTopicMetadata.setConsumerGroup(webhookTopicConfig.getConsumerGroup());
                    consumerGroupTopicMetadata.setTopic(webhookTopicConfig.getTopic());
                    HashSet<String> set = new HashSet<String>(webhookTopicConfig.getTotalUrls());
                    consumerGroupTopicMetadata.setUrls(set);
                    consumerGroupTopicMetadataMap.put(topic, consumerGroupTopicMetadata);
                }
                consumerGroupMetadata.setConsumerGroupTopicMetadataMap(consumerGroupTopicMetadataMap);
                metadata.put(consumerGroupKey, JsonUtils.toJSONString((Object)consumerGroupMetadata));
            }
            metadata.put("protocol", "grpc");
            this.eventMeshGrpcServer.getMetaStorage().updateMetaData(metadata);
        }
        catch (Exception e) {
            log.error("update eventmesh metadata error", (Throwable)e);
        }
    }

    public synchronized void init() throws Exception {
        if (MapUtils.isEmpty(this.consumerGroupTopicConfig)) {
            return;
        }
        Properties keyValue = new Properties();
        keyValue.put("isBroadcast", "false");
        keyValue.put("consumerGroup", this.consumerGroup);
        keyValue.put("eventMeshIDC", this.eventMeshGrpcConfiguration.getEventMeshIDC());
        keyValue.put("instanceName", EventMeshUtil.buildMeshClientID(this.consumerGroup, this.eventMeshGrpcConfiguration.getEventMeshCluster()));
        this.persistentMqConsumer.init(keyValue);
        this.persistentMqConsumer.registerEventListener(this.createEventListener(SubscriptionMode.CLUSTERING));
        Properties broadcastKeyValue = new Properties();
        broadcastKeyValue.put("isBroadcast", "true");
        broadcastKeyValue.put("consumerGroup", this.consumerGroup);
        broadcastKeyValue.put("eventMeshIDC", this.eventMeshGrpcConfiguration.getEventMeshIDC());
        broadcastKeyValue.put("instanceName", EventMeshUtil.buildMeshClientID(this.consumerGroup, this.eventMeshGrpcConfiguration.getEventMeshCluster()));
        this.broadcastMqConsumer.init(broadcastKeyValue);
        this.broadcastMqConsumer.registerEventListener(this.createEventListener(SubscriptionMode.BROADCASTING));
        this.serviceState = ServiceState.INITED;
        LogUtils.info((Logger)log, (String)"EventMeshConsumer [{}] initialized.............", (Object)this.consumerGroup);
    }

    public synchronized void start() throws Exception {
        if (MapUtils.isEmpty(this.consumerGroupTopicConfig)) {
            return;
        }
        this.consumerGroupTopicConfig.forEach((k, v) -> {
            try {
                this.subscribe((String)k, v.getSubscriptionMode());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        this.persistentMqConsumer.start();
        this.broadcastMqConsumer.start();
        this.serviceState = ServiceState.RUNNING;
        LogUtils.info((Logger)log, (String)"EventMeshConsumer [{}] started..........", (Object)this.consumerGroup);
    }

    public synchronized void shutdown() throws Exception {
        this.persistentMqConsumer.shutdown();
        this.broadcastMqConsumer.shutdown();
        this.serviceState = ServiceState.STOPPED;
        LogUtils.info((Logger)log, (String)"EventMeshConsumer [{}] shutdown.........", (Object)this.consumerGroup);
    }

    public ServiceState getStatus() {
        return this.serviceState;
    }

    public void subscribe(String topic, SubscriptionMode subscriptionMode) throws Exception {
        switch (subscriptionMode) {
            case CLUSTERING: {
                this.persistentMqConsumer.subscribe(topic);
                break;
            }
            case BROADCASTING: {
                this.broadcastMqConsumer.subscribe(topic);
                break;
            }
            default: {
                throw new Exception("Subscribe Failed. Incorrect Subscription Mode");
            }
        }
    }

    public void unsubscribe(SubscriptionItem subscriptionItem) throws Exception {
        SubscriptionMode mode = subscriptionItem.getMode();
        String topic = subscriptionItem.getTopic();
        switch (mode) {
            case CLUSTERING: {
                this.persistentMqConsumer.unsubscribe(topic);
                break;
            }
            case BROADCASTING: {
                this.broadcastMqConsumer.unsubscribe(topic);
                break;
            }
            default: {
                throw new Exception("Unsubscribe Failed. Incorrect Subscription Mode");
            }
        }
    }

    public void updateOffset(SubscriptionMode subscriptionMode, List<CloudEvent> events, AbstractContext context) throws Exception {
        switch (subscriptionMode) {
            case CLUSTERING: {
                this.persistentMqConsumer.updateOffset(events, context);
                break;
            }
            case BROADCASTING: {
                this.broadcastMqConsumer.updateOffset(events, context);
                break;
            }
            default: {
                throw new Exception("Subscribe Failed. Incorrect Subscription Mode");
            }
        }
    }

    private EventListener createEventListener(SubscriptionMode subscriptionMode) {
        return (event, context) -> {
            event = CloudEventBuilder.from((CloudEvent)event).withExtension("reqmq2eventmeshtimestamp", String.valueOf(System.currentTimeMillis())).build();
            String topic = event.getSubject();
            String bizSeqNo = Optional.ofNullable((String)event.getExtension("searchkeys")).orElse("");
            String uniqueId = Optional.ofNullable((String)event.getExtension("rmbuniqid")).orElse("");
            if (log.isDebugEnabled()) {
                log.debug("message|mq2eventMesh|topic={}|msg={}", (Object)topic, (Object)event);
            } else {
                if (log.isInfoEnabled()) {
                    log.info("message|mq2eventMesh|topic={}|bizSeqNo={}|uniqueId={}", new Object[]{topic, bizSeqNo, uniqueId});
                }
                this.eventMeshGrpcServer.getMetricsMonitor().recordReceiveMsgFromQueue();
            }
            EventMeshAsyncConsumeContext eventMeshAsyncConsumeContext = (EventMeshAsyncConsumeContext)context;
            ConsumerGroupTopicConfig topicConfig = this.consumerGroupTopicConfig.get(topic);
            if (topicConfig != null) {
                HandleMsgContext handleMsgContext = new HandleMsgContext(this.consumerGroup, event, subscriptionMode, topicConfig.getGrpcType(), eventMeshAsyncConsumeContext.getAbstractContext(), this.eventMeshGrpcServer, this, topicConfig);
                if (this.messageHandler.handle(handleMsgContext)) {
                    eventMeshAsyncConsumeContext.commit(EventMeshAction.ManualAck);
                    return;
                }
                try {
                    ThreadUtils.sleep((long)5L, (TimeUnit)TimeUnit.SECONDS);
                    this.sendMessageBack(this.consumerGroup, event, uniqueId, bizSeqNo);
                }
                catch (Exception exception) {}
            } else {
                LogUtils.debug((Logger)log, (String)"no active consumer for topic={}|msg={}", (Object)topic, (Object)event);
            }
            eventMeshAsyncConsumeContext.commit(EventMeshAction.CommitMessage);
        };
    }

    public void sendMessageBack(final String consumerGroup, CloudEvent event, final String uniqueId, final String bizSeqNo) throws Exception {
        EventMeshProducer producer = this.eventMeshGrpcServer.getProducerManager().getEventMeshProducer(consumerGroup);
        if (producer == null) {
            LogUtils.warn((Logger)log, (String)"consumer:{} consume fail, sendMessageBack, bizSeqNo:{}, uniqueId:{}", (Object[])new Object[]{consumerGroup, bizSeqNo, uniqueId});
            return;
        }
        SendMessageContext sendMessageBackContext = new SendMessageContext(bizSeqNo, event, producer, this.eventMeshGrpcServer);
        producer.send(sendMessageBackContext, new SendCallback(){

            public void onSuccess(SendResult sendResult) {
            }

            public void onException(OnExceptionContext context) {
                LogUtils.warn((Logger)log, (String)"consumer:{} consume fail, sendMessageBack, bizSeqNo:{}, uniqueId:{}", (Object[])new Object[]{consumerGroup, bizSeqNo, uniqueId});
            }
        });
    }
}

