/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.grpc.processor;

import org.apache.eventmesh.api.SendCallback;
import org.apache.eventmesh.api.SendResult;
import org.apache.eventmesh.api.exception.OnExceptionContext;
import org.apache.eventmesh.common.protocol.ProtocolTransportObject;
import org.apache.eventmesh.common.protocol.grpc.cloudevents.CloudEvent;
import org.apache.eventmesh.common.protocol.grpc.common.EventMeshCloudEventUtils;
import org.apache.eventmesh.common.protocol.grpc.common.EventMeshCloudEventWrapper;
import org.apache.eventmesh.common.protocol.grpc.common.StatusCode;
import org.apache.eventmesh.protocol.api.ProtocolAdaptor;
import org.apache.eventmesh.protocol.api.ProtocolPluginFactory;
import org.apache.eventmesh.runtime.boot.EventMeshGrpcServer;
import org.apache.eventmesh.runtime.core.protocol.grpc.processor.AbstractPublishCloudEventProcessor;
import org.apache.eventmesh.runtime.core.protocol.grpc.service.EventEmitter;
import org.apache.eventmesh.runtime.core.protocol.grpc.service.ServiceUtils;
import org.apache.eventmesh.runtime.core.protocol.producer.EventMeshProducer;
import org.apache.eventmesh.runtime.core.protocol.producer.ProducerManager;
import org.apache.eventmesh.runtime.core.protocol.producer.SendMessageContext;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublishCloudEventsProcessor
extends AbstractPublishCloudEventProcessor {
    private static final Logger log = LoggerFactory.getLogger(PublishCloudEventsProcessor.class);

    public PublishCloudEventsProcessor(EventMeshGrpcServer eventMeshGrpcServer) {
        super(eventMeshGrpcServer, eventMeshGrpcServer.getAcl());
    }

    @Override
    public void handleCloudEvent(CloudEvent message, final EventEmitter<CloudEvent> emitter) throws Exception {
        String protocolType = EventMeshCloudEventUtils.getProtocolType((CloudEvent)message);
        ProtocolAdaptor grpcCommandProtocolAdaptor = ProtocolPluginFactory.getProtocolAdaptor((String)protocolType);
        io.cloudevents.CloudEvent cloudEvent = grpcCommandProtocolAdaptor.toCloudEvent((ProtocolTransportObject)new EventMeshCloudEventWrapper(message));
        final String seqNum = EventMeshCloudEventUtils.getSeqNum((CloudEvent)message);
        final String uniqueId = EventMeshCloudEventUtils.getUniqueId((CloudEvent)message);
        final String topic = EventMeshCloudEventUtils.getSubject((CloudEvent)message);
        String producerGroup = EventMeshCloudEventUtils.getProducerGroup((CloudEvent)message);
        ProducerManager producerManager = this.eventMeshGrpcServer.getProducerManager();
        EventMeshProducer eventMeshProducer = producerManager.getEventMeshProducer(producerGroup);
        SendMessageContext sendMessageContext = new SendMessageContext(seqNum, cloudEvent, eventMeshProducer, this.eventMeshGrpcServer);
        this.eventMeshGrpcServer.getMetricsMonitor().recordSendMsgToQueue();
        final long startTime = System.currentTimeMillis();
        eventMeshProducer.send(sendMessageContext, new SendCallback(){

            public void onSuccess(SendResult sendResult) {
                ServiceUtils.sendResponseCompleted(StatusCode.SUCCESS, sendResult.toString(), emitter);
                long endTime = System.currentTimeMillis();
                log.info("message|eventMesh2mq|REQ|ASYNC|send2MQCost={}ms|topic={}|bizSeqNo={}|uniqueId={}", new Object[]{endTime - startTime, topic, seqNum, uniqueId});
                PublishCloudEventsProcessor.this.eventMeshGrpcServer.getMetricsMonitor().recordSendMsgToClient();
            }

            public void onException(OnExceptionContext context) {
                ServiceUtils.sendResponseCompleted(StatusCode.EVENTMESH_SEND_ASYNC_MSG_ERR, EventMeshUtil.stackTrace((Throwable)context.getException(), 2), emitter);
                long endTime = System.currentTimeMillis();
                log.error("message|eventMesh2mq|REQ|ASYNC|send2MQCost={}ms|topic={}|bizSeqNo={}|uniqueId={}", new Object[]{endTime - startTime, topic, seqNum, uniqueId, context.getException()});
            }
        });
    }
}

