/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.grpc.push;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.eventmesh.api.AbstractContext;
import org.apache.eventmesh.common.protocol.ProtocolTransportObject;
import org.apache.eventmesh.common.protocol.SubscriptionMode;
import org.apache.eventmesh.common.protocol.grpc.cloudevents.CloudEvent;
import org.apache.eventmesh.common.protocol.grpc.common.EventMeshCloudEventUtils;
import org.apache.eventmesh.common.protocol.grpc.common.EventMeshCloudEventWrapper;
import org.apache.eventmesh.protocol.api.ProtocolAdaptor;
import org.apache.eventmesh.protocol.api.ProtocolPluginFactory;
import org.apache.eventmesh.runtime.boot.EventMeshGrpcServer;
import org.apache.eventmesh.runtime.configuration.EventMeshGrpcConfiguration;
import org.apache.eventmesh.runtime.core.protocol.RetryContext;
import org.apache.eventmesh.runtime.core.protocol.grpc.consumer.EventMeshConsumer;
import org.apache.eventmesh.runtime.core.protocol.grpc.push.HandleMsgContext;
import org.apache.eventmesh.runtime.core.protocol.grpc.push.WebhookPushRequest;
import org.apache.eventmesh.runtime.core.protocol.grpc.retry.GrpcRetryer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPushRequest
extends RetryContext {
    private static final Logger log = LoggerFactory.getLogger(AbstractPushRequest.class);
    protected EventMeshGrpcServer eventMeshGrpcServer;
    protected long createTime = System.currentTimeMillis();
    protected long lastPushTime = System.currentTimeMillis();
    protected EventMeshConsumer eventMeshConsumer;
    protected EventMeshGrpcConfiguration eventMeshGrpcConfiguration;
    protected GrpcRetryer grpcRetryer;
    protected Map<String, Set<AbstractPushRequest>> waitingRequests;
    protected HandleMsgContext handleMsgContext;
    protected CloudEvent eventMeshCloudEvent;
    private final AtomicBoolean complete = new AtomicBoolean(Boolean.FALSE);

    public AbstractPushRequest(HandleMsgContext handleMsgContext, Map<String, Set<AbstractPushRequest>> waitingRequests) {
        this.eventMeshGrpcServer = handleMsgContext.getEventMeshGrpcServer();
        this.handleMsgContext = handleMsgContext;
        this.waitingRequests = waitingRequests;
        this.eventMeshConsumer = handleMsgContext.getEventMeshConsumer();
        this.eventMeshGrpcConfiguration = handleMsgContext.getEventMeshGrpcServer().getEventMeshGrpcConfiguration();
        this.grpcRetryer = handleMsgContext.getEventMeshGrpcServer().getGrpcRetryer();
        io.cloudevents.CloudEvent event = handleMsgContext.getEvent();
        this.eventMeshCloudEvent = this.getEventMeshCloudEvent(event);
    }

    public abstract void tryPushRequest();

    private CloudEvent getEventMeshCloudEvent(io.cloudevents.CloudEvent cloudEvent) {
        try {
            String protocolType = Objects.requireNonNull(cloudEvent.getExtension("protocoltype")).toString();
            ProtocolAdaptor protocolAdaptor = ProtocolPluginFactory.getProtocolAdaptor((String)protocolType);
            ProtocolTransportObject protocolTransportObject = protocolAdaptor.fromCloudEvent(cloudEvent);
            return ((EventMeshCloudEventWrapper)protocolTransportObject).getMessage();
        }
        catch (Exception e) {
            log.error("Error in getting EventMeshMessage from CloudEvent", (Throwable)e);
            return null;
        }
    }

    private io.cloudevents.CloudEvent getCloudEvent(CloudEvent cloudEvent) {
        try {
            String protocolType = Objects.requireNonNull(EventMeshCloudEventUtils.getProtocolType((CloudEvent)cloudEvent));
            ProtocolAdaptor protocolAdaptor = ProtocolPluginFactory.getProtocolAdaptor((String)protocolType);
            return protocolAdaptor.toCloudEvent((ProtocolTransportObject)new EventMeshCloudEventWrapper(cloudEvent));
        }
        catch (Exception e) {
            log.error("Error in getting CloudEvent from EventMeshMessage", (Throwable)e);
            return null;
        }
    }

    protected void delayRetry() {
        if (this.retryTimes < 3) {
            ++this.retryTimes;
            this.grpcRetryer.newTimeout(this, 3000L, TimeUnit.MILLISECONDS);
        } else {
            this.complete();
        }
    }

    protected boolean isComplete() {
        return this.complete.get();
    }

    private void finish() {
        AbstractContext context = this.handleMsgContext.getContext();
        SubscriptionMode subscriptionMode = this.handleMsgContext.getSubscriptionMode();
        io.cloudevents.CloudEvent event = this.getCloudEvent(this.eventMeshCloudEvent);
        if (this.eventMeshConsumer != null && context != null && event != null) {
            try {
                this.eventMeshConsumer.updateOffset(subscriptionMode, Collections.singletonList(event), context);
            }
            catch (Exception e) {
                log.error("Error in updating offset in EventMeshConsumer", (Throwable)e);
            }
        }
    }

    protected void complete() {
        this.complete.compareAndSet(Boolean.FALSE, Boolean.TRUE);
        this.finish();
    }

    protected void timeout() {
        if (!this.isComplete() && System.currentTimeMillis() - this.lastPushTime >= Long.parseLong(EventMeshCloudEventUtils.getTtl((CloudEvent)this.eventMeshCloudEvent))) {
            this.delayRetry();
        }
    }

    public HandleMsgContext getHandleMsgContext() {
        return this.handleMsgContext;
    }

    protected void addToWaitingMap(WebhookPushRequest request) {
        if (this.waitingRequests.containsKey(this.handleMsgContext.getConsumerGroup())) {
            this.waitingRequests.get(this.handleMsgContext.getConsumerGroup()).add(request);
            return;
        }
        this.waitingRequests.put(this.handleMsgContext.getConsumerGroup(), Sets.newConcurrentHashSet());
        this.waitingRequests.get(this.handleMsgContext.getConsumerGroup()).add(request);
    }

    protected void removeWaitingMap(WebhookPushRequest request) {
        if (this.waitingRequests.containsKey(this.handleMsgContext.getConsumerGroup())) {
            this.waitingRequests.get(this.handleMsgContext.getConsumerGroup()).remove(request);
        }
    }

    @Override
    public void doRun() throws Exception {
        this.tryPushRequest();
    }
}

