/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.processor;

import io.cloudevents.CloudEvent;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.netty.channel.ChannelHandlerContext;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.api.SendCallback;
import org.apache.eventmesh.api.SendResult;
import org.apache.eventmesh.api.exception.OnExceptionContext;
import org.apache.eventmesh.common.Constants;
import org.apache.eventmesh.common.protocol.ProtocolTransportObject;
import org.apache.eventmesh.common.protocol.http.HttpCommand;
import org.apache.eventmesh.common.protocol.http.body.message.SendMessageBatchV2ResponseBody;
import org.apache.eventmesh.common.protocol.http.common.EventMeshRetCode;
import org.apache.eventmesh.common.protocol.http.common.ProtocolKey;
import org.apache.eventmesh.common.protocol.http.common.RequestCode;
import org.apache.eventmesh.common.protocol.http.header.message.SendMessageBatchV2RequestHeader;
import org.apache.eventmesh.common.protocol.http.header.message.SendMessageBatchV2ResponseHeader;
import org.apache.eventmesh.common.utils.LogUtils;
import org.apache.eventmesh.metrics.api.model.HttpSummaryMetrics;
import org.apache.eventmesh.protocol.api.ProtocolAdaptor;
import org.apache.eventmesh.protocol.api.ProtocolPluginFactory;
import org.apache.eventmesh.runtime.acl.Acl;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.configuration.EventMeshHTTPConfiguration;
import org.apache.eventmesh.runtime.constants.EventMeshConstants;
import org.apache.eventmesh.runtime.core.protocol.http.async.AsyncContext;
import org.apache.eventmesh.runtime.core.protocol.http.processor.inf.HttpRequestProcessor;
import org.apache.eventmesh.runtime.core.protocol.producer.EventMeshProducer;
import org.apache.eventmesh.runtime.core.protocol.producer.SendMessageContext;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.apache.eventmesh.runtime.util.RemotingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchSendMessageV2Processor
implements HttpRequestProcessor {
    private final Logger cmdLogger = LoggerFactory.getLogger((String)"cmd");
    private final Logger aclLogger = LoggerFactory.getLogger((String)"acl");
    private final Logger batchMessageLogger = LoggerFactory.getLogger((String)"batchMessage");
    private final EventMeshHTTPServer eventMeshHTTPServer;
    private final Acl acl;

    public BatchSendMessageV2Processor(EventMeshHTTPServer eventMeshHTTPServer) {
        this.eventMeshHTTPServer = eventMeshHTTPServer;
        this.acl = eventMeshHTTPServer.getAcl();
    }

    @Override
    public void processRequest(ChannelHandlerContext ctx, AsyncContext<HttpCommand> asyncContext) throws Exception {
        String sys;
        String pid;
        HttpCommand request = asyncContext.getRequest();
        Integer requestCode = Integer.valueOf(request.getRequestCode());
        this.cmdLogger.info("cmd={}|{}|client2eventMesh|from={}|to={}", new Object[]{RequestCode.get((Integer)requestCode), "http", RemotingHelper.parseChannelRemoteAddr(ctx.channel()), RemotingHelper.parseChannelRemoteAddr(ctx.channel())});
        SendMessageBatchV2RequestHeader sendMessageBatchV2RequestHeader = (SendMessageBatchV2RequestHeader)request.getHeader();
        String protocolType = sendMessageBatchV2RequestHeader.getProtocolType();
        ProtocolAdaptor httpCommandProtocolAdaptor = ProtocolPluginFactory.getProtocolAdaptor((String)protocolType);
        CloudEvent event = httpCommandProtocolAdaptor.toCloudEvent((ProtocolTransportObject)request);
        EventMeshHTTPConfiguration httpConfiguration = this.eventMeshHTTPServer.getEventMeshHttpConfiguration();
        SendMessageBatchV2ResponseHeader sendMessageBatchV2ResponseHeader = SendMessageBatchV2ResponseHeader.buildHeader((Integer)requestCode, (String)httpConfiguration.getEventMeshCluster(), (String)httpConfiguration.getEventMeshEnv(), (String)httpConfiguration.getEventMeshIDC());
        if (!ObjectUtils.allNotNull((Object[])new Object[]{event.getSource(), event.getSpecVersion()}) || StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{event.getId(), event.getType(), event.getSubject()})) {
            this.completeResponse(request, asyncContext, sendMessageBatchV2ResponseHeader, EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR, null, SendMessageBatchV2ResponseBody.class);
            return;
        }
        String idc = this.getExtension(event, ProtocolKey.ClientInstanceKey.IDC.getKey());
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{idc, pid = this.getExtension(event, ProtocolKey.ClientInstanceKey.PID.getKey()), sys = this.getExtension(event, ProtocolKey.ClientInstanceKey.SYS.getKey())}) || !StringUtils.isNumeric((CharSequence)pid)) {
            this.completeResponse(request, asyncContext, sendMessageBatchV2ResponseHeader, EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR, null, SendMessageBatchV2ResponseBody.class);
            return;
        }
        final String bizNo = this.getExtension(event, "bizseqno");
        String producerGroup = this.getExtension(event, "producergroup");
        final String topic = event.getSubject();
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{bizNo, topic, producerGroup}) || event.getData() == null) {
            this.completeResponse(request, asyncContext, sendMessageBatchV2ResponseHeader, EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR, null, SendMessageBatchV2ResponseBody.class);
            return;
        }
        String content = new String(Objects.requireNonNull(event.getData()).toBytes(), Constants.DEFAULT_CHARSET);
        if (content.length() > httpConfiguration.getEventMeshEventSize()) {
            this.batchMessageLogger.error("Event size exceeds the limit: {}", (Object)httpConfiguration.getEventMeshEventSize());
            this.completeResponse(request, asyncContext, sendMessageBatchV2ResponseHeader, EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR, "Event size exceeds the limit: " + httpConfiguration.getEventMeshEventSize(), SendMessageBatchV2ResponseBody.class);
            return;
        }
        if (httpConfiguration.isEventMeshServerSecurityEnable()) {
            String remoteAddr = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            String user = this.getExtension(event, ProtocolKey.ClientInstanceKey.USERNAME.getKey());
            String pass = this.getExtension(event, ProtocolKey.ClientInstanceKey.PASSWD.getKey());
            String subsystem = this.getExtension(event, ProtocolKey.ClientInstanceKey.SYS.getKey());
            try {
                this.acl.doAclCheckInHttpSend(remoteAddr, user, pass, subsystem, topic, requestCode);
            }
            catch (Exception e) {
                this.completeResponse(request, asyncContext, sendMessageBatchV2ResponseHeader, EventMeshRetCode.EVENTMESH_ACL_ERR, e.getMessage(), SendMessageBatchV2ResponseBody.class);
                this.aclLogger.warn("CLIENT HAS NO PERMISSION,BatchSendMessageV2Processor send failed", (Throwable)e);
                return;
            }
        }
        final HttpSummaryMetrics summaryMetrics = this.eventMeshHTTPServer.getMetrics().getSummaryMetrics();
        if (!this.eventMeshHTTPServer.getBatchRateLimiter().tryAcquire(100L, TimeUnit.MILLISECONDS)) {
            summaryMetrics.recordSendBatchMsgDiscard(1L);
            this.completeResponse(request, asyncContext, sendMessageBatchV2ResponseHeader, EventMeshRetCode.EVENTMESH_BATCH_SPEED_OVER_LIMIT_ERR, null, SendMessageBatchV2ResponseBody.class);
            return;
        }
        EventMeshProducer batchEventMeshProducer = this.eventMeshHTTPServer.getProducerManager().getEventMeshProducer(producerGroup);
        batchEventMeshProducer.getMqProducerWrapper().getMeshMQProducer().setExtFields();
        if (!batchEventMeshProducer.isStarted()) {
            this.completeResponse(request, asyncContext, sendMessageBatchV2ResponseHeader, EventMeshRetCode.EVENTMESH_BATCH_PRODUCER_STOPED_ERR, null, SendMessageBatchV2ResponseBody.class);
            return;
        }
        final long batchStartTime = System.currentTimeMillis();
        String defaultTTL = String.valueOf(EventMeshConstants.DEFAULT_MSG_TTL_MILLS);
        String ttlValue = this.getExtension(event, "ttl");
        if (StringUtils.isBlank((CharSequence)ttlValue) && !StringUtils.isNumeric((CharSequence)ttlValue)) {
            event = CloudEventBuilder.from((CloudEvent)event).withExtension("ttl", defaultTTL).build();
        }
        try {
            event = CloudEventBuilder.from((CloudEvent)event).withExtension("msgtype", "persistent").withExtension("reqc2eventmeshtimestamp", String.valueOf(System.currentTimeMillis())).withExtension("reqeventmesh2mqtimestamp", String.valueOf(System.currentTimeMillis())).build();
            LogUtils.debug((Logger)this.batchMessageLogger, (String)"msg2MQMsg suc, topic:{}, msg:{}", (Object)topic, (Object)event.getData());
        }
        catch (Exception e) {
            this.batchMessageLogger.error("msg2MQMsg err, topic:{}, msg:{}", new Object[]{topic, event.getData(), e});
            this.completeResponse(request, asyncContext, sendMessageBatchV2ResponseHeader, EventMeshRetCode.EVENTMESH_PACKAGE_MSG_ERR, EventMeshRetCode.EVENTMESH_PACKAGE_MSG_ERR.getErrMsg() + EventMeshUtil.stackTrace(e, 2), SendMessageBatchV2ResponseBody.class);
            return;
        }
        summaryMetrics.recordSendBatchMsg(1L);
        final SendMessageContext sendMessageContext = new SendMessageContext(bizNo, event, batchEventMeshProducer, this.eventMeshHTTPServer);
        try {
            batchEventMeshProducer.send(sendMessageContext, new SendCallback(){

                public void onSuccess(SendResult sendResult) {
                    long batchEndTime = System.currentTimeMillis();
                    summaryMetrics.recordBatchSendMsgCost(batchEndTime - batchStartTime);
                    BatchSendMessageV2Processor.this.batchMessageLogger.debug("batchMessageV2|eventMesh2mq|REQ|ASYNC|bizSeqNo={}|send2MQCost={}ms|topic={}", new Object[]{bizNo, batchEndTime - batchStartTime, topic});
                }

                public void onException(OnExceptionContext context) {
                    long batchEndTime = System.currentTimeMillis();
                    BatchSendMessageV2Processor.this.eventMeshHTTPServer.getHttpRetryer().newTimeout(sendMessageContext, 10L, TimeUnit.SECONDS);
                    summaryMetrics.recordBatchSendMsgCost(batchEndTime - batchStartTime);
                    BatchSendMessageV2Processor.this.batchMessageLogger.error("batchMessageV2|eventMesh2mq|REQ|ASYNC|bizSeqNo={}|send2MQCost={}ms|topic={}", new Object[]{bizNo, batchEndTime - batchStartTime, topic, context.getException()});
                }
            });
        }
        catch (Exception e) {
            this.completeResponse(request, asyncContext, sendMessageBatchV2ResponseHeader, EventMeshRetCode.EVENTMESH_SEND_BATCHLOG_MSG_ERR, EventMeshRetCode.EVENTMESH_SEND_BATCHLOG_MSG_ERR.getErrMsg() + EventMeshUtil.stackTrace(e, 2), SendMessageBatchV2ResponseBody.class);
            long batchEndTime = System.currentTimeMillis();
            this.eventMeshHTTPServer.getHttpRetryer().newTimeout(sendMessageContext, 10L, TimeUnit.SECONDS);
            summaryMetrics.recordBatchSendMsgCost(batchEndTime - batchStartTime);
            this.batchMessageLogger.error("batchMessageV2|eventMesh2mq|REQ|ASYNC|bizSeqNo={}|send2MQCost={}ms|topic={}", new Object[]{bizNo, batchEndTime - batchStartTime, topic, e});
        }
        this.completeResponse(request, asyncContext, sendMessageBatchV2ResponseHeader, EventMeshRetCode.SUCCESS, null, SendMessageBatchV2ResponseBody.class);
    }
}

