/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.processor;

import com.fasterxml.jackson.core.type.TypeReference;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.protocol.http.HttpEventWrapper;
import org.apache.eventmesh.common.protocol.http.common.EventMeshRetCode;
import org.apache.eventmesh.common.protocol.http.common.ProtocolKey;
import org.apache.eventmesh.common.protocol.http.common.RequestURI;
import org.apache.eventmesh.common.utils.IPUtils;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.common.utils.LogUtils;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.common.EventMeshTrace;
import org.apache.eventmesh.runtime.core.protocol.http.async.AsyncContext;
import org.apache.eventmesh.runtime.core.protocol.http.async.CompleteHandler;
import org.apache.eventmesh.runtime.core.protocol.http.consumer.HttpClientGroupMapping;
import org.apache.eventmesh.runtime.core.protocol.http.processor.AsyncHttpProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.processor.HandlerService;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.apache.eventmesh.runtime.util.RemotingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventMeshTrace
public class DeleteTopicProcessor
implements AsyncHttpProcessor {
    private final Logger httpLogger = LoggerFactory.getLogger((String)"http");
    private final transient EventMeshHTTPServer eventMeshHTTPServer;

    public DeleteTopicProcessor(EventMeshHTTPServer eventMeshHTTPServer) {
        this.eventMeshHTTPServer = eventMeshHTTPServer;
    }

    @Override
    public void handler(HandlerService.HandlerSpecific handlerSpecific, HttpRequest httpRequest) throws Exception {
        AsyncContext<HttpEventWrapper> asyncContext = handlerSpecific.getAsyncContext();
        ChannelHandlerContext ctx = handlerSpecific.getCtx();
        HttpEventWrapper requestWrapper = asyncContext.getRequest();
        this.httpLogger.info("uri={}|{}|client2eventMesh|from={}|to={}", new Object[]{requestWrapper.getRequestURI(), "http", RemotingHelper.parseChannelRemoteAddr(ctx.channel()), IPUtils.getLocalAddress()});
        Map userRequestHeaderMap = requestWrapper.getHeaderMap();
        String requestIp = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
        userRequestHeaderMap.put(ProtocolKey.ClientInstanceKey.IP.getKey(), requestIp);
        HashMap<String, Object> responseHeaderMap = new HashMap<String, Object>();
        responseHeaderMap.put("uri", requestWrapper.getRequestURI());
        responseHeaderMap.put("eventmeshcluster", this.eventMeshHTTPServer.getEventMeshHttpConfiguration().getEventMeshCluster());
        responseHeaderMap.put("eventmeship", IPUtils.getLocalAddress());
        responseHeaderMap.put("eventmeshenv", this.eventMeshHTTPServer.getEventMeshHttpConfiguration().getEventMeshEnv());
        responseHeaderMap.put("eventmeshidc", this.eventMeshHTTPServer.getEventMeshHttpConfiguration().getEventMeshIDC());
        byte[] requestBody = requestWrapper.getBody();
        Map requestBodyMap = (Map)JsonUtils.parseTypeReferenceObject((String)new String(requestBody), (TypeReference)new TypeReference<HashMap<String, Object>>(){});
        if (requestBodyMap.get("topic") == null || StringUtils.isBlank((CharSequence)requestBodyMap.get("topic").toString())) {
            HashMap<String, Object> responseBodyMap = new HashMap<String, Object>();
            responseBodyMap.put("retCode", EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR.getRetCode());
            responseBodyMap.put("retMsg", EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR.getErrMsg() + "topic is null");
            this.httpLogger.warn("delete topic fail, topic is null");
            HttpEventWrapper responseWrapper = requestWrapper.createHttpResponse(responseHeaderMap, responseBodyMap);
            responseWrapper.setHttpResponseStatus(HttpResponseStatus.BAD_REQUEST);
            handlerSpecific.sendErrorResponse(EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR, responseHeaderMap, responseBodyMap, null);
            return;
        }
        String topic = requestBodyMap.get("topic").toString();
        long startTime = System.currentTimeMillis();
        try {
            String[] topicArr = topic.split(";");
            ArrayList<String> faildTopic = new ArrayList<String>();
            for (String deleteTopic : topicArr) {
                if (HttpClientGroupMapping.getInstance().getLocalTopicSet().contains(deleteTopic)) continue;
                faildTopic.add(deleteTopic);
            }
            if (!faildTopic.isEmpty()) {
                HashMap responseBodyMap = new HashMap();
                StringBuilder sb = new StringBuilder();
                sb.append(((Object)faildTopic).toString()).append(" not exist in eventmesh");
                this.httpLogger.warn("delete topic fail, {}", (Object)sb.toString());
                responseBodyMap.put("retCode", EventMeshRetCode.EVENTMESH_OPERATE_FAIL.getRetCode());
                responseBodyMap.put("retMsg", EventMeshRetCode.EVENTMESH_OPERATE_FAIL.getErrMsg() + sb.toString());
                HttpEventWrapper responseWrapper = requestWrapper.createHttpResponse(responseHeaderMap, (Map)responseBodyMap);
                responseWrapper.setHttpResponseStatus(HttpResponseStatus.BAD_REQUEST);
                handlerSpecific.sendErrorResponse(EventMeshRetCode.EVENTMESH_OPERATE_FAIL, responseHeaderMap, responseBodyMap, null);
                return;
            }
            for (String item : topicArr) {
                boolean flag = HttpClientGroupMapping.getInstance().getLocalTopicSet().remove(StringUtils.deleteWhitespace((String)item));
                if (!flag) continue;
                this.httpLogger.info("remove topic success, topic:{}", (Object)item);
            }
            CompleteHandler<HttpEventWrapper> handler = httpEventWrapper -> {
                try {
                    LogUtils.debug((Logger)this.httpLogger, (String)"{}", (Object)httpEventWrapper);
                    this.eventMeshHTTPServer.sendResponse(ctx, httpEventWrapper.httpResponse());
                    this.eventMeshHTTPServer.getMetrics().getSummaryMetrics().recordHTTPReqResTimeCost(System.currentTimeMillis() - requestWrapper.getReqTime());
                }
                catch (Exception ex) {
                    this.httpLogger.warn("delete topic, sendResponse fail,", (Throwable)ex);
                }
            };
            HttpEventWrapper responseWrapper = requestWrapper.createHttpResponse(EventMeshRetCode.SUCCESS);
            asyncContext.onComplete(responseWrapper, handler);
        }
        catch (Exception e) {
            HashMap<String, Object> responseBodyMap = new HashMap<String, Object>();
            responseBodyMap.put("retCode", EventMeshRetCode.EVENTMESH_RUNTIME_ERR.getRetCode());
            responseBodyMap.put("retMsg", EventMeshRetCode.EVENTMESH_RUNTIME_ERR.getErrMsg() + EventMeshUtil.stackTrace(e, 2));
            HttpEventWrapper responseWrapper = asyncContext.getRequest().createHttpResponse(responseHeaderMap, responseBodyMap);
            responseWrapper.setHttpResponseStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR);
            handlerSpecific.sendErrorResponse(EventMeshRetCode.EVENTMESH_RUNTIME_ERR, responseHeaderMap, responseBodyMap, null);
            long endTime = System.currentTimeMillis();
            this.httpLogger.warn("delete topic fail, eventMesh2client|cost={}ms|topic={}", new Object[]{endTime - startTime, topic, e});
            this.eventMeshHTTPServer.getMetrics().getSummaryMetrics().recordSendMsgFailed();
            this.eventMeshHTTPServer.getMetrics().getSummaryMetrics().recordSendMsgCost(endTime - startTime);
        }
    }

    @Override
    public String[] paths() {
        return new String[]{RequestURI.DELETE_TOPIC.getRequestURI()};
    }
}

