/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.processor;

import io.cloudevents.CloudEvent;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.netty.channel.ChannelHandlerContext;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.api.RequestReplyCallback;
import org.apache.eventmesh.common.Constants;
import org.apache.eventmesh.common.protocol.ProtocolTransportObject;
import org.apache.eventmesh.common.protocol.http.HttpCommand;
import org.apache.eventmesh.common.protocol.http.body.Body;
import org.apache.eventmesh.common.protocol.http.body.message.SendMessageResponseBody;
import org.apache.eventmesh.common.protocol.http.common.EventMeshRetCode;
import org.apache.eventmesh.common.protocol.http.common.ProtocolKey;
import org.apache.eventmesh.common.protocol.http.common.RequestCode;
import org.apache.eventmesh.common.protocol.http.header.Header;
import org.apache.eventmesh.common.protocol.http.header.message.SendMessageRequestHeader;
import org.apache.eventmesh.common.protocol.http.header.message.SendMessageResponseHeader;
import org.apache.eventmesh.common.utils.IPUtils;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.common.utils.LogUtils;
import org.apache.eventmesh.metrics.api.model.HttpSummaryMetrics;
import org.apache.eventmesh.protocol.api.ProtocolAdaptor;
import org.apache.eventmesh.protocol.api.ProtocolPluginFactory;
import org.apache.eventmesh.runtime.acl.Acl;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.configuration.EventMeshHTTPConfiguration;
import org.apache.eventmesh.runtime.core.protocol.http.async.AsyncContext;
import org.apache.eventmesh.runtime.core.protocol.http.async.CompleteHandler;
import org.apache.eventmesh.runtime.core.protocol.http.processor.inf.HttpRequestProcessor;
import org.apache.eventmesh.runtime.core.protocol.producer.EventMeshProducer;
import org.apache.eventmesh.runtime.core.protocol.producer.SendMessageContext;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.apache.eventmesh.runtime.util.RemotingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendSyncMessageProcessor
implements HttpRequestProcessor {
    private static final Logger log = LoggerFactory.getLogger(SendSyncMessageProcessor.class);
    private transient EventMeshHTTPServer eventMeshHTTPServer;
    private final Acl acl;

    public SendSyncMessageProcessor(EventMeshHTTPServer eventMeshHTTPServer) {
        this.eventMeshHTTPServer = eventMeshHTTPServer;
        this.acl = eventMeshHTTPServer.getAcl();
    }

    @Override
    public void processRequest(ChannelHandlerContext ctx, final AsyncContext<HttpCommand> asyncContext) throws Exception {
        CloudEvent newEevent;
        String ttl;
        String topic;
        String producerGroup;
        String uniqueId;
        String sys;
        String pid;
        final HttpCommand request = asyncContext.getRequest();
        String localAddress = IPUtils.getLocalAddress();
        String remoteAddr = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
        LogUtils.info((Logger)log, (String)"cmd={}|{}|client2eventMesh|from={}|to={}", (Object[])new Object[]{RequestCode.get((Integer)Integer.valueOf(request.getRequestCode())), "http", remoteAddr, localAddress});
        SendMessageRequestHeader sendMessageRequestHeader = (SendMessageRequestHeader)request.getHeader();
        String protocolType = sendMessageRequestHeader.getProtocolType();
        ProtocolAdaptor httpCommandProtocolAdaptor = ProtocolPluginFactory.getProtocolAdaptor((String)protocolType);
        CloudEvent event = httpCommandProtocolAdaptor.toCloudEvent((ProtocolTransportObject)asyncContext.getRequest());
        EventMeshHTTPConfiguration eventMeshHttpConfiguration = this.eventMeshHTTPServer.getEventMeshHttpConfiguration();
        final SendMessageResponseHeader sendMessageResponseHeader = SendMessageResponseHeader.buildHeader((Integer)Integer.valueOf(request.getRequestCode()), (String)eventMeshHttpConfiguration.getEventMeshCluster(), (String)localAddress, (String)eventMeshHttpConfiguration.getEventMeshEnv(), (String)eventMeshHttpConfiguration.getEventMeshIDC());
        if (!ObjectUtils.allNotNull((Object[])new Object[]{event, event.getSource(), event.getSpecVersion()}) || StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{event.getId(), event.getType(), event.getSubject()})) {
            this.completeResponse(request, asyncContext, sendMessageResponseHeader, EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR, null, SendMessageResponseBody.class);
            return;
        }
        String idc = this.getExtension(event, ProtocolKey.ClientInstanceKey.IDC.getKey());
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{idc, pid = this.getExtension(event, ProtocolKey.ClientInstanceKey.PID.getKey()), sys = this.getExtension(event, ProtocolKey.ClientInstanceKey.SYS.getKey())}) || !StringUtils.isNumeric((CharSequence)pid)) {
            this.completeResponse(request, asyncContext, sendMessageResponseHeader, EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR, null, SendMessageResponseBody.class);
            return;
        }
        final String bizNo = this.getExtension(event, "bizseqno");
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{bizNo, uniqueId = this.getExtension(event, "uniqueid"), producerGroup = this.getExtension(event, "producergroup"), topic = event.getSubject(), ttl = this.getExtension(event, "ttl")}) || event.getData() == null) {
            this.completeResponse(request, asyncContext, sendMessageResponseHeader, EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR, null, SendMessageResponseBody.class);
            return;
        }
        if (eventMeshHttpConfiguration.isEventMeshServerSecurityEnable()) {
            String user = this.getExtension(event, ProtocolKey.ClientInstanceKey.USERNAME.getKey());
            String pass = this.getExtension(event, ProtocolKey.ClientInstanceKey.PASSWD.getKey());
            int requestCode = Integer.parseInt(request.getRequestCode());
            try {
                this.acl.doAclCheckInHttpSend(remoteAddr, user, pass, sys, topic, requestCode);
            }
            catch (Exception e) {
                this.completeResponse(request, asyncContext, sendMessageResponseHeader, EventMeshRetCode.EVENTMESH_ACL_ERR, e.getMessage(), SendMessageResponseBody.class);
                LogUtils.warn((Logger)log, (String)"CLIENT HAS NO PERMISSION,SendSyncMessageProcessor send failed", (Throwable)e);
                return;
            }
        }
        HttpSummaryMetrics summaryMetrics = this.eventMeshHTTPServer.getMetrics().getSummaryMetrics();
        if (!this.eventMeshHTTPServer.getMsgRateLimiter().tryAcquire(100L, TimeUnit.MILLISECONDS)) {
            this.completeResponse(request, asyncContext, sendMessageResponseHeader, EventMeshRetCode.EVENTMESH_HTTP_MES_SEND_OVER_LIMIT_ERR, null, SendMessageResponseBody.class);
            summaryMetrics.recordHTTPDiscard();
            return;
        }
        String content = new String(Objects.requireNonNull(event.getData()).toBytes(), Constants.DEFAULT_CHARSET);
        int eventMeshEventSize = eventMeshHttpConfiguration.getEventMeshEventSize();
        if (content.length() > eventMeshEventSize) {
            LogUtils.error((Logger)log, (String)"Event size exceeds the limit: {}", (Object)eventMeshEventSize);
            this.completeResponse(request, asyncContext, sendMessageResponseHeader, EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR, "Event size exceeds the limit: " + eventMeshEventSize, SendMessageResponseBody.class);
            return;
        }
        EventMeshProducer eventMeshProducer = this.eventMeshHTTPServer.getProducerManager().getEventMeshProducer(producerGroup);
        if (!eventMeshProducer.isStarted()) {
            this.completeResponse(request, asyncContext, sendMessageResponseHeader, EventMeshRetCode.EVENTMESH_GROUP_PRODUCER_STOPED_ERR, null, SendMessageResponseBody.class);
            return;
        }
        try {
            newEevent = CloudEventBuilder.from((CloudEvent)event).withExtension("msgtype", "persistent").withExtension("reqc2eventmeshtimestamp", String.valueOf(System.currentTimeMillis())).withExtension("reqeventmesh2mqtimestamp", String.valueOf(System.currentTimeMillis())).build();
            LogUtils.debug((Logger)log, (String)"msg2MQMsg suc, bizSeqNo={}, topic={}", (Object)bizNo, (Object)topic);
        }
        catch (Exception e) {
            LogUtils.error((Logger)log, (String)"msg2MQMsg err, bizSeqNo={}, topic={}", (Object[])new Object[]{bizNo, topic, e});
            this.completeResponse(request, asyncContext, sendMessageResponseHeader, EventMeshRetCode.EVENTMESH_PACKAGE_MSG_ERR, null, SendMessageResponseBody.class);
            return;
        }
        final SendMessageContext sendMessageContext = new SendMessageContext(bizNo, newEevent, eventMeshProducer, this.eventMeshHTTPServer);
        summaryMetrics.recordSendMsg();
        final long startTime = System.currentTimeMillis();
        final CompleteHandler<HttpCommand> handler = httpCommand -> {
            try {
                LogUtils.debug((Logger)log, (String)"{}", (Object)httpCommand);
                this.eventMeshHTTPServer.sendResponse(ctx, httpCommand.httpResponse());
                this.eventMeshHTTPServer.getMetrics().getSummaryMetrics().recordHTTPReqResTimeCost(System.currentTimeMillis() - ((HttpCommand)asyncContext.getRequest()).getReqTime());
            }
            catch (Exception ex) {
                log.error("onResponse error", (Throwable)ex);
            }
        };
        try {
            eventMeshProducer.request(sendMessageContext, new RequestReplyCallback(){

                public void onSuccess(CloudEvent event) {
                    LogUtils.info((Logger)log, (String)"message|mq2eventMesh|RSP|SYNC|rrCost={}ms|topic={}|bizSeqNo={}|uniqueId={}", (Object[])new Object[]{System.currentTimeMillis() - startTime, topic, bizNo, uniqueId});
                    try {
                        CloudEvent newEvent = CloudEventBuilder.from((CloudEvent)event).withExtension("rspeventmesh2ctimestamp", String.valueOf(System.currentTimeMillis())).withExtension("rspmq2eventmeshtimestamp", String.valueOf(System.currentTimeMillis())).build();
                        String rtnMsg = new String(Objects.requireNonNull(newEvent.getData()).toBytes(), Constants.DEFAULT_CHARSET);
                        HttpCommand succ = request.createHttpCommandResponse((Header)sendMessageResponseHeader, (Body)SendMessageResponseBody.buildBody((Integer)EventMeshRetCode.SUCCESS.getRetCode(), (String)JsonUtils.toJSONString((Object)SendMessageResponseBody.ReplyMessage.builder().topic(topic).body(rtnMsg).properties(EventMeshUtil.getEventProp(newEvent)).build())));
                        asyncContext.onComplete(succ, handler);
                    }
                    catch (Exception ex) {
                        HttpCommand err = request.createHttpCommandResponse((Header)sendMessageResponseHeader, (Body)SendMessageResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_WAITING_RR_MSG_ERR.getRetCode(), (String)(EventMeshRetCode.EVENTMESH_WAITING_RR_MSG_ERR.getErrMsg() + EventMeshUtil.stackTrace(ex, 2))));
                        asyncContext.onComplete(err, handler);
                        LogUtils.warn((Logger)log, (String)"message|mq2eventMesh|RSP", (Throwable)ex);
                    }
                }

                public void onException(Throwable e) {
                    HttpCommand err = request.createHttpCommandResponse((Header)sendMessageResponseHeader, (Body)SendMessageResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_WAITING_RR_MSG_ERR.getRetCode(), (String)(EventMeshRetCode.EVENTMESH_WAITING_RR_MSG_ERR.getErrMsg() + EventMeshUtil.stackTrace(e, 2))));
                    asyncContext.onComplete(err, handler);
                    SendSyncMessageProcessor.this.eventMeshHTTPServer.getHttpRetryer().newTimeout(sendMessageContext, 10L, TimeUnit.SECONDS);
                    LogUtils.error((Logger)log, (String)"message|mq2eventMesh|RSP|SYNC|rrCost={}ms|topic={}|bizSeqNo={}|uniqueId={}", (Object[])new Object[]{System.currentTimeMillis() - startTime, topic, bizNo, uniqueId, e});
                }
            }, Integer.parseInt(ttl));
        }
        catch (Exception ex) {
            this.completeResponse(request, asyncContext, sendMessageResponseHeader, EventMeshRetCode.EVENTMESH_SEND_SYNC_MSG_ERR, EventMeshRetCode.EVENTMESH_SEND_SYNC_MSG_ERR.getErrMsg() + EventMeshUtil.stackTrace(ex, 2), SendMessageResponseBody.class);
            this.eventMeshHTTPServer.getHttpRetryer().newTimeout(sendMessageContext, 10L, TimeUnit.SECONDS);
            long endTime = System.currentTimeMillis();
            summaryMetrics.recordSendMsgFailed();
            summaryMetrics.recordSendMsgCost(endTime - startTime);
            LogUtils.error((Logger)log, (String)"message|eventMesh2mq|REQ|SYNC|send2MQCost={}ms|topic={}|bizSeqNo={}|uniqueId={}", (Object[])new Object[]{endTime - startTime, topic, bizNo, uniqueId, ex});
        }
    }
}

