/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.tcp.client.processor;

import io.netty.channel.ChannelHandlerContext;
import java.util.Objects;
import org.apache.eventmesh.common.protocol.tcp.Command;
import org.apache.eventmesh.common.protocol.tcp.Header;
import org.apache.eventmesh.common.protocol.tcp.OPStatus;
import org.apache.eventmesh.common.protocol.tcp.Package;
import org.apache.eventmesh.runtime.acl.Acl;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.processor.TcpProcessor;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.Session;
import org.apache.eventmesh.runtime.util.RemotingHelper;
import org.apache.eventmesh.runtime.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartBeatProcessor
implements TcpProcessor {
    private static final Logger log = LoggerFactory.getLogger(HeartBeatProcessor.class);
    private EventMeshTCPServer eventMeshTCPServer;
    private final Acl acl;

    public HeartBeatProcessor(EventMeshTCPServer eventMeshTCPServer) {
        this.eventMeshTCPServer = eventMeshTCPServer;
        this.acl = eventMeshTCPServer.getAcl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Package pkg, ChannelHandlerContext ctx, long startTime) {
        Session session = this.eventMeshTCPServer.getClientSessionGroupMapping().getSession(ctx);
        long taskExecuteTime = System.currentTimeMillis();
        Package res = new Package();
        try {
            if (this.eventMeshTCPServer.getEventMeshTCPConfiguration().isEventMeshServerSecurityEnable()) {
                String remoteAddr = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
                this.acl.doAclCheckInTcpHeartbeat(remoteAddr, session.getClient(), Command.HEARTBEAT_REQUEST.getValue());
            }
            if (session != null) {
                session.notifyHeartbeat(startTime);
            }
            res.setHeader(new Header(Command.HEARTBEAT_RESPONSE, OPStatus.SUCCESS.getCode().intValue(), OPStatus.SUCCESS.getDesc(), pkg.getHeader().getSeq()));
        }
        catch (Exception e) {
            log.error("HeartBeatTask failed|user={}|errMsg={}", (Object)Objects.requireNonNull(session).getClient(), (Object)e);
            res.setHeader(new Header(Command.HEARTBEAT_RESPONSE, OPStatus.FAIL.getCode().intValue(), "exception while heartbeating", pkg.getHeader().getSeq()));
        }
        finally {
            Utils.writeAndFlush(res, startTime, taskExecuteTime, Objects.requireNonNull(session).getContext(), session);
        }
    }
}

