/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.trace;

import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogExporter
implements SpanExporter {
    private static final Logger log = LoggerFactory.getLogger(LogExporter.class);

    public CompletableResultCode export(Collection<SpanData> spans) {
        StringBuilder sb = new StringBuilder(60);
        for (SpanData span : spans) {
            sb.setLength(0);
            InstrumentationLibraryInfo instrumentationLibraryInfo = span.getInstrumentationLibraryInfo();
            sb.append("'").append(span.getName()).append("' : ").append(span.getTraceId()).append(" ").append(span.getSpanId()).append(" ").append(span.getKind()).append(" [tracer: ").append(instrumentationLibraryInfo.getName()).append(":").append(instrumentationLibraryInfo.getVersion() == null ? "" : instrumentationLibraryInfo.getVersion()).append("] ").append(span.getAttributes());
            log.info(sb.toString());
        }
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode flush() {
        CompletableResultCode resultCode = new CompletableResultCode();
        return resultCode.succeed();
    }

    public CompletableResultCode shutdown() {
        return this.flush();
    }
}

