/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.cloudevents.CloudEvent;
import io.cloudevents.SpecVersion;
import io.cloudevents.core.v03.CloudEventV03;
import io.cloudevents.core.v1.CloudEventV1;
import io.cloudevents.rw.CloudEventContextWriter;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.EventMeshThreadFactory;
import org.apache.eventmesh.common.protocol.tcp.EventMeshMessage;
import org.apache.eventmesh.common.protocol.tcp.UserAgent;
import org.apache.eventmesh.common.utils.LogUtils;
import org.apache.eventmesh.common.utils.RandomStringUtils;
import org.apache.eventmesh.common.utils.ThreadUtils;
import org.apache.eventmesh.runtime.constants.EventMeshVersion;
import org.apache.eventmesh.runtime.util.EventMeshCloudEventWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMeshUtil {
    private static final Logger log = LoggerFactory.getLogger(EventMeshUtil.class);

    public static String buildPushMsgSeqNo() {
        return StringUtils.rightPad((String)String.valueOf(System.currentTimeMillis()), (int)6) + RandomStringUtils.generateNum((int)4);
    }

    public static String buildMeshClientID(String clientGroup, String meshCluster) {
        return StringUtils.trim((String)clientGroup) + '(' + StringUtils.trim((String)meshCluster) + ')' + '-' + EventMeshVersion.getCurrentVersionDesc() + '-' + ThreadUtils.getPID();
    }

    public static String buildMeshTcpClientID(String clientSysId, String purpose, String meshCluster) {
        return StringUtils.joinWith((String)"-", (Object[])new Object[]{StringUtils.trim((String)clientSysId), StringUtils.trim((String)purpose), StringUtils.trim((String)meshCluster), EventMeshVersion.getCurrentVersionDesc(), ThreadUtils.getPID()});
    }

    public static String buildClientGroup(String systemId) {
        return systemId;
    }

    public static String stackTrace(Throwable e) {
        return EventMeshUtil.stackTrace(e, 0);
    }

    public static String stackTrace(Throwable e, int level) {
        if (e == null) {
            return null;
        }
        StackTraceElement[] eles = e.getStackTrace();
        int localLevel = level == 0 ? eles.length : level;
        StringBuilder sb = new StringBuilder();
        sb.append(e.getMessage()).append(System.lineSeparator());
        int innerLevel = 0;
        for (StackTraceElement ele : eles) {
            sb.append(ele).append(System.lineSeparator());
            if (++innerLevel >= localLevel) break;
        }
        return sb.toString();
    }

    public static ObjectMapper createJsoner() {
        return new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS).setTimeZone(TimeZone.getDefault());
    }

    public static String printMqMessage(EventMeshMessage eventMeshMessage) {
        Map properties = eventMeshMessage.getProperties();
        String keys = (String)properties.get("KEYS");
        if (StringUtils.isBlank((CharSequence)keys)) {
            keys = (String)properties.get("keys");
        }
        return String.format("Message [topic=%s,TTL=%s,uniqueId=%s,bizSeq=%s]", eventMeshMessage.getTopic(), properties.get("ttl"), properties.get("RR_REQUEST_UNIQ_ID"), keys);
    }

    public static String getMessageBizSeq(CloudEvent event) {
        String keys = (String)event.getExtension("KEYS");
        if (StringUtils.isBlank((CharSequence)keys)) {
            keys = (String)event.getExtension("keys");
        }
        return keys;
    }

    public static Map<String, String> getEventProp(CloudEvent event) {
        HashMap<String, String> propMap = new HashMap<String, String>();
        event.getExtensionNames().forEach(extensionKey -> propMap.put((String)extensionKey, event.getExtension(extensionKey) == null ? "" : event.getExtension(extensionKey).toString()));
        return propMap;
    }

    public static String getLocalAddr() {
        String priority = System.getProperty("networkInterface.priority", "bond1<eth1<eth0");
        LogUtils.debug((Logger)log, (String)"networkInterface.priority: {}", (Object)priority);
        ArrayList<String> preferList = new ArrayList<String>();
        preferList.addAll(Arrays.asList(priority.split("<")));
        NetworkInterface preferNetworkInterface = null;
        try {
            Enumeration<NetworkInterface> enumeration1 = NetworkInterface.getNetworkInterfaces();
            while (enumeration1.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration1.nextElement();
                if (!preferList.contains(networkInterface.getName()) || preferNetworkInterface != null && preferList.indexOf(networkInterface.getName()) <= preferList.indexOf(preferNetworkInterface.getName())) continue;
                preferNetworkInterface = networkInterface;
            }
            ArrayList<String> ipv4Result = new ArrayList<String>();
            ArrayList<String> ipv6Result = new ArrayList<String>();
            if (preferNetworkInterface != null) {
                LogUtils.debug((Logger)log, (String)"use preferNetworkInterface:{}", (Object)preferNetworkInterface);
                Enumeration<InetAddress> en = preferNetworkInterface.getInetAddresses();
                EventMeshUtil.getIpResult(ipv4Result, ipv6Result, en);
            } else {
                LogUtils.debug((Logger)log, (String)"no preferNetworkInterface");
                Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
                while (enumeration.hasMoreElements()) {
                    NetworkInterface networkInterface = enumeration.nextElement();
                    Enumeration<InetAddress> en = networkInterface.getInetAddresses();
                    EventMeshUtil.getIpResult(ipv4Result, ipv6Result, en);
                }
            }
            if (!ipv4Result.isEmpty()) {
                for (String ip : ipv4Result) {
                    if (StringUtils.startsWithAny((CharSequence)ip, (CharSequence[])new CharSequence[]{"127.0", "192.168"})) continue;
                    return ip;
                }
                return ipv4Result.get(ipv4Result.size() - 1);
            }
            if (!ipv6Result.isEmpty()) {
                return ipv6Result.get(0);
            }
            return EventMeshUtil.normalizeHostAddress(InetAddress.getLocalHost());
        }
        catch (SocketException | UnknownHostException e) {
            log.error("failed to get local address", (Throwable)e);
            return null;
        }
    }

    public static String normalizeHostAddress(InetAddress localHost) {
        if (localHost instanceof Inet6Address) {
            return "[" + localHost.getHostAddress() + "]";
        }
        return localHost.getHostAddress();
    }

    private static void getIpResult(Collection<String> ipv4Result, Collection<String> ipv6Result, Enumeration<InetAddress> en) {
        while (en.hasMoreElements()) {
            InetAddress address = en.nextElement();
            if (address.isLoopbackAddress()) continue;
            if (address instanceof Inet6Address) {
                ipv6Result.add(EventMeshUtil.normalizeHostAddress(address));
                continue;
            }
            ipv4Result.add(EventMeshUtil.normalizeHostAddress(address));
        }
    }

    public static String buildUserAgentClientId(UserAgent client) {
        if (client == null) {
            return null;
        }
        return client.getSubsystem() + '-' + '-' + client.getPid() + '-' + client.getHost() + ':' + client.getPort();
    }

    public static void printState(ThreadPoolExecutor scheduledExecutorService) {
        LogUtils.info((Logger)log, (String)"{} [{} {} {} {}]", (Object[])new Object[]{((EventMeshThreadFactory)scheduledExecutorService.getThreadFactory()).getThreadNamePrefix(), scheduledExecutorService.getQueue().size(), scheduledExecutorService.getPoolSize(), scheduledExecutorService.getActiveCount(), scheduledExecutorService.getCompletedTaskCount()});
    }

    /*
     * Exception decompiling
     */
    public static <T> T cloneObject(T object) throws IOException, ClassNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Map<String, Object> getCloudEventExtensionMap(String protocolVersion, CloudEvent cloudEvent) {
        EventMeshCloudEventWriter eventMeshCloudEventWriter = new EventMeshCloudEventWriter();
        if (StringUtils.equals((CharSequence)SpecVersion.V1.toString(), (CharSequence)protocolVersion) && cloudEvent instanceof CloudEventV1) {
            ((CloudEventV1)cloudEvent).readContext((CloudEventContextWriter)eventMeshCloudEventWriter);
        } else if (StringUtils.equals((CharSequence)SpecVersion.V03.toString(), (CharSequence)protocolVersion) && cloudEvent instanceof CloudEventV03) {
            ((CloudEventV03)cloudEvent).readContext((CloudEventContextWriter)eventMeshCloudEventWriter);
        }
        return eventMeshCloudEventWriter.getExtensionMap();
    }
}

