/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.slack.sink.connector;

import com.slack.api.Slack;
import com.slack.api.methods.MethodsClient;
import com.slack.api.methods.response.chat.ChatPostMessageResponse;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.connector.slack.sink.config.SlackSinkConfig;
import org.apache.eventmesh.openconnect.api.config.Config;
import org.apache.eventmesh.openconnect.api.connector.ConnectorContext;
import org.apache.eventmesh.openconnect.api.connector.SinkConnectorContext;
import org.apache.eventmesh.openconnect.api.sink.Sink;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.ConnectRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlackSinkConnector
implements Sink {
    private static final Logger log = LoggerFactory.getLogger(SlackSinkConnector.class);
    private SlackSinkConfig sinkConfig;
    private volatile boolean isRunning = false;
    private MethodsClient client;

    public Class<? extends Config> configClass() {
        return SlackSinkConfig.class;
    }

    public void init(Config config) throws Exception {
        this.sinkConfig = (SlackSinkConfig)config;
        this.client = Slack.getInstance().methods();
    }

    public void init(ConnectorContext connectorContext) throws Exception {
        SinkConnectorContext sinkConnectorContext = (SinkConnectorContext)connectorContext;
        this.sinkConfig = (SlackSinkConfig)sinkConnectorContext.getSinkConfig();
        this.client = Slack.getInstance().methods();
    }

    public void start() {
        this.isRunning = true;
    }

    public void commit(ConnectRecord record) {
    }

    public String name() {
        return this.sinkConfig.getSinkConnectorConfig().getConnectorName();
    }

    public void stop() {
        this.isRunning = false;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void put(List<ConnectRecord> sinkRecords) {
        for (ConnectRecord record : sinkRecords) {
            this.publishMessage(record);
        }
    }

    private void publishMessage(ConnectRecord record) {
        try {
            ChatPostMessageResponse response = this.client.chatPostMessage(r -> r.token(this.sinkConfig.getSinkConnectorConfig().getAppToken()).channel(this.sinkConfig.getSinkConnectorConfig().getChannelId()).text(new String((byte[])record.getData())));
            if (Objects.nonNull(response) && StringUtils.isNotBlank((CharSequence)response.getError())) {
                throw new IllegalAccessException(response.getError());
            }
        }
        catch (Exception e) {
            log.error("Send message to slack error.", (Throwable)e);
        }
    }
}

