/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.openconnect.offsetmgmt.api.storage;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.RecordOffset;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.RecordPartition;
import org.apache.eventmesh.openconnect.offsetmgmt.api.storage.ConnectorRecordPartition;
import org.apache.eventmesh.openconnect.offsetmgmt.api.storage.OffsetManagementService;
import org.apache.eventmesh.openconnect.offsetmgmt.api.storage.OffsetStorageWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OffsetStorageWriterImpl
implements OffsetStorageWriter,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(OffsetStorageWriterImpl.class);
    private final String connectorName;
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private OffsetManagementService offsetManagementService;
    private Map<ConnectorRecordPartition, RecordOffset> data = new HashMap<ConnectorRecordPartition, RecordOffset>();
    private Map<ConnectorRecordPartition, RecordOffset> toFlush = null;
    private long currentFlushId = 0L;

    public OffsetStorageWriterImpl(String connectorName, OffsetManagementService offsetManagementService) {
        this.connectorName = connectorName;
        this.offsetManagementService = offsetManagementService;
    }

    @Override
    public void writeOffset(RecordPartition partition, RecordOffset position) {
        ConnectorRecordPartition extendRecordPartition = new ConnectorRecordPartition(this.connectorName, partition.getPartition());
        this.data.put(extendRecordPartition, position);
    }

    @Override
    public void writeOffset(Map<RecordPartition, RecordOffset> positions) {
        for (Map.Entry<RecordPartition, RecordOffset> offset : positions.entrySet()) {
            this.writeOffset(offset.getKey(), offset.getValue());
        }
    }

    private boolean isFlushing() {
        return this.toFlush != null;
    }

    public synchronized boolean beginFlush() {
        if (this.isFlushing()) {
            throw new RuntimeException("OffsetStorageWriter is already flushing");
        }
        if (this.data.isEmpty()) {
            return false;
        }
        this.toFlush = this.data;
        this.data = new HashMap<ConnectorRecordPartition, RecordOffset>();
        return true;
    }

    public Future<Void> doFlush() {
        long flushId = this.currentFlushId;
        return this.sendOffsetFuture(flushId);
    }

    public synchronized void cancelFlush() {
        if (this.isFlushing()) {
            this.toFlush.putAll(this.data);
            this.data = this.toFlush;
            ++this.currentFlushId;
            this.toFlush = null;
        }
    }

    private Future<Void> sendOffsetFuture(long flushId) {
        FutureTask<Void> futureTask = new FutureTask<Void>(new SendOffsetCallback(flushId));
        this.executorService.submit(futureTask);
        return futureTask;
    }

    @Override
    public void close() throws IOException {
        this.executorService.shutdown();
    }

    private class SendOffsetCallback
    implements Callable<Void> {
        long flushId;

        public SendOffsetCallback(long flushId) {
            this.flushId = flushId;
        }

        @Override
        public Void call() {
            try {
                if (this.flushId != OffsetStorageWriterImpl.this.currentFlushId) {
                    return null;
                }
                OffsetStorageWriterImpl.this.offsetManagementService.putPosition(OffsetStorageWriterImpl.this.toFlush);
                log.debug("Submitting {} entries to backing store. The offsets are: {}", (Object)OffsetStorageWriterImpl.this.toFlush.size(), (Object)OffsetStorageWriterImpl.this.toFlush);
                OffsetStorageWriterImpl.this.offsetManagementService.persist();
                OffsetStorageWriterImpl.this.offsetManagementService.synchronize();
                OffsetStorageWriterImpl.this.toFlush = null;
                OffsetStorageWriterImpl.this.currentFlushId++;
            }
            catch (Throwable throwable) {
                OffsetStorageWriterImpl.this.cancelFlush();
            }
            return null;
        }
    }
}

