/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.protocol.http;

import com.fasterxml.jackson.core.type.TypeReference;
import io.cloudevents.CloudEvent;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.eventmesh.common.Constants;
import org.apache.eventmesh.common.protocol.ProtocolTransportObject;
import org.apache.eventmesh.common.protocol.http.HttpEventWrapper;
import org.apache.eventmesh.common.protocol.http.common.RequestURI;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.protocol.api.ProtocolAdaptor;
import org.apache.eventmesh.protocol.api.exception.ProtocolHandleException;
import org.apache.eventmesh.protocol.http.resolver.HttpRequestProtocolResolver;

public class HttpProtocolAdaptor<T extends ProtocolTransportObject>
implements ProtocolAdaptor<ProtocolTransportObject> {
    public CloudEvent toCloudEvent(ProtocolTransportObject protocolTransportObject) throws ProtocolHandleException {
        if (protocolTransportObject instanceof HttpEventWrapper) {
            HttpEventWrapper httpEventWrapper = (HttpEventWrapper)protocolTransportObject;
            String requestURI = httpEventWrapper.getRequestURI();
            return this.deserializeProtocol(requestURI, httpEventWrapper);
        }
        throw new ProtocolHandleException(String.format("protocol class: %s", protocolTransportObject.getClass()));
    }

    private CloudEvent deserializeProtocol(String requestURI, HttpEventWrapper httpEventWrapper) throws ProtocolHandleException {
        if (requestURI.startsWith(RequestURI.PUBLISH.getRequestURI()) || requestURI.startsWith(RequestURI.PUBLISH_BRIDGE.getRequestURI())) {
            return HttpRequestProtocolResolver.buildEvent(httpEventWrapper);
        }
        throw new ProtocolHandleException(String.format("unsupported requestURI: %s", requestURI));
    }

    public List<CloudEvent> toBatchCloudEvent(ProtocolTransportObject protocol) throws ProtocolHandleException {
        return Collections.emptyList();
    }

    public ProtocolTransportObject fromCloudEvent(CloudEvent cloudEvent) throws ProtocolHandleException {
        HttpEventWrapper httpEventWrapper = new HttpEventWrapper();
        HashMap<String, Object> sysHeaderMap = new HashMap<String, Object>();
        Set attributeNames = cloudEvent.getAttributeNames();
        Set extensionNames = cloudEvent.getExtensionNames();
        for (String attributeName : attributeNames) {
            sysHeaderMap.put(attributeName, cloudEvent.getAttribute(attributeName));
        }
        for (String extensionName : extensionNames) {
            sysHeaderMap.put(extensionName, cloudEvent.getExtension(extensionName));
        }
        httpEventWrapper.setSysHeaderMap(sysHeaderMap);
        if (null != cloudEvent.getData()) {
            Map dataContentMap = (Map)JsonUtils.parseTypeReferenceObject((String)new String(Objects.requireNonNull(cloudEvent.getData()).toBytes(), Constants.DEFAULT_CHARSET), (TypeReference)new TypeReference<Map<String, Object>>(){});
            String requestHeader = JsonUtils.toJSONString(Objects.requireNonNull(dataContentMap, "Headers must not be null").get("headers"));
            byte[] requestBody = Objects.requireNonNull(JsonUtils.toJSONString(dataContentMap.get("body")), "Body must not be null").getBytes(StandardCharsets.UTF_8);
            Map requestHeaderMap = (Map)JsonUtils.parseTypeReferenceObject((String)requestHeader, (TypeReference)new TypeReference<Map<String, Object>>(){});
            String requestURI = dataContentMap.get("path").toString();
            String httpMethod = dataContentMap.get("method").toString();
            httpEventWrapper.setHeaderMap(requestHeaderMap);
            httpEventWrapper.setBody(requestBody);
            httpEventWrapper.setRequestURI(requestURI);
            httpEventWrapper.setHttpMethod(httpMethod);
        }
        return httpEventWrapper;
    }

    public String getProtocolType() {
        return "http";
    }
}

