/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.openconnect.offsetmgmt.api.storage;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.RecordOffset;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.RecordPartition;
import org.apache.eventmesh.openconnect.offsetmgmt.api.storage.ConnectorRecordPartition;
import org.apache.eventmesh.openconnect.offsetmgmt.api.storage.OffsetManagementService;
import org.apache.eventmesh.openconnect.offsetmgmt.api.storage.OffsetStorageReader;

public class OffsetStorageReaderImpl
implements OffsetStorageReader {
    private final String connectorName;
    private OffsetManagementService offsetManagementService;

    public OffsetStorageReaderImpl(String connectorName, OffsetManagementService offsetManagementService) {
        this.connectorName = connectorName;
        this.offsetManagementService = offsetManagementService;
    }

    @Override
    public RecordOffset readOffset(RecordPartition partition) {
        ConnectorRecordPartition connectorRecordPartition = new ConnectorRecordPartition(this.connectorName, partition.getPartition());
        return this.offsetManagementService.getPositionMap().get(connectorRecordPartition);
    }

    @Override
    public Map<RecordPartition, RecordOffset> readOffsets(Collection<RecordPartition> partitions) {
        HashMap<RecordPartition, RecordOffset> result = new HashMap<RecordPartition, RecordOffset>();
        Map<ConnectorRecordPartition, RecordOffset> allData = this.offsetManagementService.getPositionMap();
        for (RecordPartition key : partitions) {
            ConnectorRecordPartition connectorRecordPartition = new ConnectorRecordPartition(this.connectorName, key.getPartition());
            if (!allData.containsKey(connectorRecordPartition)) continue;
            result.put(key, allData.get(connectorRecordPartition));
        }
        return result;
    }
}

