/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.openconnect.offsetmgmt.api.data;

import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.RecordOffset;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.RecordPartition;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.RecordPosition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordOffsetManagement {
    private static final Logger log = LoggerFactory.getLogger(RecordOffsetManagement.class);
    final Map<RecordPartition, Deque<SubmittedPosition>> records = new HashMap<RecordPartition, Deque<SubmittedPosition>>();
    private final AtomicInteger numUnacked = new AtomicInteger(0);
    private CountDownLatch messageDrainLatch;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubmittedPosition submitRecord(RecordPosition position) {
        SubmittedPosition submittedPosition = new SubmittedPosition(position);
        this.records.computeIfAbsent(position.getPartition(), e -> new LinkedList()).add(submittedPosition);
        RecordOffsetManagement recordOffsetManagement = this;
        synchronized (recordOffsetManagement) {
            this.numUnacked.incrementAndGet();
        }
        return submittedPosition;
    }

    private RecordOffset pollOffsetWhile(Deque<SubmittedPosition> submittedPositions) {
        RecordOffset offset = null;
        while (this.canCommitHead(submittedPositions)) {
            offset = submittedPositions.poll().getPosition().getOffset();
        }
        return offset;
    }

    private boolean canCommitHead(Deque<SubmittedPosition> submittedPositions) {
        return submittedPositions.peek() != null && submittedPositions.peek().getAcked() != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean awaitAllMessages(long timeout, TimeUnit timeUnit) {
        CountDownLatch messageDrainLatch;
        RecordOffsetManagement recordOffsetManagement = this;
        synchronized (recordOffsetManagement) {
            this.messageDrainLatch = messageDrainLatch = new CountDownLatch(this.numUnacked.get());
        }
        try {
            return messageDrainLatch.await(timeout, timeUnit);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    public CommittableOffsets committableOffsets() {
        HashMap<RecordPartition, RecordOffset> offsets = new HashMap<RecordPartition, RecordOffset>();
        int totalCommittableMessages = 0;
        int totalUncommittableMessages = 0;
        int largestDequeSize = 0;
        RecordPartition largestDequePartition = null;
        for (Map.Entry<RecordPartition, Deque<SubmittedPosition>> entry : this.records.entrySet()) {
            RecordPartition partition = entry.getKey();
            Deque<SubmittedPosition> queuedRecords = entry.getValue();
            int initialDequeSize = queuedRecords.size();
            if (this.canCommitHead(queuedRecords)) {
                RecordOffset offset = this.pollOffsetWhile(queuedRecords);
                offsets.put(partition, offset);
            }
            int uncommittableMessages = queuedRecords.size();
            int committableMessages = initialDequeSize - uncommittableMessages;
            totalCommittableMessages += committableMessages;
            totalUncommittableMessages += uncommittableMessages;
            if (uncommittableMessages <= largestDequeSize) continue;
            largestDequeSize = uncommittableMessages;
            largestDequePartition = partition;
        }
        this.records.values().removeIf(Collection::isEmpty);
        return new CommittableOffsets(offsets, totalCommittableMessages, totalUncommittableMessages, this.records.size(), largestDequeSize, largestDequePartition);
    }

    private synchronized void messageAcked() {
        this.numUnacked.decrementAndGet();
        if (this.messageDrainLatch != null) {
            this.messageDrainLatch.countDown();
        }
    }

    public class SubmittedPosition {
        private final RecordPosition position;
        private final AtomicBoolean acked;

        public SubmittedPosition(RecordPosition position) {
            this.position = position;
            this.acked = new AtomicBoolean(false);
        }

        public void ack() {
            if (this.acked.compareAndSet(false, true)) {
                RecordOffsetManagement.this.messageAcked();
            }
        }

        public boolean remove() {
            Deque<SubmittedPosition> deque = RecordOffsetManagement.this.records.get(this.position.getPartition());
            if (deque == null) {
                return false;
            }
            boolean result = deque.removeLastOccurrence(this);
            if (deque.isEmpty()) {
                RecordOffsetManagement.this.records.remove(this.position.getPartition());
            }
            if (result) {
                RecordOffsetManagement.this.messageAcked();
            } else {
                log.warn("Attempted to remove record from submitted queue for partition {}, but the record has not been submitted or has already been removed", (Object)this.position.getPartition());
            }
            return result;
        }

        public RecordPosition getPosition() {
            return this.position;
        }

        public Boolean getAcked() {
            return this.acked.get();
        }
    }

    public static class CommittableOffsets {
        public static final CommittableOffsets EMPTY = new CommittableOffsets(Collections.emptyMap(), 0, 0, 0, 0, null);
        private final Map<RecordPartition, RecordOffset> offsets;
        private final RecordPartition largestDequePartition;
        private final int numCommittableMessages;
        private final int numUncommittableMessages;
        private final int numDeques;
        private final int largestDequeSize;

        CommittableOffsets(Map<RecordPartition, RecordOffset> offsets, int numCommittableMessages, int numUncommittableMessages, int numDeques, int largestDequeSize, RecordPartition largestDequePartition) {
            this.offsets = offsets != null ? new HashMap<RecordPartition, RecordOffset>(offsets) : Collections.emptyMap();
            this.numCommittableMessages = numCommittableMessages;
            this.numUncommittableMessages = numUncommittableMessages;
            this.numDeques = numDeques;
            this.largestDequeSize = largestDequeSize;
            this.largestDequePartition = largestDequePartition;
        }

        public Map<RecordPartition, RecordOffset> offsets() {
            return Collections.unmodifiableMap(this.offsets);
        }

        public int numCommittableMessages() {
            return this.numCommittableMessages;
        }

        public int numUncommittableMessages() {
            return this.numUncommittableMessages;
        }

        public int numDeques() {
            return this.numDeques;
        }

        public int largestDequeSize() {
            return this.largestDequeSize;
        }

        public RecordPartition largestDequePartition() {
            return this.largestDequePartition;
        }

        public boolean hasPending() {
            return this.numUncommittableMessages > 0;
        }

        public boolean isEmpty() {
            return this.numCommittableMessages == 0 && this.numUncommittableMessages == 0 && this.offsets.isEmpty();
        }

        public CommittableOffsets updatedWith(CommittableOffsets newerOffsets) {
            HashMap<RecordPartition, RecordOffset> offsets = new HashMap<RecordPartition, RecordOffset>(this.offsets);
            offsets.putAll(newerOffsets.offsets);
            return new CommittableOffsets(offsets, this.numCommittableMessages + newerOffsets.numCommittableMessages, newerOffsets.numUncommittableMessages, newerOffsets.numDeques, newerOffsets.largestDequeSize, newerOffsets.largestDequePartition);
        }
    }
}

