/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.client.grpc.consumer;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.apache.eventmesh.client.grpc.config.EventMeshGrpcClientConfig;
import org.apache.eventmesh.client.grpc.consumer.ReceiveMsgHook;
import org.apache.eventmesh.client.grpc.consumer.SubStreamHandler;
import org.apache.eventmesh.client.grpc.util.EventMeshCloudEventBuilder;
import org.apache.eventmesh.common.EventMeshThreadFactory;
import org.apache.eventmesh.common.enums.EventMeshDataContentType;
import org.apache.eventmesh.common.enums.EventMeshProtocolType;
import org.apache.eventmesh.common.protocol.HeartbeatItem;
import org.apache.eventmesh.common.protocol.SubscriptionItem;
import org.apache.eventmesh.common.protocol.grpc.cloudevents.CloudEvent;
import org.apache.eventmesh.common.protocol.grpc.cloudevents.ConsumerServiceGrpc;
import org.apache.eventmesh.common.protocol.grpc.cloudevents.HeartbeatServiceGrpc;
import org.apache.eventmesh.common.protocol.grpc.common.ClientType;
import org.apache.eventmesh.common.protocol.grpc.common.EventMeshCloudEventUtils;
import org.apache.eventmesh.common.protocol.grpc.common.GrpcType;
import org.apache.eventmesh.common.protocol.grpc.common.Response;
import org.apache.eventmesh.common.protocol.grpc.common.StatusCode;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.common.utils.LogUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMeshGrpcConsumer
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(EventMeshGrpcConsumer.class);
    private static final String SDK_STREAM_URL = "grpc_stream";
    private ManagedChannel channel;
    private final EventMeshGrpcClientConfig clientConfig;
    private final Map<String, SubscriptionInfo> subscriptionMap = new ConcurrentHashMap<String, SubscriptionInfo>();
    private final ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), (ThreadFactory)new EventMeshThreadFactory("GRPCClientScheduler", true));
    private ConsumerServiceGrpc.ConsumerServiceBlockingStub consumerClient;
    private ConsumerServiceGrpc.ConsumerServiceStub consumerAsyncClient;
    private HeartbeatServiceGrpc.HeartbeatServiceBlockingStub heartbeatClient;
    private ReceiveMsgHook<?> listener;
    private SubStreamHandler<?> subStreamHandler;

    public EventMeshGrpcConsumer(EventMeshGrpcClientConfig clientConfig) {
        this.clientConfig = clientConfig;
    }

    public void init() {
        this.channel = ManagedChannelBuilder.forAddress((String)this.clientConfig.getServerAddr(), (int)this.clientConfig.getServerPort()).usePlaintext().build();
        this.consumerClient = ConsumerServiceGrpc.newBlockingStub((Channel)this.channel);
        this.consumerAsyncClient = ConsumerServiceGrpc.newStub((Channel)this.channel);
        this.heartbeatClient = HeartbeatServiceGrpc.newBlockingStub((Channel)this.channel);
        this.heartBeat();
    }

    public Response subscribe(List<SubscriptionItem> subscriptionItems, String url) {
        LogUtils.info((Logger)log, (String)"Create subscription: {} , url: {}", subscriptionItems, (Object)url);
        this.addSubscription(subscriptionItems, url, GrpcType.WEBHOOK);
        return this.subscribeWebhook(subscriptionItems, url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(List<SubscriptionItem> subscriptionItems) {
        LogUtils.info((Logger)log, (String)"Create streaming subscription: {}", subscriptionItems);
        if (this.listener == null) {
            log.error("Error in subscriber, no Event Listener is registered.");
            return;
        }
        this.addSubscription(subscriptionItems, SDK_STREAM_URL, GrpcType.STREAM);
        CloudEvent subscription = EventMeshCloudEventBuilder.buildEventSubscription(this.clientConfig, EventMeshProtocolType.EVENT_MESH_MESSAGE, null, subscriptionItems);
        EventMeshGrpcConsumer eventMeshGrpcConsumer = this;
        synchronized (eventMeshGrpcConsumer) {
            if (this.subStreamHandler == null) {
                this.subStreamHandler = new SubStreamHandler(this.consumerAsyncClient, this.clientConfig, this.listener);
                this.subStreamHandler.start();
            }
        }
        this.subStreamHandler.sendSubscription(subscription);
    }

    private Response subscribeWebhook(List<SubscriptionItem> subscriptionItems, String url) {
        CloudEvent subscription = EventMeshCloudEventBuilder.buildEventSubscription(this.clientConfig, EventMeshProtocolType.EVENT_MESH_MESSAGE, url, subscriptionItems);
        try {
            CloudEvent response = this.consumerClient.subscribe(subscription);
            LogUtils.info((Logger)log, (String)"Received response:{}", (Object)response);
            return Response.builder().respCode(EventMeshCloudEventUtils.getResponseCode((CloudEvent)response)).respMsg(EventMeshCloudEventUtils.getResponseMessage((CloudEvent)response)).respTime(EventMeshCloudEventUtils.getResponseTime((CloudEvent)response)).build();
        }
        catch (Exception e) {
            log.error("Error in subscribe.", (Throwable)e);
            return null;
        }
    }

    private void addSubscription(List<SubscriptionItem> subscriptionItems, String url, GrpcType grpcType) {
        for (SubscriptionItem item : subscriptionItems) {
            this.subscriptionMap.putIfAbsent(item.getTopic(), new SubscriptionInfo(item, url, grpcType));
        }
    }

    private void removeSubscription(List<SubscriptionItem> subscriptionItems) {
        Objects.requireNonNull(subscriptionItems, "subscriptionItems can not be null");
        subscriptionItems.forEach(item -> this.subscriptionMap.remove(item.getTopic()));
    }

    public Response unsubscribe(List<SubscriptionItem> subscriptionItems, String url) {
        LogUtils.info((Logger)log, (String)"Removing subscription: {}, url:{}", subscriptionItems, (Object)url);
        this.removeSubscription(subscriptionItems);
        CloudEvent cloudEvent = EventMeshCloudEventBuilder.buildEventSubscription(this.clientConfig, EventMeshProtocolType.EVENT_MESH_MESSAGE, url, subscriptionItems);
        try {
            CloudEvent response = this.consumerClient.unsubscribe(cloudEvent);
            LogUtils.info((Logger)log, (String)"Received response:{}", (Object)response);
            return Response.builder().respCode(EventMeshCloudEventUtils.getResponseCode((CloudEvent)response)).respMsg(EventMeshCloudEventUtils.getResponseMessage((CloudEvent)response)).respTime(EventMeshCloudEventUtils.getResponseTime((CloudEvent)response)).build();
        }
        catch (Exception e) {
            log.error("Error in unsubscribe.", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response unsubscribe(List<SubscriptionItem> subscriptionItems) {
        Objects.requireNonNull(subscriptionItems, "subscriptionItems can not be null");
        LogUtils.info((Logger)log, (String)"Removing subscription stream: {}", subscriptionItems);
        this.removeSubscription(subscriptionItems);
        CloudEvent cloudEvent = EventMeshCloudEventBuilder.buildEventSubscription(this.clientConfig, EventMeshProtocolType.EVENT_MESH_MESSAGE, null, subscriptionItems);
        try {
            CloudEvent response = this.consumerClient.unsubscribe(cloudEvent);
            Response parsedResponse = Response.builder().respCode(EventMeshCloudEventUtils.getResponseCode((CloudEvent)response)).respMsg(EventMeshCloudEventUtils.getResponseMessage((CloudEvent)response)).respTime(EventMeshCloudEventUtils.getResponseTime((CloudEvent)response)).build();
            LogUtils.info((Logger)log, (String)"Received response:{}", (Object)parsedResponse);
            EventMeshGrpcConsumer eventMeshGrpcConsumer = this;
            synchronized (eventMeshGrpcConsumer) {
                if (MapUtils.isEmpty(this.subscriptionMap) && this.subStreamHandler != null) {
                    this.subStreamHandler.close();
                }
            }
            return parsedResponse;
        }
        catch (Exception e) {
            log.error("Error in unsubscribe.", (Throwable)e);
            return null;
        }
    }

    public synchronized void registerListener(ReceiveMsgHook<?> listener) {
        if (this.listener == null) {
            this.listener = listener;
        }
    }

    private void heartBeat() {
        Map<String, CloudEvent.CloudEventAttributeValue> attributeValueMap = EventMeshCloudEventBuilder.buildCommonCloudEventAttributes(this.clientConfig, EventMeshProtocolType.EVENT_MESH_MESSAGE);
        this.scheduler.scheduleAtFixedRate(() -> {
            if (MapUtils.isEmpty(this.subscriptionMap)) {
                return;
            }
            HashMap<String, CloudEvent.CloudEventAttributeValue> ext = new HashMap<String, CloudEvent.CloudEventAttributeValue>(attributeValueMap);
            ext.put("consumergroup", CloudEvent.CloudEventAttributeValue.newBuilder().setCeString(this.clientConfig.getConsumerGroup()).build());
            ext.put("clienttype", CloudEvent.CloudEventAttributeValue.newBuilder().setCeInteger(ClientType.SUB.getType()).build());
            ext.put("datacontenttype", CloudEvent.CloudEventAttributeValue.newBuilder().setCeString(EventMeshDataContentType.JSON.getCode()).build());
            CloudEvent.Builder heartbeatBuilder = CloudEvent.newBuilder().putAllAttributes(ext);
            List heartbeatItems = this.subscriptionMap.entrySet().stream().map(entry -> HeartbeatItem.builder().topic((String)entry.getKey()).url(((SubscriptionInfo)entry.getValue()).getUrl()).build()).collect(Collectors.toList());
            CloudEvent heartbeat = heartbeatBuilder.setTextData(JsonUtils.toJSONString(heartbeatItems)).build();
            try {
                CloudEvent cloudEventResp = this.heartbeatClient.heartbeat(heartbeat);
                assert (cloudEventResp != null);
                Response response = Response.builder().respCode(EventMeshCloudEventUtils.getResponseCode((CloudEvent)cloudEventResp)).respMsg(EventMeshCloudEventUtils.getResponseMessage((CloudEvent)cloudEventResp)).respTime(EventMeshCloudEventUtils.getResponseTime((CloudEvent)cloudEventResp)).build();
                LogUtils.debug((Logger)log, (String)"Grpc Consumer Heartbeat cloudEvent: {}", (Object)response);
                if (StatusCode.CLIENT_RESUBSCRIBE.getRetCode().equals(response.getRespCode())) {
                    this.resubscribe();
                }
            }
            catch (Exception e) {
                log.error("Error in sending out heartbeat.", (Throwable)e);
            }
        }, 10000L, 30000L, TimeUnit.MILLISECONDS);
        LogUtils.info((Logger)log, (String)"Grpc Consumer Heartbeat started.");
    }

    private void resubscribe() {
        if (this.subscriptionMap.isEmpty()) {
            return;
        }
        Collection<SubscriptionInfo> values = this.subscriptionMap.values();
        AtomicBoolean isStreamSub = new AtomicBoolean(false);
        for (SubscriptionInfo info : values) {
            if (info.grpcType != GrpcType.STREAM) continue;
            isStreamSub.compareAndSet(false, true);
            break;
        }
        Map subscriptionGroup = values.stream().collect(Collectors.groupingBy(SubscriptionInfo::getUrl, Collectors.mapping(SubscriptionInfo::getSubscriptionItem, Collectors.toList())));
        subscriptionGroup.forEach((url, items) -> {
            if (isStreamSub.get()) {
                CloudEvent subscription = EventMeshCloudEventBuilder.buildEventSubscription(this.clientConfig, EventMeshProtocolType.EVENT_MESH_MESSAGE, url, items);
                this.subStreamHandler.sendSubscription(subscription);
            } else {
                this.subscribeWebhook((List<SubscriptionItem>)items, (String)url);
            }
        });
    }

    @Override
    public void close() {
        if (this.subStreamHandler != null) {
            this.subStreamHandler.close();
        }
        if (this.channel != null) {
            this.channel.shutdown();
        }
        if (this.scheduler != null) {
            this.scheduler.shutdown();
        }
    }

    public ManagedChannel getChannel() {
        return this.channel;
    }

    public EventMeshGrpcClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public Map<String, SubscriptionInfo> getSubscriptionMap() {
        return this.subscriptionMap;
    }

    public ScheduledThreadPoolExecutor getScheduler() {
        return this.scheduler;
    }

    public ConsumerServiceGrpc.ConsumerServiceBlockingStub getConsumerClient() {
        return this.consumerClient;
    }

    public ConsumerServiceGrpc.ConsumerServiceStub getConsumerAsyncClient() {
        return this.consumerAsyncClient;
    }

    public HeartbeatServiceGrpc.HeartbeatServiceBlockingStub getHeartbeatClient() {
        return this.heartbeatClient;
    }

    public ReceiveMsgHook<?> getListener() {
        return this.listener;
    }

    public SubStreamHandler<?> getSubStreamHandler() {
        return this.subStreamHandler;
    }

    public void setChannel(ManagedChannel channel) {
        this.channel = channel;
    }

    public void setConsumerClient(ConsumerServiceGrpc.ConsumerServiceBlockingStub consumerClient) {
        this.consumerClient = consumerClient;
    }

    public void setConsumerAsyncClient(ConsumerServiceGrpc.ConsumerServiceStub consumerAsyncClient) {
        this.consumerAsyncClient = consumerAsyncClient;
    }

    public void setHeartbeatClient(HeartbeatServiceGrpc.HeartbeatServiceBlockingStub heartbeatClient) {
        this.heartbeatClient = heartbeatClient;
    }

    public void setListener(ReceiveMsgHook<?> listener) {
        this.listener = listener;
    }

    public void setSubStreamHandler(SubStreamHandler<?> subStreamHandler) {
        this.subStreamHandler = subStreamHandler;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventMeshGrpcConsumer)) {
            return false;
        }
        EventMeshGrpcConsumer other = (EventMeshGrpcConsumer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ManagedChannel this$channel = this.getChannel();
        ManagedChannel other$channel = other.getChannel();
        if (this$channel == null ? other$channel != null : !this$channel.equals(other$channel)) {
            return false;
        }
        EventMeshGrpcClientConfig this$clientConfig = this.getClientConfig();
        EventMeshGrpcClientConfig other$clientConfig = other.getClientConfig();
        if (this$clientConfig == null ? other$clientConfig != null : !((Object)this$clientConfig).equals(other$clientConfig)) {
            return false;
        }
        Map<String, SubscriptionInfo> this$subscriptionMap = this.getSubscriptionMap();
        Map<String, SubscriptionInfo> other$subscriptionMap = other.getSubscriptionMap();
        if (this$subscriptionMap == null ? other$subscriptionMap != null : !((Object)this$subscriptionMap).equals(other$subscriptionMap)) {
            return false;
        }
        ScheduledThreadPoolExecutor this$scheduler = this.getScheduler();
        ScheduledThreadPoolExecutor other$scheduler = other.getScheduler();
        if (this$scheduler == null ? other$scheduler != null : !this$scheduler.equals(other$scheduler)) {
            return false;
        }
        ConsumerServiceGrpc.ConsumerServiceBlockingStub this$consumerClient = this.getConsumerClient();
        ConsumerServiceGrpc.ConsumerServiceBlockingStub other$consumerClient = other.getConsumerClient();
        if (this$consumerClient == null ? other$consumerClient != null : !this$consumerClient.equals(other$consumerClient)) {
            return false;
        }
        ConsumerServiceGrpc.ConsumerServiceStub this$consumerAsyncClient = this.getConsumerAsyncClient();
        ConsumerServiceGrpc.ConsumerServiceStub other$consumerAsyncClient = other.getConsumerAsyncClient();
        if (this$consumerAsyncClient == null ? other$consumerAsyncClient != null : !this$consumerAsyncClient.equals(other$consumerAsyncClient)) {
            return false;
        }
        HeartbeatServiceGrpc.HeartbeatServiceBlockingStub this$heartbeatClient = this.getHeartbeatClient();
        HeartbeatServiceGrpc.HeartbeatServiceBlockingStub other$heartbeatClient = other.getHeartbeatClient();
        if (this$heartbeatClient == null ? other$heartbeatClient != null : !this$heartbeatClient.equals(other$heartbeatClient)) {
            return false;
        }
        ReceiveMsgHook<?> this$listener = this.getListener();
        ReceiveMsgHook<?> other$listener = other.getListener();
        if (this$listener == null ? other$listener != null : !this$listener.equals(other$listener)) {
            return false;
        }
        SubStreamHandler<?> this$subStreamHandler = this.getSubStreamHandler();
        SubStreamHandler<?> other$subStreamHandler = other.getSubStreamHandler();
        return !(this$subStreamHandler == null ? other$subStreamHandler != null : !this$subStreamHandler.equals(other$subStreamHandler));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EventMeshGrpcConsumer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ManagedChannel $channel = this.getChannel();
        result = result * 59 + ($channel == null ? 43 : $channel.hashCode());
        EventMeshGrpcClientConfig $clientConfig = this.getClientConfig();
        result = result * 59 + ($clientConfig == null ? 43 : ((Object)$clientConfig).hashCode());
        Map<String, SubscriptionInfo> $subscriptionMap = this.getSubscriptionMap();
        result = result * 59 + ($subscriptionMap == null ? 43 : ((Object)$subscriptionMap).hashCode());
        ScheduledThreadPoolExecutor $scheduler = this.getScheduler();
        result = result * 59 + ($scheduler == null ? 43 : $scheduler.hashCode());
        ConsumerServiceGrpc.ConsumerServiceBlockingStub $consumerClient = this.getConsumerClient();
        result = result * 59 + ($consumerClient == null ? 43 : $consumerClient.hashCode());
        ConsumerServiceGrpc.ConsumerServiceStub $consumerAsyncClient = this.getConsumerAsyncClient();
        result = result * 59 + ($consumerAsyncClient == null ? 43 : $consumerAsyncClient.hashCode());
        HeartbeatServiceGrpc.HeartbeatServiceBlockingStub $heartbeatClient = this.getHeartbeatClient();
        result = result * 59 + ($heartbeatClient == null ? 43 : $heartbeatClient.hashCode());
        ReceiveMsgHook<?> $listener = this.getListener();
        result = result * 59 + ($listener == null ? 43 : $listener.hashCode());
        SubStreamHandler<?> $subStreamHandler = this.getSubStreamHandler();
        result = result * 59 + ($subStreamHandler == null ? 43 : $subStreamHandler.hashCode());
        return result;
    }

    public String toString() {
        return "EventMeshGrpcConsumer(channel=" + this.getChannel() + ", clientConfig=" + this.getClientConfig() + ", subscriptionMap=" + this.getSubscriptionMap() + ", scheduler=" + this.getScheduler() + ", consumerClient=" + this.getConsumerClient() + ", consumerAsyncClient=" + this.getConsumerAsyncClient() + ", heartbeatClient=" + this.getHeartbeatClient() + ", listener=" + this.getListener() + ", subStreamHandler=" + this.getSubStreamHandler() + ")";
    }

    private static class SubscriptionInfo {
        private transient SubscriptionItem subscriptionItem;
        private transient String url;
        private GrpcType grpcType;

        SubscriptionInfo(SubscriptionItem subscriptionItem, String url, GrpcType grpcType) {
            this.subscriptionItem = subscriptionItem;
            this.url = url;
            this.grpcType = grpcType;
        }

        public GrpcType getGrpcType() {
            return this.grpcType;
        }

        public SubscriptionItem getSubscriptionItem() {
            return this.subscriptionItem;
        }

        public void setSubscriptionItem(SubscriptionItem subscriptionItem) {
            this.subscriptionItem = subscriptionItem;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }
    }
}

