/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.compress;

import com.navercorp.pinpoint.common.util.CollectionUtils;
import com.navercorp.pinpoint.grpc.trace.PSpan;
import com.navercorp.pinpoint.grpc.trace.PSpanChunk;
import com.navercorp.pinpoint.grpc.trace.PSpanEvent;
import com.navercorp.pinpoint.profiler.context.Span;
import com.navercorp.pinpoint.profiler.context.SpanChunk;
import com.navercorp.pinpoint.profiler.context.SpanEvent;
import com.navercorp.pinpoint.profiler.context.TraceDataFormatVersion;
import com.navercorp.pinpoint.profiler.context.compress.SpanEventSequenceComparator;
import com.navercorp.pinpoint.profiler.context.compress.SpanProcessor;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;

public class GrpcSpanProcessorV2
implements SpanProcessor<PSpan.Builder, PSpanChunk.Builder> {
    private static final byte V2 = TraceDataFormatVersion.V2.getVersion();
    private static final Comparator<SpanEvent> SEQUENCE_COMPARATOR = SpanEventSequenceComparator.INSTANCE;

    @Override
    public void preProcess(Span span, PSpan.Builder pSpan) {
        pSpan.setVersion((int)V2);
        List<SpanEvent> spanEventList = span.getSpanEventList();
        if (CollectionUtils.hasLength(spanEventList)) {
            Collections.sort(spanEventList, SEQUENCE_COMPARATOR);
        }
    }

    @Override
    public void preProcess(SpanChunk spanChunk, PSpanChunk.Builder pSpanChunk) {
        pSpanChunk.setVersion((int)V2);
        List<SpanEvent> spanEventList = spanChunk.getSpanEventList();
        if (CollectionUtils.hasLength(spanEventList)) {
            Collections.sort(spanEventList, SEQUENCE_COMPARATOR);
        }
    }

    @Override
    public void postProcess(SpanChunk spanChunk, PSpanChunk.Builder pSpanChunk) {
        List<SpanEvent> spanEventList = spanChunk.getSpanEventList();
        List tSpanEventList = pSpanChunk.getSpanEventBuilderList();
        long keyTime = this.getKeyTime(spanEventList);
        pSpanChunk.setKeyTime(keyTime);
        this.postProcess(keyTime, spanEventList, tSpanEventList);
    }

    @Override
    public void postProcess(Span span, PSpan.Builder pSpan) {
        List<SpanEvent> spanEventList = span.getSpanEventList();
        List tSpanEventList = pSpan.getSpanEventBuilderList();
        long keyTime = span.getStartTime();
        this.postProcess(keyTime, spanEventList, tSpanEventList);
    }

    private void postProcess(long keyTime, List<SpanEvent> spanEventList, List<PSpanEvent.Builder> pSpanEventList) {
        int spanEventSize = CollectionUtils.nullSafeSize(spanEventList);
        if (spanEventSize == 0) {
            return;
        }
        if (spanEventSize != CollectionUtils.nullSafeSize(pSpanEventList)) {
            throw new IllegalStateException("list size not same");
        }
        assert (spanEventList instanceof RandomAccess);
        int prevDepth = 0;
        boolean first = true;
        int listSize = spanEventList.size();
        for (int i = 0; i < listSize; ++i) {
            SpanEvent spanEvent = spanEventList.get(i);
            PSpanEvent.Builder pSpanEvent = pSpanEventList.get(i);
            long startTime = spanEvent.getStartTime();
            long startElapsedTime = startTime - keyTime;
            pSpanEvent.setStartElapsed((int)startElapsedTime);
            keyTime = startTime;
            if (first) {
                int depth;
                first = false;
                prevDepth = depth = spanEvent.getDepth();
                pSpanEvent.setDepth(depth);
                continue;
            }
            int currentDepth = spanEvent.getDepth();
            if (currentDepth == prevDepth) {
                pSpanEvent.setDepth(0);
            } else {
                pSpanEvent.setDepth(currentDepth);
            }
            prevDepth = currentDepth;
        }
    }

    private long getKeyTime(List<SpanEvent> spanEventList) {
        if (CollectionUtils.isEmpty(spanEventList)) {
            throw new IllegalArgumentException("spanEventList is empty.");
        }
        SpanEvent first = spanEventList.get(0);
        if (first == null) {
            throw new IllegalStateException("first SpanEvent is null");
        }
        return first.getStartTime();
    }
}

