/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.metadata;

import com.navercorp.pinpoint.bootstrap.context.ParsingResult;
import com.navercorp.pinpoint.profiler.metadata.CachingSqlNormalizer;
import com.navercorp.pinpoint.profiler.metadata.DefaultCachingSqlNormalizer;
import com.navercorp.pinpoint.profiler.metadata.MetaDataType;
import com.navercorp.pinpoint.profiler.metadata.SimpleCache;
import com.navercorp.pinpoint.profiler.metadata.SqlMetaData;
import com.navercorp.pinpoint.profiler.metadata.SqlMetaDataService;
import com.navercorp.pinpoint.profiler.sender.EnhancedDataSender;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultSqlMetaDataService
implements SqlMetaDataService {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final CachingSqlNormalizer cachingSqlNormalizer;
    private final EnhancedDataSender<MetaDataType> enhancedDataSender;

    public DefaultSqlMetaDataService(EnhancedDataSender<MetaDataType> enhancedDataSender, SimpleCache<String> sqlCache) {
        this.enhancedDataSender = Objects.requireNonNull(enhancedDataSender, "enhancedDataSender");
        Objects.requireNonNull(sqlCache, "sqlCache");
        this.cachingSqlNormalizer = new DefaultCachingSqlNormalizer(sqlCache);
    }

    @Override
    public ParsingResult parseSql(String sql) {
        return this.cachingSqlNormalizer.wrapSql(sql);
    }

    @Override
    public boolean cacheSql(ParsingResult parsingResult) {
        if (parsingResult == null) {
            return false;
        }
        boolean isNewValue = this.cachingSqlNormalizer.normalizedSql(parsingResult);
        if (isNewValue) {
            if (this.isDebug) {
                this.logger.debug("NewSQLParsingResult:{}", (Object)parsingResult);
            }
            SqlMetaData sqlMetaData = new SqlMetaData(parsingResult.getId(), parsingResult.getSql());
            this.enhancedDataSender.request(sqlMetaData);
        }
        return isNewValue;
    }
}

