/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.metadata;

import com.navercorp.pinpoint.profiler.metadata.MetaDataType;
import com.navercorp.pinpoint.profiler.metadata.Result;
import com.navercorp.pinpoint.profiler.metadata.SimpleCache;
import com.navercorp.pinpoint.profiler.metadata.StringMetaData;
import com.navercorp.pinpoint.profiler.metadata.StringMetaDataService;
import com.navercorp.pinpoint.profiler.sender.EnhancedDataSender;
import java.util.Objects;

public class DefaultStringMetaDataService
implements StringMetaDataService {
    private final SimpleCache<String> stringCache;
    private final EnhancedDataSender<MetaDataType> enhancedDataSender;

    public DefaultStringMetaDataService(EnhancedDataSender<MetaDataType> enhancedDataSender, SimpleCache<String> stringCache) {
        this.enhancedDataSender = Objects.requireNonNull(enhancedDataSender, "enhancedDataSender");
        this.stringCache = Objects.requireNonNull(stringCache, "stringCache");
    }

    @Override
    public int cacheString(String value) {
        if (value == null) {
            return 0;
        }
        Result result = this.stringCache.put(value);
        if (result.isNewValue()) {
            StringMetaData stringMetaData = new StringMetaData(result.getId(), value);
            this.enhancedDataSender.request(stringMetaData);
        }
        return result.getId();
    }
}

