/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.receiver.service;

import com.navercorp.pinpoint.common.util.JvmUtils;
import com.navercorp.pinpoint.profiler.context.active.ActiveTraceSnapshot;
import com.navercorp.pinpoint.profiler.context.thrift.ThreadStateThriftMessageConverter;
import com.navercorp.pinpoint.profiler.receiver.ProfilerRequestCommandService;
import com.navercorp.pinpoint.profiler.receiver.service.ActiveThreadDumpCoreService;
import com.navercorp.pinpoint.profiler.receiver.service.ThreadDump;
import com.navercorp.pinpoint.profiler.receiver.service.ThreadDumpRequest;
import com.navercorp.pinpoint.thrift.dto.command.TActiveThreadLightDump;
import com.navercorp.pinpoint.thrift.dto.command.TCmdActiveThreadLightDump;
import com.navercorp.pinpoint.thrift.dto.command.TCmdActiveThreadLightDumpRes;
import com.navercorp.pinpoint.thrift.dto.command.TThreadLightDump;
import com.navercorp.pinpoint.thrift.dto.command.TThreadState;
import com.navercorp.pinpoint.thrift.io.TCommandType;
import java.lang.management.ThreadInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.thrift.TBase;

public class ActiveThreadLightDumpService
implements ProfilerRequestCommandService<TBase<?, ?>, TBase<?, ?>> {
    private final ActiveThreadDumpCoreService activeThreadDump;
    private final ThreadStateThriftMessageConverter threadStateThriftMessageConverter = new ThreadStateThriftMessageConverter();

    public ActiveThreadLightDumpService(ActiveThreadDumpCoreService activeThreadDump) {
        this.activeThreadDump = Objects.requireNonNull(activeThreadDump, "activeThreadDump");
    }

    @Override
    public TBase<?, ?> requestCommandService(TBase<?, ?> tBase) {
        TCmdActiveThreadLightDump request = (TCmdActiveThreadLightDump)tBase;
        List<TActiveThreadLightDump> activeThreadDumpList = this.getActiveThreadDumpList(request);
        TCmdActiveThreadLightDumpRes response = new TCmdActiveThreadLightDumpRes();
        response.setType("JAVA");
        response.setSubType(JvmUtils.getType().name());
        response.setVersion(JvmUtils.getVersion().name());
        response.setThreadDumps(activeThreadDumpList);
        return response;
    }

    private List<TActiveThreadLightDump> getActiveThreadDumpList(TCmdActiveThreadLightDump tRequest) {
        ThreadDumpRequest request = ThreadDumpRequest.create(tRequest);
        Collection<ThreadDump> activeTraceInfoList = this.activeThreadDump.getActiveThreadDumpList(request);
        return this.toTActiveThreadLightDump(activeTraceInfoList);
    }

    private List<TActiveThreadLightDump> toTActiveThreadLightDump(Collection<ThreadDump> activeTraceInfoList) {
        ArrayList<TActiveThreadLightDump> result = new ArrayList<TActiveThreadLightDump>(activeTraceInfoList.size());
        for (ThreadDump threadDump : activeTraceInfoList) {
            TActiveThreadLightDump tActiveThreadDump = this.createActiveThreadDump(threadDump);
            result.add(tActiveThreadDump);
        }
        return result;
    }

    private TThreadLightDump createTThreadLightDump(ThreadInfo threadInfo) {
        TThreadLightDump threadDump = new TThreadLightDump();
        threadDump.setThreadName(threadInfo.getThreadName());
        threadDump.setThreadId(threadInfo.getThreadId());
        TThreadState threadState = this.threadStateThriftMessageConverter.toMessage((Object)threadInfo.getThreadState());
        threadDump.setThreadState(threadState);
        return threadDump;
    }

    private TActiveThreadLightDump createActiveThreadDump(ThreadDump threadDump) {
        ActiveTraceSnapshot activeTraceInfo = threadDump.getActiveTraceSnapshot();
        ThreadInfo threadInfo = threadDump.getThreadInfo();
        TThreadLightDump tThreadLightDump = this.createTThreadLightDump(threadInfo);
        TActiveThreadLightDump activeThreadDump = new TActiveThreadLightDump();
        activeThreadDump.setStartTime(activeTraceInfo.getStartTime());
        activeThreadDump.setLocalTraceId(activeTraceInfo.getLocalTransactionId());
        activeThreadDump.setThreadDump(tThreadLightDump);
        if (activeTraceInfo.isSampled()) {
            activeThreadDump.setSampled(true);
            activeThreadDump.setTransactionId(activeTraceInfo.getTransactionId());
            activeThreadDump.setEntryPoint(activeTraceInfo.getEntryPoint());
        }
        return activeThreadDump;
    }

    @Override
    public short getCommandServiceCode() {
        return TCommandType.ACTIVE_THREAD_LIGHT_DUMP.getCode();
    }
}

