/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.config;

import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.eventmesh.common.config.Config;
import org.apache.eventmesh.common.config.ConfigFiled;
import org.apache.eventmesh.common.utils.IPUtils;
import org.assertj.core.util.Strings;

@Config(prefix="eventMesh")
public class CommonConfiguration {
    @ConfigFiled(field="sysid", beNumber=true, notEmpty=true)
    private String sysID = "5477";
    @ConfigFiled(field="server.env", notEmpty=true)
    private String eventMeshEnv = "P";
    @ConfigFiled(field="server.idc", notEmpty=true)
    private String eventMeshIDC = "FT";
    @ConfigFiled(field="server.name", notEmpty=true)
    private String eventMeshName = "";
    @ConfigFiled(field="server.cluster", notEmpty=true)
    private String eventMeshCluster = "LS";
    @ConfigFiled(field="server.hostIp", reload=true)
    private String eventMeshServerIp = null;
    @ConfigFiled(field="metaStorage.plugin.server-addr", notEmpty=true)
    private String metaStorageAddr = "";
    @ConfigFiled(field="metaStorage.plugin.type", notEmpty=true)
    private String eventMeshMetaStoragePluginType = "nacos";
    @ConfigFiled(field="metaStorage.plugin.username")
    private String eventMeshMetaStoragePluginUsername = "";
    @ConfigFiled(field="metaStorage.plugin.password")
    private String eventMeshMetaStoragePluginPassword = "";
    @ConfigFiled(field="metaStorage.plugin.metaStorageIntervalInMills")
    private Integer eventMeshMetaStorageIntervalInMills = 10000;
    @ConfigFiled(field="metaStorage.plugin.fetchMetaStorageAddrIntervalInMills")
    private Integer eventMeshFetchMetaStorageAddrInterval = 10000;
    @ConfigFiled(field="metaStorage.plugin.enabled")
    private boolean eventMeshServerMetaStorageEnable = false;
    @ConfigFiled(field="trace.plugin", notEmpty=true)
    private String eventMeshTracePluginType;
    @ConfigFiled(field="metrics.plugin", notEmpty=true)
    private List<String> eventMeshMetricsPluginType;
    @ConfigFiled(field="security.plugin.type", notEmpty=true)
    private String eventMeshSecurityPluginType = "security";
    @ConfigFiled(field="connector.plugin.type", notEmpty=true)
    private String eventMeshConnectorPluginType = "rocketmq";
    @ConfigFiled(field="storage.plugin.type", notEmpty=true)
    private String eventMeshStoragePluginType = "rocketmq";
    @ConfigFiled(field="security.validation.type.token", notEmpty=true)
    private boolean eventMeshSecurityValidateTypeToken = false;
    @ConfigFiled(field="server.trace.enabled")
    private boolean eventMeshServerTraceEnable = false;
    @ConfigFiled(field="server.security.enabled")
    private boolean eventMeshServerSecurityEnable = false;
    @ConfigFiled(field="security.publickey")
    private String eventMeshSecurityPublickey = "";
    @ConfigFiled(field="server.provide.protocols", reload=true)
    private List<String> eventMeshProvideServerProtocols;
    @ConfigFiled(reload=true)
    private String eventMeshWebhookOrigin;
    @ConfigFiled(reload=true)
    private String meshGroup;
    @ConfigFiled(field="server.retry.plugin.type")
    private String eventMeshRetryPluginType = "default";

    public void reload() {
        this.eventMeshWebhookOrigin = "eventmesh." + this.eventMeshIDC;
        if (Strings.isNullOrEmpty((String)this.eventMeshServerIp)) {
            this.eventMeshServerIp = IPUtils.getLocalAddress();
        }
        if (CollectionUtils.isEmpty(this.eventMeshProvideServerProtocols)) {
            this.eventMeshProvideServerProtocols = Collections.singletonList("HTTP");
        }
        this.meshGroup = String.join((CharSequence)"-", this.eventMeshEnv, this.eventMeshIDC, this.eventMeshCluster, this.sysID);
    }

    public String getSysID() {
        return this.sysID;
    }

    public String getEventMeshEnv() {
        return this.eventMeshEnv;
    }

    public String getEventMeshIDC() {
        return this.eventMeshIDC;
    }

    public String getEventMeshName() {
        return this.eventMeshName;
    }

    public String getEventMeshCluster() {
        return this.eventMeshCluster;
    }

    public String getEventMeshServerIp() {
        return this.eventMeshServerIp;
    }

    public String getMetaStorageAddr() {
        return this.metaStorageAddr;
    }

    public String getEventMeshMetaStoragePluginType() {
        return this.eventMeshMetaStoragePluginType;
    }

    public String getEventMeshMetaStoragePluginUsername() {
        return this.eventMeshMetaStoragePluginUsername;
    }

    public String getEventMeshMetaStoragePluginPassword() {
        return this.eventMeshMetaStoragePluginPassword;
    }

    public Integer getEventMeshMetaStorageIntervalInMills() {
        return this.eventMeshMetaStorageIntervalInMills;
    }

    public Integer getEventMeshFetchMetaStorageAddrInterval() {
        return this.eventMeshFetchMetaStorageAddrInterval;
    }

    public boolean isEventMeshServerMetaStorageEnable() {
        return this.eventMeshServerMetaStorageEnable;
    }

    public String getEventMeshTracePluginType() {
        return this.eventMeshTracePluginType;
    }

    public List<String> getEventMeshMetricsPluginType() {
        return this.eventMeshMetricsPluginType;
    }

    public String getEventMeshSecurityPluginType() {
        return this.eventMeshSecurityPluginType;
    }

    public String getEventMeshConnectorPluginType() {
        return this.eventMeshConnectorPluginType;
    }

    public String getEventMeshStoragePluginType() {
        return this.eventMeshStoragePluginType;
    }

    public boolean isEventMeshSecurityValidateTypeToken() {
        return this.eventMeshSecurityValidateTypeToken;
    }

    public boolean isEventMeshServerTraceEnable() {
        return this.eventMeshServerTraceEnable;
    }

    public boolean isEventMeshServerSecurityEnable() {
        return this.eventMeshServerSecurityEnable;
    }

    public String getEventMeshSecurityPublickey() {
        return this.eventMeshSecurityPublickey;
    }

    public List<String> getEventMeshProvideServerProtocols() {
        return this.eventMeshProvideServerProtocols;
    }

    public String getEventMeshWebhookOrigin() {
        return this.eventMeshWebhookOrigin;
    }

    public String getMeshGroup() {
        return this.meshGroup;
    }

    public String getEventMeshRetryPluginType() {
        return this.eventMeshRetryPluginType;
    }

    public void setSysID(String sysID) {
        this.sysID = sysID;
    }

    public void setEventMeshEnv(String eventMeshEnv) {
        this.eventMeshEnv = eventMeshEnv;
    }

    public void setEventMeshIDC(String eventMeshIDC) {
        this.eventMeshIDC = eventMeshIDC;
    }

    public void setEventMeshName(String eventMeshName) {
        this.eventMeshName = eventMeshName;
    }

    public void setEventMeshCluster(String eventMeshCluster) {
        this.eventMeshCluster = eventMeshCluster;
    }

    public void setEventMeshServerIp(String eventMeshServerIp) {
        this.eventMeshServerIp = eventMeshServerIp;
    }

    public void setMetaStorageAddr(String metaStorageAddr) {
        this.metaStorageAddr = metaStorageAddr;
    }

    public void setEventMeshMetaStoragePluginType(String eventMeshMetaStoragePluginType) {
        this.eventMeshMetaStoragePluginType = eventMeshMetaStoragePluginType;
    }

    public void setEventMeshMetaStoragePluginUsername(String eventMeshMetaStoragePluginUsername) {
        this.eventMeshMetaStoragePluginUsername = eventMeshMetaStoragePluginUsername;
    }

    public void setEventMeshMetaStoragePluginPassword(String eventMeshMetaStoragePluginPassword) {
        this.eventMeshMetaStoragePluginPassword = eventMeshMetaStoragePluginPassword;
    }

    public void setEventMeshMetaStorageIntervalInMills(Integer eventMeshMetaStorageIntervalInMills) {
        this.eventMeshMetaStorageIntervalInMills = eventMeshMetaStorageIntervalInMills;
    }

    public void setEventMeshFetchMetaStorageAddrInterval(Integer eventMeshFetchMetaStorageAddrInterval) {
        this.eventMeshFetchMetaStorageAddrInterval = eventMeshFetchMetaStorageAddrInterval;
    }

    public void setEventMeshServerMetaStorageEnable(boolean eventMeshServerMetaStorageEnable) {
        this.eventMeshServerMetaStorageEnable = eventMeshServerMetaStorageEnable;
    }

    public void setEventMeshTracePluginType(String eventMeshTracePluginType) {
        this.eventMeshTracePluginType = eventMeshTracePluginType;
    }

    public void setEventMeshMetricsPluginType(List<String> eventMeshMetricsPluginType) {
        this.eventMeshMetricsPluginType = eventMeshMetricsPluginType;
    }

    public void setEventMeshSecurityPluginType(String eventMeshSecurityPluginType) {
        this.eventMeshSecurityPluginType = eventMeshSecurityPluginType;
    }

    public void setEventMeshConnectorPluginType(String eventMeshConnectorPluginType) {
        this.eventMeshConnectorPluginType = eventMeshConnectorPluginType;
    }

    public void setEventMeshStoragePluginType(String eventMeshStoragePluginType) {
        this.eventMeshStoragePluginType = eventMeshStoragePluginType;
    }

    public void setEventMeshSecurityValidateTypeToken(boolean eventMeshSecurityValidateTypeToken) {
        this.eventMeshSecurityValidateTypeToken = eventMeshSecurityValidateTypeToken;
    }

    public void setEventMeshServerTraceEnable(boolean eventMeshServerTraceEnable) {
        this.eventMeshServerTraceEnable = eventMeshServerTraceEnable;
    }

    public void setEventMeshServerSecurityEnable(boolean eventMeshServerSecurityEnable) {
        this.eventMeshServerSecurityEnable = eventMeshServerSecurityEnable;
    }

    public void setEventMeshSecurityPublickey(String eventMeshSecurityPublickey) {
        this.eventMeshSecurityPublickey = eventMeshSecurityPublickey;
    }

    public void setEventMeshProvideServerProtocols(List<String> eventMeshProvideServerProtocols) {
        this.eventMeshProvideServerProtocols = eventMeshProvideServerProtocols;
    }

    public void setEventMeshWebhookOrigin(String eventMeshWebhookOrigin) {
        this.eventMeshWebhookOrigin = eventMeshWebhookOrigin;
    }

    public void setMeshGroup(String meshGroup) {
        this.meshGroup = meshGroup;
    }

    public void setEventMeshRetryPluginType(String eventMeshRetryPluginType) {
        this.eventMeshRetryPluginType = eventMeshRetryPluginType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommonConfiguration)) {
            return false;
        }
        CommonConfiguration other = (CommonConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEventMeshServerMetaStorageEnable() != other.isEventMeshServerMetaStorageEnable()) {
            return false;
        }
        if (this.isEventMeshSecurityValidateTypeToken() != other.isEventMeshSecurityValidateTypeToken()) {
            return false;
        }
        if (this.isEventMeshServerTraceEnable() != other.isEventMeshServerTraceEnable()) {
            return false;
        }
        if (this.isEventMeshServerSecurityEnable() != other.isEventMeshServerSecurityEnable()) {
            return false;
        }
        Integer this$eventMeshMetaStorageIntervalInMills = this.getEventMeshMetaStorageIntervalInMills();
        Integer other$eventMeshMetaStorageIntervalInMills = other.getEventMeshMetaStorageIntervalInMills();
        if (this$eventMeshMetaStorageIntervalInMills == null ? other$eventMeshMetaStorageIntervalInMills != null : !((Object)this$eventMeshMetaStorageIntervalInMills).equals(other$eventMeshMetaStorageIntervalInMills)) {
            return false;
        }
        Integer this$eventMeshFetchMetaStorageAddrInterval = this.getEventMeshFetchMetaStorageAddrInterval();
        Integer other$eventMeshFetchMetaStorageAddrInterval = other.getEventMeshFetchMetaStorageAddrInterval();
        if (this$eventMeshFetchMetaStorageAddrInterval == null ? other$eventMeshFetchMetaStorageAddrInterval != null : !((Object)this$eventMeshFetchMetaStorageAddrInterval).equals(other$eventMeshFetchMetaStorageAddrInterval)) {
            return false;
        }
        String this$sysID = this.getSysID();
        String other$sysID = other.getSysID();
        if (this$sysID == null ? other$sysID != null : !this$sysID.equals(other$sysID)) {
            return false;
        }
        String this$eventMeshEnv = this.getEventMeshEnv();
        String other$eventMeshEnv = other.getEventMeshEnv();
        if (this$eventMeshEnv == null ? other$eventMeshEnv != null : !this$eventMeshEnv.equals(other$eventMeshEnv)) {
            return false;
        }
        String this$eventMeshIDC = this.getEventMeshIDC();
        String other$eventMeshIDC = other.getEventMeshIDC();
        if (this$eventMeshIDC == null ? other$eventMeshIDC != null : !this$eventMeshIDC.equals(other$eventMeshIDC)) {
            return false;
        }
        String this$eventMeshName = this.getEventMeshName();
        String other$eventMeshName = other.getEventMeshName();
        if (this$eventMeshName == null ? other$eventMeshName != null : !this$eventMeshName.equals(other$eventMeshName)) {
            return false;
        }
        String this$eventMeshCluster = this.getEventMeshCluster();
        String other$eventMeshCluster = other.getEventMeshCluster();
        if (this$eventMeshCluster == null ? other$eventMeshCluster != null : !this$eventMeshCluster.equals(other$eventMeshCluster)) {
            return false;
        }
        String this$eventMeshServerIp = this.getEventMeshServerIp();
        String other$eventMeshServerIp = other.getEventMeshServerIp();
        if (this$eventMeshServerIp == null ? other$eventMeshServerIp != null : !this$eventMeshServerIp.equals(other$eventMeshServerIp)) {
            return false;
        }
        String this$metaStorageAddr = this.getMetaStorageAddr();
        String other$metaStorageAddr = other.getMetaStorageAddr();
        if (this$metaStorageAddr == null ? other$metaStorageAddr != null : !this$metaStorageAddr.equals(other$metaStorageAddr)) {
            return false;
        }
        String this$eventMeshMetaStoragePluginType = this.getEventMeshMetaStoragePluginType();
        String other$eventMeshMetaStoragePluginType = other.getEventMeshMetaStoragePluginType();
        if (this$eventMeshMetaStoragePluginType == null ? other$eventMeshMetaStoragePluginType != null : !this$eventMeshMetaStoragePluginType.equals(other$eventMeshMetaStoragePluginType)) {
            return false;
        }
        String this$eventMeshMetaStoragePluginUsername = this.getEventMeshMetaStoragePluginUsername();
        String other$eventMeshMetaStoragePluginUsername = other.getEventMeshMetaStoragePluginUsername();
        if (this$eventMeshMetaStoragePluginUsername == null ? other$eventMeshMetaStoragePluginUsername != null : !this$eventMeshMetaStoragePluginUsername.equals(other$eventMeshMetaStoragePluginUsername)) {
            return false;
        }
        String this$eventMeshMetaStoragePluginPassword = this.getEventMeshMetaStoragePluginPassword();
        String other$eventMeshMetaStoragePluginPassword = other.getEventMeshMetaStoragePluginPassword();
        if (this$eventMeshMetaStoragePluginPassword == null ? other$eventMeshMetaStoragePluginPassword != null : !this$eventMeshMetaStoragePluginPassword.equals(other$eventMeshMetaStoragePluginPassword)) {
            return false;
        }
        String this$eventMeshTracePluginType = this.getEventMeshTracePluginType();
        String other$eventMeshTracePluginType = other.getEventMeshTracePluginType();
        if (this$eventMeshTracePluginType == null ? other$eventMeshTracePluginType != null : !this$eventMeshTracePluginType.equals(other$eventMeshTracePluginType)) {
            return false;
        }
        List<String> this$eventMeshMetricsPluginType = this.getEventMeshMetricsPluginType();
        List<String> other$eventMeshMetricsPluginType = other.getEventMeshMetricsPluginType();
        if (this$eventMeshMetricsPluginType == null ? other$eventMeshMetricsPluginType != null : !((Object)this$eventMeshMetricsPluginType).equals(other$eventMeshMetricsPluginType)) {
            return false;
        }
        String this$eventMeshSecurityPluginType = this.getEventMeshSecurityPluginType();
        String other$eventMeshSecurityPluginType = other.getEventMeshSecurityPluginType();
        if (this$eventMeshSecurityPluginType == null ? other$eventMeshSecurityPluginType != null : !this$eventMeshSecurityPluginType.equals(other$eventMeshSecurityPluginType)) {
            return false;
        }
        String this$eventMeshConnectorPluginType = this.getEventMeshConnectorPluginType();
        String other$eventMeshConnectorPluginType = other.getEventMeshConnectorPluginType();
        if (this$eventMeshConnectorPluginType == null ? other$eventMeshConnectorPluginType != null : !this$eventMeshConnectorPluginType.equals(other$eventMeshConnectorPluginType)) {
            return false;
        }
        String this$eventMeshStoragePluginType = this.getEventMeshStoragePluginType();
        String other$eventMeshStoragePluginType = other.getEventMeshStoragePluginType();
        if (this$eventMeshStoragePluginType == null ? other$eventMeshStoragePluginType != null : !this$eventMeshStoragePluginType.equals(other$eventMeshStoragePluginType)) {
            return false;
        }
        String this$eventMeshSecurityPublickey = this.getEventMeshSecurityPublickey();
        String other$eventMeshSecurityPublickey = other.getEventMeshSecurityPublickey();
        if (this$eventMeshSecurityPublickey == null ? other$eventMeshSecurityPublickey != null : !this$eventMeshSecurityPublickey.equals(other$eventMeshSecurityPublickey)) {
            return false;
        }
        List<String> this$eventMeshProvideServerProtocols = this.getEventMeshProvideServerProtocols();
        List<String> other$eventMeshProvideServerProtocols = other.getEventMeshProvideServerProtocols();
        if (this$eventMeshProvideServerProtocols == null ? other$eventMeshProvideServerProtocols != null : !((Object)this$eventMeshProvideServerProtocols).equals(other$eventMeshProvideServerProtocols)) {
            return false;
        }
        String this$eventMeshWebhookOrigin = this.getEventMeshWebhookOrigin();
        String other$eventMeshWebhookOrigin = other.getEventMeshWebhookOrigin();
        if (this$eventMeshWebhookOrigin == null ? other$eventMeshWebhookOrigin != null : !this$eventMeshWebhookOrigin.equals(other$eventMeshWebhookOrigin)) {
            return false;
        }
        String this$meshGroup = this.getMeshGroup();
        String other$meshGroup = other.getMeshGroup();
        if (this$meshGroup == null ? other$meshGroup != null : !this$meshGroup.equals(other$meshGroup)) {
            return false;
        }
        String this$eventMeshRetryPluginType = this.getEventMeshRetryPluginType();
        String other$eventMeshRetryPluginType = other.getEventMeshRetryPluginType();
        return !(this$eventMeshRetryPluginType == null ? other$eventMeshRetryPluginType != null : !this$eventMeshRetryPluginType.equals(other$eventMeshRetryPluginType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CommonConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEventMeshServerMetaStorageEnable() ? 79 : 97);
        result = result * 59 + (this.isEventMeshSecurityValidateTypeToken() ? 79 : 97);
        result = result * 59 + (this.isEventMeshServerTraceEnable() ? 79 : 97);
        result = result * 59 + (this.isEventMeshServerSecurityEnable() ? 79 : 97);
        Integer $eventMeshMetaStorageIntervalInMills = this.getEventMeshMetaStorageIntervalInMills();
        result = result * 59 + ($eventMeshMetaStorageIntervalInMills == null ? 43 : ((Object)$eventMeshMetaStorageIntervalInMills).hashCode());
        Integer $eventMeshFetchMetaStorageAddrInterval = this.getEventMeshFetchMetaStorageAddrInterval();
        result = result * 59 + ($eventMeshFetchMetaStorageAddrInterval == null ? 43 : ((Object)$eventMeshFetchMetaStorageAddrInterval).hashCode());
        String $sysID = this.getSysID();
        result = result * 59 + ($sysID == null ? 43 : $sysID.hashCode());
        String $eventMeshEnv = this.getEventMeshEnv();
        result = result * 59 + ($eventMeshEnv == null ? 43 : $eventMeshEnv.hashCode());
        String $eventMeshIDC = this.getEventMeshIDC();
        result = result * 59 + ($eventMeshIDC == null ? 43 : $eventMeshIDC.hashCode());
        String $eventMeshName = this.getEventMeshName();
        result = result * 59 + ($eventMeshName == null ? 43 : $eventMeshName.hashCode());
        String $eventMeshCluster = this.getEventMeshCluster();
        result = result * 59 + ($eventMeshCluster == null ? 43 : $eventMeshCluster.hashCode());
        String $eventMeshServerIp = this.getEventMeshServerIp();
        result = result * 59 + ($eventMeshServerIp == null ? 43 : $eventMeshServerIp.hashCode());
        String $metaStorageAddr = this.getMetaStorageAddr();
        result = result * 59 + ($metaStorageAddr == null ? 43 : $metaStorageAddr.hashCode());
        String $eventMeshMetaStoragePluginType = this.getEventMeshMetaStoragePluginType();
        result = result * 59 + ($eventMeshMetaStoragePluginType == null ? 43 : $eventMeshMetaStoragePluginType.hashCode());
        String $eventMeshMetaStoragePluginUsername = this.getEventMeshMetaStoragePluginUsername();
        result = result * 59 + ($eventMeshMetaStoragePluginUsername == null ? 43 : $eventMeshMetaStoragePluginUsername.hashCode());
        String $eventMeshMetaStoragePluginPassword = this.getEventMeshMetaStoragePluginPassword();
        result = result * 59 + ($eventMeshMetaStoragePluginPassword == null ? 43 : $eventMeshMetaStoragePluginPassword.hashCode());
        String $eventMeshTracePluginType = this.getEventMeshTracePluginType();
        result = result * 59 + ($eventMeshTracePluginType == null ? 43 : $eventMeshTracePluginType.hashCode());
        List<String> $eventMeshMetricsPluginType = this.getEventMeshMetricsPluginType();
        result = result * 59 + ($eventMeshMetricsPluginType == null ? 43 : ((Object)$eventMeshMetricsPluginType).hashCode());
        String $eventMeshSecurityPluginType = this.getEventMeshSecurityPluginType();
        result = result * 59 + ($eventMeshSecurityPluginType == null ? 43 : $eventMeshSecurityPluginType.hashCode());
        String $eventMeshConnectorPluginType = this.getEventMeshConnectorPluginType();
        result = result * 59 + ($eventMeshConnectorPluginType == null ? 43 : $eventMeshConnectorPluginType.hashCode());
        String $eventMeshStoragePluginType = this.getEventMeshStoragePluginType();
        result = result * 59 + ($eventMeshStoragePluginType == null ? 43 : $eventMeshStoragePluginType.hashCode());
        String $eventMeshSecurityPublickey = this.getEventMeshSecurityPublickey();
        result = result * 59 + ($eventMeshSecurityPublickey == null ? 43 : $eventMeshSecurityPublickey.hashCode());
        List<String> $eventMeshProvideServerProtocols = this.getEventMeshProvideServerProtocols();
        result = result * 59 + ($eventMeshProvideServerProtocols == null ? 43 : ((Object)$eventMeshProvideServerProtocols).hashCode());
        String $eventMeshWebhookOrigin = this.getEventMeshWebhookOrigin();
        result = result * 59 + ($eventMeshWebhookOrigin == null ? 43 : $eventMeshWebhookOrigin.hashCode());
        String $meshGroup = this.getMeshGroup();
        result = result * 59 + ($meshGroup == null ? 43 : $meshGroup.hashCode());
        String $eventMeshRetryPluginType = this.getEventMeshRetryPluginType();
        result = result * 59 + ($eventMeshRetryPluginType == null ? 43 : $eventMeshRetryPluginType.hashCode());
        return result;
    }

    public String toString() {
        return "CommonConfiguration(sysID=" + this.getSysID() + ", eventMeshEnv=" + this.getEventMeshEnv() + ", eventMeshIDC=" + this.getEventMeshIDC() + ", eventMeshName=" + this.getEventMeshName() + ", eventMeshCluster=" + this.getEventMeshCluster() + ", eventMeshServerIp=" + this.getEventMeshServerIp() + ", metaStorageAddr=" + this.getMetaStorageAddr() + ", eventMeshMetaStoragePluginType=" + this.getEventMeshMetaStoragePluginType() + ", eventMeshMetaStoragePluginUsername=" + this.getEventMeshMetaStoragePluginUsername() + ", eventMeshMetaStoragePluginPassword=" + this.getEventMeshMetaStoragePluginPassword() + ", eventMeshMetaStorageIntervalInMills=" + this.getEventMeshMetaStorageIntervalInMills() + ", eventMeshFetchMetaStorageAddrInterval=" + this.getEventMeshFetchMetaStorageAddrInterval() + ", eventMeshServerMetaStorageEnable=" + this.isEventMeshServerMetaStorageEnable() + ", eventMeshTracePluginType=" + this.getEventMeshTracePluginType() + ", eventMeshMetricsPluginType=" + this.getEventMeshMetricsPluginType() + ", eventMeshSecurityPluginType=" + this.getEventMeshSecurityPluginType() + ", eventMeshConnectorPluginType=" + this.getEventMeshConnectorPluginType() + ", eventMeshStoragePluginType=" + this.getEventMeshStoragePluginType() + ", eventMeshSecurityValidateTypeToken=" + this.isEventMeshSecurityValidateTypeToken() + ", eventMeshServerTraceEnable=" + this.isEventMeshServerTraceEnable() + ", eventMeshServerSecurityEnable=" + this.isEventMeshServerSecurityEnable() + ", eventMeshSecurityPublickey=" + this.getEventMeshSecurityPublickey() + ", eventMeshProvideServerProtocols=" + this.getEventMeshProvideServerProtocols() + ", eventMeshWebhookOrigin=" + this.getEventMeshWebhookOrigin() + ", meshGroup=" + this.getMeshGroup() + ", eventMeshRetryPluginType=" + this.getEventMeshRetryPluginType() + ")";
    }
}

