/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.cache;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.redisson.api.RMap;
import org.redisson.api.RMapCache;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.spring.cache.CacheConfig;
import org.redisson.spring.cache.RedissonCache;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.transaction.TransactionAwareCacheDecorator;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class RedissonSpringCacheManager
implements CacheManager,
ResourceLoaderAware,
InitializingBean {
    ResourceLoader resourceLoader;
    private boolean dynamic = true;
    private boolean allowNullValues = true;
    private boolean transactionAware = false;
    Codec codec;
    RedissonClient redisson;
    Map<String, CacheConfig> configMap = new ConcurrentHashMap<String, CacheConfig>();
    ConcurrentMap<String, Cache> instanceMap = new ConcurrentHashMap<String, Cache>();
    String configLocation;

    public RedissonSpringCacheManager(RedissonClient redisson) {
        this(redisson, (String)null, null);
    }

    public RedissonSpringCacheManager(RedissonClient redisson, Map<String, ? extends CacheConfig> config) {
        this(redisson, config, null);
    }

    public RedissonSpringCacheManager(RedissonClient redisson, Map<String, ? extends CacheConfig> config, Codec codec) {
        this.redisson = redisson;
        this.configMap = config;
        this.codec = codec;
    }

    public RedissonSpringCacheManager(RedissonClient redisson, String configLocation) {
        this(redisson, configLocation, null);
    }

    public RedissonSpringCacheManager(RedissonClient redisson, String configLocation, Codec codec) {
        this.redisson = redisson;
        this.configLocation = configLocation;
        this.codec = codec;
    }

    public void setAllowNullValues(boolean allowNullValues) {
        this.allowNullValues = allowNullValues;
    }

    public void setTransactionAware(boolean transactionAware) {
        this.transactionAware = transactionAware;
    }

    public void setCacheNames(Collection<String> names) {
        if (names != null) {
            for (String name : names) {
                this.getCache(name);
            }
            this.dynamic = false;
        } else {
            this.dynamic = true;
        }
    }

    public void setConfigLocation(String configLocation) {
        this.configLocation = configLocation;
    }

    public void setConfig(Map<String, ? extends CacheConfig> config) {
        this.configMap = config;
    }

    public void setRedisson(RedissonClient redisson) {
        this.redisson = redisson;
    }

    public void setCodec(Codec codec) {
        this.codec = codec;
    }

    protected CacheConfig createDefaultConfig() {
        return new CacheConfig();
    }

    public Cache getCache(String name) {
        Cache cache = (Cache)this.instanceMap.get(name);
        if (cache != null) {
            return cache;
        }
        if (!this.dynamic) {
            return cache;
        }
        CacheConfig config = this.configMap.get(name);
        if (config == null) {
            config = this.createDefaultConfig();
            this.configMap.put(name, config);
        }
        if (config.getMaxIdleTime() == 0L && config.getTTL() == 0L && config.getMaxSize() == 0) {
            return this.createMap(name, config);
        }
        return this.createMapCache(name, config);
    }

    private Cache createMap(String name, CacheConfig config) {
        Cache oldCache;
        RMap<Object, Object> map = this.getMap(name, config);
        RedissonCache cache = new RedissonCache(map, this.allowNullValues);
        if (this.transactionAware) {
            cache = new TransactionAwareCacheDecorator((Cache)cache);
        }
        if ((oldCache = this.instanceMap.putIfAbsent(name, cache)) != null) {
            cache = oldCache;
        }
        return cache;
    }

    protected RMap<Object, Object> getMap(String name, CacheConfig config) {
        if (this.codec != null) {
            return this.redisson.getMap(name, this.codec);
        }
        return this.redisson.getMap(name);
    }

    private Cache createMapCache(String name, CacheConfig config) {
        Cache oldCache;
        RMapCache<Object, Object> map = this.getMapCache(name, config);
        RedissonCache cache = new RedissonCache(map, config, this.allowNullValues);
        if (this.transactionAware) {
            cache = new TransactionAwareCacheDecorator((Cache)cache);
        }
        if ((oldCache = this.instanceMap.putIfAbsent(name, cache)) != null) {
            cache = oldCache;
        } else {
            map.setMaxSize(config.getMaxSize());
        }
        return cache;
    }

    protected RMapCache<Object, Object> getMapCache(String name, CacheConfig config) {
        if (this.codec != null) {
            return this.redisson.getMapCache(name, this.codec);
        }
        return this.redisson.getMapCache(name);
    }

    public Collection<String> getCacheNames() {
        return Collections.unmodifiableSet(this.configMap.keySet());
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.configLocation == null) {
            return;
        }
        Resource resource = this.resourceLoader.getResource(this.configLocation);
        try {
            this.configMap = CacheConfig.fromJSON(resource.getInputStream());
        }
        catch (IOException e) {
            try {
                this.configMap = CacheConfig.fromYAML(resource.getInputStream());
            }
            catch (IOException e1) {
                throw new BeanDefinitionStoreException("Could not parse cache configuration at [" + this.configLocation + "]", (Throwable)e1);
            }
        }
    }
}

