/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.metrics.api.model;

import java.util.Collections;
import java.util.LinkedList;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.eventmesh.metrics.api.model.Metric;
import org.apache.eventmesh.metrics.api.model.RetrySummaryMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpSummaryMetrics
implements Metric {
    private static final Logger log = LoggerFactory.getLogger(HttpSummaryMetrics.class);
    private static final int STATIC_PERIOD = 30000;
    private float wholeCost = 0.0f;
    private final AtomicLong wholeRequestNum = new AtomicLong(0L);
    private final AtomicLong httpDiscard = new AtomicLong(0L);
    private final AtomicLong maxCost = new AtomicLong(0L);
    private final AtomicLong httpRequestPerSecond = new AtomicLong(0L);
    private final LinkedList<Integer> httpRequestTPSSnapshots = new LinkedList();
    private float httpDecodeTimeCost = 0.0f;
    private final AtomicLong httpDecodeNum = new AtomicLong(0L);
    private final AtomicLong sendBatchMsgNumPerSecond = new AtomicLong(0L);
    private final AtomicLong sendBatchMsgNumSum = new AtomicLong(0L);
    private final AtomicLong sendBatchMsgFailNumSum = new AtomicLong(0L);
    private final AtomicLong sendBatchMsgDiscardNumSum = new AtomicLong(0L);
    private final LinkedList<Integer> sendBatchMsgTPSSnapshots = new LinkedList();
    private final AtomicLong sendMsgNumSum = new AtomicLong(0L);
    private final AtomicLong sendMsgFailNumSum = new AtomicLong(0L);
    private final AtomicLong replyMsgNumSum = new AtomicLong(0L);
    private final AtomicLong replyMsgFailNumSum = new AtomicLong(0L);
    private final AtomicLong sendMsgNumPerSecond = new AtomicLong(0L);
    private final LinkedList<Integer> sendMsgTPSSnapshots = new LinkedList();
    private float wholePushCost = 0.0f;
    private final AtomicLong wholePushRequestNum = new AtomicLong(0L);
    private final AtomicLong maxHttpPushLatency = new AtomicLong(0L);
    private final AtomicLong pushMsgNumPerSecond = new AtomicLong(0L);
    private final LinkedList<Integer> pushMsgTPSSnapshots = new LinkedList();
    private final AtomicLong httpPushMsgNumSum = new AtomicLong(0L);
    private final AtomicLong httpPushFailNumSum = new AtomicLong(0L);
    private float batchSend2MQWholeCost = 0.0f;
    private final AtomicLong batchSend2MQNum = new AtomicLong(0L);
    private float send2MQWholeCost = 0.0f;
    private final AtomicLong send2MQNum = new AtomicLong(0L);
    private float reply2MQWholeCost = 0.0f;
    private final AtomicLong reply2MQNum = new AtomicLong(0L);
    private final ThreadPoolExecutor batchMsgExecutor;
    private final ThreadPoolExecutor sendMsgExecutor;
    private final ThreadPoolExecutor pushMsgExecutor;
    private final RetrySummaryMetrics retrySummaryMetrics;
    private Lock lock = new ReentrantLock();

    public HttpSummaryMetrics(ThreadPoolExecutor batchMsgExecutor, ThreadPoolExecutor sendMsgExecutor, ThreadPoolExecutor pushMsgExecutor, RetrySummaryMetrics retrySummaryMetrics) {
        this.batchMsgExecutor = batchMsgExecutor;
        this.sendMsgExecutor = sendMsgExecutor;
        this.pushMsgExecutor = pushMsgExecutor;
        this.retrySummaryMetrics = retrySummaryMetrics;
    }

    public float avgHTTPCost() {
        return this.wholeRequestNum.longValue() == 0L ? 0.0f : this.wholeCost / (float)this.wholeRequestNum.longValue();
    }

    public long maxHTTPCost() {
        return this.maxCost.longValue();
    }

    public long getHttpDiscard() {
        return this.httpDiscard.longValue();
    }

    public void recordHTTPRequest() {
        this.httpRequestPerSecond.incrementAndGet();
    }

    public void recordHTTPDiscard() {
        this.httpDiscard.incrementAndGet();
    }

    public void snapshotHTTPTPS() {
        try {
            this.lock.lock();
            Integer tps = this.httpRequestPerSecond.intValue();
            this.httpRequestTPSSnapshots.add(tps);
            this.httpRequestPerSecond.set(0L);
            if (this.httpRequestTPSSnapshots.size() > 30) {
                this.httpRequestTPSSnapshots.removeFirst();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public float maxHTTPTPS() {
        try {
            float tps;
            this.lock.lock();
            float f = tps = (float)Collections.max(this.httpRequestTPSSnapshots).intValue();
            return f;
        }
        finally {
            this.lock.unlock();
        }
    }

    public float avgHTTPTPS() {
        try {
            float tps;
            this.lock.lock();
            float f = tps = this.avg(this.httpRequestTPSSnapshots);
            return f;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void recordHTTPReqResTimeCost(long cost) {
        this.wholeRequestNum.incrementAndGet();
        this.wholeCost += (float)cost;
        if (cost > this.maxCost.longValue()) {
            this.maxCost.set(cost);
        }
    }

    public void httpStatInfoClear() {
        this.wholeRequestNum.set(0L);
        this.wholeCost = 0.0f;
        this.maxCost.set(0L);
        this.httpDecodeNum.set(0L);
        this.httpDecodeTimeCost = 0.0f;
    }

    public void recordDecodeTimeCost(long cost) {
        this.httpDecodeNum.incrementAndGet();
        this.httpDecodeTimeCost += (float)cost;
    }

    public float avgHTTPBodyDecodeCost() {
        return this.httpDecodeNum.longValue() == 0L ? 0.0f : this.httpDecodeTimeCost / (float)this.httpDecodeNum.longValue();
    }

    public void recordSendBatchMsgDiscard(long delta) {
        this.sendBatchMsgDiscardNumSum.addAndGet(delta);
    }

    public void snapshotSendBatchMsgTPS() {
        Integer tps = this.sendBatchMsgNumPerSecond.intValue();
        this.sendBatchMsgTPSSnapshots.add(tps);
        this.sendBatchMsgNumPerSecond.set(0L);
        if (this.sendBatchMsgTPSSnapshots.size() > 30) {
            this.sendBatchMsgTPSSnapshots.removeFirst();
        }
    }

    public float maxSendBatchMsgTPS() {
        return Collections.max(this.sendBatchMsgTPSSnapshots).intValue();
    }

    public float avgSendBatchMsgTPS() {
        return this.avg(this.sendBatchMsgTPSSnapshots);
    }

    public void recordSendBatchMsg(long delta) {
        this.sendBatchMsgNumPerSecond.addAndGet(delta);
        this.sendBatchMsgNumSum.addAndGet(delta);
    }

    public void recordSendBatchMsgFailed(long delta) {
        this.sendBatchMsgFailNumSum.getAndAdd(delta);
    }

    public long getSendBatchMsgNumSum() {
        return this.sendBatchMsgNumSum.longValue();
    }

    public long getSendBatchMsgFailNumSum() {
        return this.sendBatchMsgFailNumSum.longValue();
    }

    public float getSendBatchMsgFailRate() {
        return this.sendBatchMsgNumSum.longValue() == 0L ? 0.0f : this.sendBatchMsgFailNumSum.floatValue() / (float)this.sendBatchMsgNumSum.longValue();
    }

    public void cleanSendBatchStat() {
        this.sendBatchMsgNumSum.set(0L);
        this.sendBatchMsgFailNumSum.set(0L);
    }

    public long getSendBatchMsgDiscardNumSum() {
        return this.sendBatchMsgDiscardNumSum.longValue();
    }

    public void snapshotSendMsgTPS() {
        Integer tps = this.sendMsgNumPerSecond.intValue();
        this.sendMsgTPSSnapshots.add(tps);
        this.sendMsgNumPerSecond.set(0L);
        if (this.sendMsgTPSSnapshots.size() > 30) {
            this.sendMsgTPSSnapshots.removeFirst();
        }
    }

    public float maxSendMsgTPS() {
        return Collections.max(this.sendMsgTPSSnapshots).intValue();
    }

    public float avgSendMsgTPS() {
        return this.avg(this.sendMsgTPSSnapshots);
    }

    public void recordSendMsg() {
        this.sendMsgNumPerSecond.incrementAndGet();
        this.sendMsgNumSum.incrementAndGet();
    }

    public void recordReplyMsg() {
        this.replyMsgNumSum.incrementAndGet();
    }

    public void recordReplyMsgFailed() {
        this.replyMsgFailNumSum.incrementAndGet();
    }

    public long getReplyMsgNumSum() {
        return this.replyMsgNumSum.longValue();
    }

    public long getReplyMsgFailNumSum() {
        return this.replyMsgFailNumSum.longValue();
    }

    public long getSendMsgNumSum() {
        return this.sendMsgNumSum.longValue();
    }

    public long getSendMsgFailNumSum() {
        return this.sendMsgFailNumSum.longValue();
    }

    public float getSendMsgFailRate() {
        return this.sendMsgNumSum.longValue() == 0L ? 0.0f : this.sendMsgFailNumSum.floatValue() / (float)this.sendMsgNumSum.longValue();
    }

    public void recordSendMsgFailed() {
        this.sendMsgFailNumSum.incrementAndGet();
    }

    public void cleanSendMsgStat() {
        this.sendMsgNumSum.set(0L);
        this.replyMsgNumSum.set(0L);
        this.sendMsgFailNumSum.set(0L);
        this.replyMsgFailNumSum.set(0L);
    }

    public void snapshotPushMsgTPS() {
        Integer tps = this.pushMsgNumPerSecond.intValue();
        this.pushMsgTPSSnapshots.add(tps);
        this.pushMsgNumPerSecond.set(0L);
        if (this.pushMsgTPSSnapshots.size() > 30) {
            this.pushMsgTPSSnapshots.removeFirst();
        }
    }

    public void recordHTTPPushTimeCost(long cost) {
        this.wholePushRequestNum.incrementAndGet();
        this.wholePushCost += (float)cost;
        if (cost > this.maxHttpPushLatency.longValue()) {
            this.maxHttpPushLatency.set(cost);
        }
    }

    public float avgHTTPPushLatency() {
        return this.wholePushRequestNum.longValue() == 0L ? 0.0f : this.wholePushCost / (float)this.wholePushRequestNum.longValue();
    }

    public float maxHTTPPushLatency() {
        return this.maxHttpPushLatency.floatValue();
    }

    public float maxPushMsgTPS() {
        return Collections.max(this.pushMsgTPSSnapshots).intValue();
    }

    public float avgPushMsgTPS() {
        return this.avg(this.pushMsgTPSSnapshots);
    }

    public void recordPushMsg() {
        this.pushMsgNumPerSecond.incrementAndGet();
        this.httpPushMsgNumSum.incrementAndGet();
    }

    public long getHttpPushMsgNumSum() {
        return this.httpPushMsgNumSum.longValue();
    }

    public long getHttpPushFailNumSum() {
        return this.httpPushFailNumSum.longValue();
    }

    public float getHttpPushMsgFailRate() {
        return this.httpPushMsgNumSum.longValue() == 0L ? 0.0f : this.httpPushFailNumSum.floatValue() / (float)this.httpPushMsgNumSum.longValue();
    }

    public void recordHttpPushMsgFailed() {
        this.sendMsgFailNumSum.incrementAndGet();
    }

    public void cleanHttpPushMsgStat() {
        this.httpPushFailNumSum.set(0L);
        this.httpPushMsgNumSum.set(0L);
        this.wholeRequestNum.set(0L);
        this.wholeCost = 0.0f;
        this.maxCost.set(0L);
    }

    public void recordBatchSendMsgCost(long cost) {
        this.batchSend2MQNum.incrementAndGet();
        this.batchSend2MQWholeCost += (float)cost;
    }

    public float avgBatchSendMsgCost() {
        return this.batchSend2MQNum.intValue() == 0 ? 0.0f : this.batchSend2MQWholeCost / (float)this.batchSend2MQNum.intValue();
    }

    public void recordSendMsgCost(long cost) {
        this.send2MQNum.incrementAndGet();
        this.send2MQWholeCost += (float)cost;
    }

    public float avgSendMsgCost() {
        return this.send2MQNum.intValue() == 0 ? 0.0f : this.send2MQWholeCost / (float)this.send2MQNum.intValue();
    }

    public void recordReplyMsgCost(long cost) {
        this.reply2MQNum.incrementAndGet();
        this.reply2MQWholeCost += (float)cost;
    }

    public float avgReplyMsgCost() {
        return this.reply2MQNum.intValue() == 0 ? 0.0f : this.reply2MQWholeCost / (float)this.reply2MQNum.intValue();
    }

    public void send2MQStatInfoClear() {
        this.batchSend2MQWholeCost = 0.0f;
        this.batchSend2MQNum.set(0L);
        this.send2MQWholeCost = 0.0f;
        this.send2MQNum.set(0L);
        this.reply2MQWholeCost = 0.0f;
        this.reply2MQNum.set(0L);
    }

    public int getBatchMsgQueueSize() {
        return this.batchMsgExecutor.getQueue().size();
    }

    public int getSendMsgQueueSize() {
        return this.sendMsgExecutor.getQueue().size();
    }

    public int getPushMsgQueueSize() {
        return this.pushMsgExecutor.getQueue().size();
    }

    public long getHttpRetryQueueSize() {
        return this.retrySummaryMetrics.getPendingRetryTimeouts();
    }

    private float avg(LinkedList<Integer> linkedList) {
        if (linkedList.isEmpty()) {
            return 0.0f;
        }
        int sum = (Integer)linkedList.stream().reduce(Integer::sum).get();
        return (float)sum / (float)linkedList.size();
    }
}

