/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.protocol.cloudevents;

import com.google.common.base.Preconditions;
import io.cloudevents.CloudEvent;
import io.cloudevents.core.format.EventFormat;
import io.cloudevents.core.provider.EventFormatProvider;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.eventmesh.common.Constants;
import org.apache.eventmesh.common.protocol.ProtocolTransportObject;
import org.apache.eventmesh.common.protocol.grpc.cloudevents.CloudEventBatch;
import org.apache.eventmesh.common.protocol.grpc.common.BatchEventMeshCloudEventWrapper;
import org.apache.eventmesh.common.protocol.grpc.common.EventMeshCloudEventWrapper;
import org.apache.eventmesh.common.protocol.http.HttpCommand;
import org.apache.eventmesh.common.protocol.http.body.Body;
import org.apache.eventmesh.common.protocol.http.common.RequestCode;
import org.apache.eventmesh.common.protocol.tcp.Header;
import org.apache.eventmesh.common.protocol.tcp.Package;
import org.apache.eventmesh.protocol.api.ProtocolAdaptor;
import org.apache.eventmesh.protocol.api.exception.ProtocolHandleException;
import org.apache.eventmesh.protocol.cloudevents.resolver.grpc.GrpcEventMeshCloudEventProtocolResolver;
import org.apache.eventmesh.protocol.cloudevents.resolver.http.SendMessageBatchProtocolResolver;
import org.apache.eventmesh.protocol.cloudevents.resolver.http.SendMessageBatchV2ProtocolResolver;
import org.apache.eventmesh.protocol.cloudevents.resolver.http.SendMessageRequestProtocolResolver;
import org.apache.eventmesh.protocol.cloudevents.resolver.tcp.TcpMessageProtocolResolver;

public class CloudEventsProtocolAdaptor<T extends ProtocolTransportObject>
implements ProtocolAdaptor<ProtocolTransportObject> {
    public CloudEvent toCloudEvent(ProtocolTransportObject cloudEvent) throws ProtocolHandleException {
        if (cloudEvent instanceof Package) {
            Package tcpPackage = (Package)cloudEvent;
            Header header = tcpPackage.getHeader();
            String cloudEventJson = tcpPackage.getBody().toString();
            return this.deserializeTcpProtocol(header, cloudEventJson);
        }
        if (cloudEvent instanceof HttpCommand) {
            org.apache.eventmesh.common.protocol.http.header.Header header = ((HttpCommand)cloudEvent).getHeader();
            Body body = ((HttpCommand)cloudEvent).getBody();
            String requestCode = ((HttpCommand)cloudEvent).getRequestCode();
            return this.deserializeHttpProtocol(requestCode, header, body);
        }
        if (cloudEvent instanceof EventMeshCloudEventWrapper) {
            EventMeshCloudEventWrapper ce = (EventMeshCloudEventWrapper)cloudEvent;
            return GrpcEventMeshCloudEventProtocolResolver.buildEvent(ce.getMessage());
        }
        throw new ProtocolHandleException(String.format("protocol class: %s", cloudEvent.getClass()));
    }

    private CloudEvent deserializeTcpProtocol(Header header, String cloudEventJson) throws ProtocolHandleException {
        return TcpMessageProtocolResolver.buildEvent(header, cloudEventJson);
    }

    private CloudEvent deserializeHttpProtocol(String requestCode, org.apache.eventmesh.common.protocol.http.header.Header header, Body body) throws ProtocolHandleException {
        switch (RequestCode.get((Integer)Integer.parseInt(requestCode))) {
            case MSG_BATCH_SEND: {
                return SendMessageBatchProtocolResolver.buildEvent(header, body);
            }
            case MSG_BATCH_SEND_V2: {
                return SendMessageBatchV2ProtocolResolver.buildEvent(header, body);
            }
            case MSG_SEND_SYNC: 
            case MSG_SEND_ASYNC: {
                return SendMessageRequestProtocolResolver.buildEvent(header, body);
            }
        }
        throw new ProtocolHandleException(String.format("unsupported requestCode: %s", requestCode));
    }

    public List<CloudEvent> toBatchCloudEvent(ProtocolTransportObject protocol) throws ProtocolHandleException {
        if (protocol instanceof BatchEventMeshCloudEventWrapper) {
            CloudEventBatch cloudEventBatch = ((BatchEventMeshCloudEventWrapper)protocol).getMessage();
            return GrpcEventMeshCloudEventProtocolResolver.buildBatchEvents(cloudEventBatch);
        }
        throw new ProtocolHandleException(String.format("protocol class: %s", protocol.getClass()));
    }

    public ProtocolTransportObject fromCloudEvent(final CloudEvent cloudEvent) throws ProtocolHandleException {
        String protocolDesc;
        Preconditions.checkNotNull((Object)cloudEvent, (Object)"cloudEvent cannot be null");
        switch (protocolDesc = Objects.requireNonNull(cloudEvent.getExtension("protocoldesc")).toString()) {
            case "http": {
                HttpCommand httpCommand = new HttpCommand();
                Body body = new Body(){
                    final Map<String, Object> map = new HashMap<String, Object>();

                    public Map<String, Object> toMap() {
                        byte[] eventByte = Objects.requireNonNull(EventFormatProvider.getInstance().resolveFormat("application/cloudevents+json")).serialize(cloudEvent);
                        this.map.put("content", new String(eventByte, Constants.DEFAULT_CHARSET));
                        return this.map;
                    }
                };
                body.toMap();
                httpCommand.setBody(body);
                return httpCommand;
            }
            case "tcp": {
                Package pkg = new Package();
                String dataContentType = cloudEvent.getDataContentType();
                Preconditions.checkNotNull((Object)dataContentType, (Object)"DateContentType cannot be null");
                EventFormat eventFormat = EventFormatProvider.getInstance().resolveFormat(dataContentType);
                Preconditions.checkNotNull((Object)eventFormat, (Object)String.format("DateContentType:%s is not supported", dataContentType));
                pkg.setBody((Object)eventFormat.serialize(cloudEvent));
                return pkg;
            }
            case "grpc-cloud-event": {
                return GrpcEventMeshCloudEventProtocolResolver.buildEventMeshCloudEvent(cloudEvent);
            }
        }
        throw new ProtocolHandleException(String.format("Unsupported protocolDesc: %s", protocolDesc));
    }

    public String getProtocolType() {
        return "cloudevents";
    }
}

