/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.protocol.cloudevents.resolver.grpc;

import com.google.protobuf.InvalidProtocolBufferException;
import io.cloudevents.CloudEvent;
import io.cloudevents.core.format.EventFormat;
import io.cloudevents.core.provider.EventFormatProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.eventmesh.common.protocol.grpc.cloudevents.CloudEventBatch;
import org.apache.eventmesh.common.protocol.grpc.common.EventMeshCloudEventWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcEventMeshCloudEventProtocolResolver {
    private static final Logger log = LoggerFactory.getLogger(GrpcEventMeshCloudEventProtocolResolver.class);
    private static final EventFormat eventFormat = EventFormatProvider.getInstance().resolveFormat("application/cloudevents+protobuf");

    public static CloudEvent buildEvent(org.apache.eventmesh.common.protocol.grpc.cloudevents.CloudEvent cloudEvent) {
        return Objects.requireNonNull(eventFormat).deserialize(cloudEvent.toByteArray());
    }

    public static List<CloudEvent> buildBatchEvents(CloudEventBatch cloudEventBatch) {
        if (cloudEventBatch == null || cloudEventBatch.getEventsCount() < 1) {
            return new ArrayList<CloudEvent>(0);
        }
        return cloudEventBatch.getEventsList().stream().map(cloudEvent -> Objects.requireNonNull(eventFormat).deserialize(cloudEvent.toByteArray())).collect(Collectors.toList());
    }

    public static EventMeshCloudEventWrapper buildEventMeshCloudEvent(CloudEvent cloudEvent) {
        if (null == cloudEvent) {
            return new EventMeshCloudEventWrapper(null);
        }
        try {
            return new EventMeshCloudEventWrapper(org.apache.eventmesh.common.protocol.grpc.cloudevents.CloudEvent.parseFrom((byte[])Objects.requireNonNull(eventFormat).serialize(cloudEvent)));
        }
        catch (InvalidProtocolBufferException e) {
            log.error("Build Event Mesh CloudEvent from io.cloudevents.CloudEvent error", (Throwable)e);
            return null;
        }
    }
}

