/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.jdbc.source;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.eventmesh.connector.jdbc.source.EventMeshJdbcTask;
import org.apache.eventmesh.connector.jdbc.source.JdbcTaskManager;
import org.apache.eventmesh.connector.jdbc.source.TaskManagerListener;
import org.apache.eventmesh.connector.jdbc.source.config.JdbcSourceConfig;
import org.apache.eventmesh.connector.jdbc.table.catalog.TableId;

public abstract class AbstractJdbcTaskManager<Task extends EventMeshJdbcTask>
implements JdbcTaskManager {
    protected Map<TableId, Task> tableIdJdbcTaskMap = new ConcurrentHashMap<TableId, Task>();
    protected Set<TableId> includeDatabaseTable;
    protected JdbcSourceConfig jdbcSourceConfig;
    protected List<Task> taskList = new ArrayList<Task>(128);
    protected List<TaskManagerListener> listeners = new ArrayList<TaskManagerListener>(16);

    @Override
    public void start() {
        this.taskList.forEach(EventMeshJdbcTask::start);
    }

    @Override
    public void shutdown() {
        this.taskList.forEach(EventMeshJdbcTask::shutdown);
    }

    @Override
    public void close() throws Exception {
        this.shutdown();
    }

    @Override
    public void registerListener(TaskManagerListener listener) {
        if (!Objects.isNull(listener)) {
            this.listeners.add(listener);
        }
    }

    public abstract Task select(TableId var1);
}

