/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.jdbc.source.dialect;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.eventmesh.connector.jdbc.DatabaseDialect;
import org.apache.eventmesh.connector.jdbc.connection.JdbcConnection;
import org.apache.eventmesh.connector.jdbc.exception.JdbcConnectionException;
import org.apache.eventmesh.connector.jdbc.source.config.SourceConnectorConfig;

public abstract class AbstractGeneralDatabaseDialect<JC extends JdbcConnection>
implements DatabaseDialect<JC> {
    private static final int DEFAULT_BATCH_MAX_ROWS = 20;
    private SourceConnectorConfig config;
    private int batchMaxRows = 20;

    public AbstractGeneralDatabaseDialect(SourceConnectorConfig config) {
        this.config = config;
    }

    @Override
    public boolean isValid(Connection connection, int timeout) throws JdbcConnectionException, SQLException {
        return connection == null ? false : connection.isValid(timeout);
    }

    @Override
    public PreparedStatement createPreparedStatement(Connection connection, String sql) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        if (this.batchMaxRows > 0) {
            preparedStatement.setFetchSize(this.batchMaxRows);
        }
        return preparedStatement;
    }
}

