/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.jdbc.source.dialect.antlr4.mysql.listener;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.apache.eventmesh.connector.jdbc.antlr4.autogeneration.MySqlParser;
import org.apache.eventmesh.connector.jdbc.antlr4.autogeneration.MySqlParserBaseListener;
import org.apache.eventmesh.connector.jdbc.source.dialect.antlr4.mysql.MysqlAntlr4DdlParser;
import org.apache.eventmesh.connector.jdbc.source.dialect.antlr4.mysql.listener.DefaultValueParserListener;
import org.apache.eventmesh.connector.jdbc.source.dialect.mysql.MysqlDataTypeConvertor;
import org.apache.eventmesh.connector.jdbc.table.catalog.TableEditor;
import org.apache.eventmesh.connector.jdbc.table.catalog.mysql.MysqlColumnEditor;
import org.apache.eventmesh.connector.jdbc.table.type.EventMeshDataType;
import org.apache.eventmesh.connector.jdbc.utils.JdbcStringUtils;

public class ColumnDefinitionParserListener
extends MySqlParserBaseListener {
    private DefaultValueParserListener defaultValueParserListener;
    private final List<ParseTreeListener> listeners;
    private TableEditor tableEditor;
    private MysqlColumnEditor columnEditor;
    private final MysqlAntlr4DdlParser parser;
    private MysqlDataTypeConvertor dataTypeConvertor;
    private AtomicReference<Boolean> ignoreColumn = new AtomicReference<Boolean>(false);

    public ColumnDefinitionParserListener(List<ParseTreeListener> listeners, TableEditor tableEditor, MysqlColumnEditor columnEditor, MysqlAntlr4DdlParser parser) {
        this.listeners = listeners;
        this.tableEditor = tableEditor;
        this.columnEditor = columnEditor;
        this.parser = parser;
        this.dataTypeConvertor = new MysqlDataTypeConvertor();
    }

    @Override
    public void enterColumnDefinition(MySqlParser.ColumnDefinitionContext ctx) {
        this.parser.runIfAllNotNull(() -> {
            String dataTypeString = ctx.dataType().getText();
            EventMeshDataType<?> eventMeshType = this.dataTypeConvertor.toEventMeshType(dataTypeString);
            this.columnEditor.withEventMeshType(eventMeshType);
            this.columnEditor.withJdbcType(this.dataTypeConvertor.toJDBCType(dataTypeString));
            this.columnEditor.withType(dataTypeString);
        }, this.columnEditor);
        this.parser.runIfAllNotNull(() -> {
            this.defaultValueParserListener = new DefaultValueParserListener(this.columnEditor);
            this.listeners.add(this.defaultValueParserListener);
        }, this.tableEditor, this.columnEditor);
        super.enterColumnDefinition(ctx);
    }

    @Override
    public void enterNullNotnull(MySqlParser.NullNotnullContext ctx) {
        this.columnEditor.notNull(ctx.NOT() != null);
        super.enterNullNotnull(ctx);
    }

    @Override
    public void enterAutoIncrementColumnConstraint(MySqlParser.AutoIncrementColumnConstraintContext ctx) {
        this.columnEditor.autoIncremented(true);
        this.columnEditor.generated(true);
        super.enterAutoIncrementColumnConstraint(ctx);
    }

    @Override
    public void enterCommentColumnConstraint(MySqlParser.CommentColumnConstraintContext ctx) {
        if (ctx.COMMENT() != null && ctx.STRING_LITERAL() != null) {
            this.columnEditor.comment(JdbcStringUtils.withoutWrapper(ctx.STRING_LITERAL().getText()));
        }
        super.enterCommentColumnConstraint(ctx);
    }

    @Override
    public void enterPrimaryKeyColumnConstraint(MySqlParser.PrimaryKeyColumnConstraintContext ctx) {
        this.ignoreColumn.set(false);
        this.tableEditor.withPrimaryKeyNames(this.columnEditor.ofName());
        super.enterPrimaryKeyColumnConstraint(ctx);
    }

    @Override
    public void enterUniqueKeyColumnConstraint(MySqlParser.UniqueKeyColumnConstraintContext ctx) {
        this.ignoreColumn.set(false);
        super.enterUniqueKeyColumnConstraint(ctx);
    }

    @Override
    public void exitColumnDefinition(MySqlParser.ColumnDefinitionContext ctx) {
        if (!this.ignoreColumn.get().booleanValue()) {
            this.ignoreColumn.set(false);
        }
        this.parser.runIfAllNotNull(() -> this.listeners.remove(this.defaultValueParserListener), this.tableEditor);
        super.exitColumnDefinition(ctx);
    }

    @Override
    public void enterCollateColumnConstraint(MySqlParser.CollateColumnConstraintContext ctx) {
        if (ctx.COLLATE() != null) {
            this.columnEditor.collate(ctx.collationName().getText());
        }
        super.enterCollateColumnConstraint(ctx);
    }

    public DefaultValueParserListener getDefaultValueParserListener() {
        return this.defaultValueParserListener;
    }

    public List<ParseTreeListener> getListeners() {
        return this.listeners;
    }

    public TableEditor getTableEditor() {
        return this.tableEditor;
    }

    public MysqlColumnEditor getColumnEditor() {
        return this.columnEditor;
    }

    public MysqlAntlr4DdlParser getParser() {
        return this.parser;
    }

    public MysqlDataTypeConvertor getDataTypeConvertor() {
        return this.dataTypeConvertor;
    }

    public AtomicReference<Boolean> getIgnoreColumn() {
        return this.ignoreColumn;
    }

    public void setDefaultValueParserListener(DefaultValueParserListener defaultValueParserListener) {
        this.defaultValueParserListener = defaultValueParserListener;
    }

    public void setTableEditor(TableEditor tableEditor) {
        this.tableEditor = tableEditor;
    }

    public void setColumnEditor(MysqlColumnEditor columnEditor) {
        this.columnEditor = columnEditor;
    }

    public void setDataTypeConvertor(MysqlDataTypeConvertor dataTypeConvertor) {
        this.dataTypeConvertor = dataTypeConvertor;
    }

    public void setIgnoreColumn(AtomicReference<Boolean> ignoreColumn) {
        this.ignoreColumn = ignoreColumn;
    }
}

