/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.jdbc.source.dialect.antlr4.mysql.listener;

import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.eventmesh.connector.jdbc.antlr4.autogeneration.MySqlParser;
import org.apache.eventmesh.connector.jdbc.antlr4.autogeneration.MySqlParserBaseListener;
import org.apache.eventmesh.connector.jdbc.table.catalog.mysql.MysqlColumnEditor;

public class DefaultValueParserListener
extends MySqlParserBaseListener {
    private final MysqlColumnEditor columnEditor;

    public DefaultValueParserListener(MysqlColumnEditor columnEditor) {
        this.columnEditor = columnEditor;
    }

    @Override
    public void enterDefaultValue(MySqlParser.DefaultValueContext ctx) {
        String sign = "";
        if (ctx.NULL_LITERAL() != null) {
            return;
        }
        if (ctx.CAST() != null && ctx.expression() != null) {
            this.columnEditor.defaultValueExpression(ctx.getText());
            return;
        }
        if (ctx.unaryOperator() != null) {
            sign = ctx.unaryOperator().getText();
        }
        if (ctx.constant() != null) {
            MySqlParser.StringLiteralContext stringLiteralContext = ctx.constant().stringLiteral();
            if (stringLiteralContext != null) {
                if (stringLiteralContext.COLLATE() == null) {
                    this.columnEditor.defaultValueExpression(sign + this.unquote(stringLiteralContext.getText()));
                } else {
                    this.columnEditor.collate(sign + this.unquote(stringLiteralContext.STRING_LITERAL(0).getText()));
                }
            } else if (ctx.constant().decimalLiteral() != null) {
                this.columnEditor.defaultValueExpression(sign + ctx.constant().decimalLiteral().getText());
            } else if (ctx.constant().BIT_STRING() != null) {
                this.columnEditor.defaultValueExpression(this.unquoteBinary(ctx.constant().BIT_STRING().getText()));
            } else if (ctx.constant().booleanLiteral() != null) {
                this.columnEditor.defaultValueExpression(ctx.constant().booleanLiteral().getText());
            } else if (ctx.constant().REAL_LITERAL() != null) {
                this.columnEditor.defaultValueExpression(ctx.constant().REAL_LITERAL().getText());
            }
        } else if (CollectionUtils.isNotEmpty(ctx.currentTimestamp())) {
            List<MySqlParser.CurrentTimestampContext> currentTimestampContexts = ctx.currentTimestamp();
            if (currentTimestampContexts.size() > 1 || ctx.ON() == null && ctx.UPDATE() == null) {
                MySqlParser.CurrentTimestampContext currentTimestampContext = currentTimestampContexts.get(0);
                if (currentTimestampContext.CURRENT_TIMESTAMP() != null || currentTimestampContext.NOW() != null) {
                    this.columnEditor.defaultValueExpression("1970-01-01 00:00:00");
                } else {
                    this.columnEditor.defaultValueExpression(currentTimestampContext.getText());
                }
            }
        } else if (ctx.expression() != null) {
            this.columnEditor.defaultValueExpression(ctx.expression().getText());
        } else if (ctx.fullId() != null) {
            this.columnEditor.defaultValueExpression(ctx.expression().getText());
        }
        super.enterDefaultValue(ctx);
    }

    @Override
    public void exitDefaultValue(MySqlParser.DefaultValueContext ctx) {
        super.exitDefaultValue(ctx);
    }

    private String unquote(String stringLiteral) {
        if (stringLiteral != null && (stringLiteral.startsWith("'") && stringLiteral.endsWith("'") || stringLiteral.startsWith("\"") && stringLiteral.endsWith("\""))) {
            return stringLiteral.substring(1, stringLiteral.length() - 1);
        }
        return stringLiteral;
    }

    private String unquoteBinary(String stringLiteral) {
        return stringLiteral.substring(2, stringLiteral.length() - 1);
    }
}

