/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.jdbc.table.type;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.Temporal;
import java.util.Objects;
import org.apache.eventmesh.connector.jdbc.table.type.EventMeshDataType;
import org.apache.eventmesh.connector.jdbc.table.type.SQLType;

public class CalendarType<T extends Temporal>
implements EventMeshDataType<T> {
    public static final CalendarType<LocalDate> LOCAL_DATE_TYPE = new CalendarType<LocalDate>(LocalDate.class, SQLType.DATE);
    public static final CalendarType<LocalTime> LOCAL_TIME_TYPE = new CalendarType<LocalTime>(LocalTime.class, SQLType.TIME);
    public static final CalendarType<LocalDateTime> LOCAL_DATE_TIME_TYPE = new CalendarType<LocalDateTime>(LocalDateTime.class, SQLType.TIMESTAMP);
    private final Class<T> typeClass;
    private final SQLType sqlType;

    private CalendarType(Class<T> typeClass, SQLType sqlType) {
        this.typeClass = typeClass;
        this.sqlType = sqlType;
    }

    @Override
    public Class<T> getTypeClass() {
        return this.typeClass;
    }

    @Override
    public SQLType getSQLType() {
        return this.sqlType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CalendarType)) {
            return false;
        }
        CalendarType that = (CalendarType)o;
        return Objects.equals(this.getTypeClass(), that.getTypeClass()) && this.sqlType == that.sqlType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getTypeClass(), this.sqlType});
    }

    public String toString() {
        return this.typeClass.getName();
    }
}

