/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.jdbc.table.type;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.eventmesh.connector.jdbc.table.type.EventMeshDataType;
import org.apache.eventmesh.connector.jdbc.table.type.SQLType;

public class MapType<K, V>
implements EventMeshDataType<Map<K, V>> {
    private static final List<SQLType> SUPPORTED_KEY_TYPES = Arrays.asList(SQLType.NULL, SQLType.BOOLEAN, SQLType.TINYINT, SQLType.SMALLINT, SQLType.INTEGER, SQLType.BIGINT, SQLType.DATE, SQLType.TIME, SQLType.TIMESTAMP, SQLType.FLOAT, SQLType.DOUBLE, SQLType.STRING, SQLType.DECIMAL);
    private final EventMeshDataType<K> keyType;
    private final EventMeshDataType<V> valueType;

    public MapType(EventMeshDataType<K> keyType, EventMeshDataType<V> valueType) {
        Objects.requireNonNull(keyType, "The key type is required.");
        Objects.requireNonNull(valueType, "The value type is required.");
        if (!SUPPORTED_KEY_TYPES.contains((Object)keyType.getSQLType())) {
            throw new IllegalArgumentException(String.format("Not support type: %s", new Object[]{keyType.getSQLType()}));
        }
        this.keyType = keyType;
        this.valueType = valueType;
    }

    @Override
    public Class<Map<K, V>> getTypeClass() {
        return Map.class;
    }

    @Override
    public SQLType getSQLType() {
        return SQLType.MAP;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MapType)) {
            return false;
        }
        MapType mapType = (MapType)o;
        return Objects.equals(this.keyType, mapType.keyType) && Objects.equals(this.valueType, mapType.valueType);
    }

    public int hashCode() {
        return Objects.hash(this.keyType, this.valueType);
    }

    public EventMeshDataType<K> keyType() {
        return this.keyType;
    }

    public EventMeshDataType<V> valueType() {
        return this.valueType;
    }
}

