/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.rabbitmq.sink.connector;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import io.cloudevents.CloudEvent;
import java.util.List;
import org.apache.eventmesh.connector.rabbitmq.client.RabbitmqClient;
import org.apache.eventmesh.connector.rabbitmq.client.RabbitmqConnectionFactory;
import org.apache.eventmesh.connector.rabbitmq.cloudevent.RabbitmqCloudEvent;
import org.apache.eventmesh.connector.rabbitmq.cloudevent.RabbitmqCloudEventWriter;
import org.apache.eventmesh.connector.rabbitmq.sink.config.RabbitMQSinkConfig;
import org.apache.eventmesh.openconnect.api.config.Config;
import org.apache.eventmesh.openconnect.api.connector.ConnectorContext;
import org.apache.eventmesh.openconnect.api.connector.SinkConnectorContext;
import org.apache.eventmesh.openconnect.api.sink.Sink;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.ConnectRecord;
import org.apache.eventmesh.openconnect.util.CloudEventUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RabbitMQSinkConnector
implements Sink {
    private static final Logger log = LoggerFactory.getLogger(RabbitMQSinkConnector.class);
    private RabbitMQSinkConfig sinkConfig;
    private final RabbitmqConnectionFactory rabbitmqConnectionFactory = new RabbitmqConnectionFactory();
    private RabbitmqClient rabbitmqClient;
    private Connection connection;
    private Channel channel;
    private volatile boolean started = false;

    public Class<? extends Config> configClass() {
        return RabbitMQSinkConfig.class;
    }

    public void init(Config config) throws Exception {
    }

    public void init(ConnectorContext connectorContext) throws Exception {
        this.sinkConfig = (RabbitMQSinkConfig)((SinkConnectorContext)connectorContext).getSinkConfig();
        this.rabbitmqClient = new RabbitmqClient(this.rabbitmqConnectionFactory);
        this.connection = this.rabbitmqClient.getConnection(this.sinkConfig.getConnectorConfig().getHost(), this.sinkConfig.getConnectorConfig().getUsername(), this.sinkConfig.getConnectorConfig().getPasswd(), this.sinkConfig.getConnectorConfig().getPort(), this.sinkConfig.getConnectorConfig().getVirtualHost());
        this.channel = this.rabbitmqConnectionFactory.createChannel(this.connection);
    }

    public void start() throws Exception {
        if (!this.started) {
            this.rabbitmqClient.binding(this.channel, this.sinkConfig.getConnectorConfig().getExchangeType(), this.sinkConfig.getConnectorConfig().getExchangeName(), this.sinkConfig.getConnectorConfig().getRoutingKey(), this.sinkConfig.getConnectorConfig().getQueueName());
            this.started = true;
        }
    }

    public void commit(ConnectRecord record) {
    }

    public String name() {
        return this.sinkConfig.getConnectorConfig().getConnectorName();
    }

    public void stop() {
        if (this.started) {
            try {
                this.rabbitmqClient.closeConnection(this.connection);
                this.rabbitmqClient.closeChannel(this.channel);
            }
            finally {
                this.started = false;
            }
        }
    }

    public void put(List<ConnectRecord> sinkRecords) {
        for (ConnectRecord connectRecord : sinkRecords) {
            CloudEvent event = CloudEventUtil.convertRecordToEvent((ConnectRecord)connectRecord);
            try {
                RabbitmqCloudEventWriter writer = new RabbitmqCloudEventWriter();
                RabbitmqCloudEvent rabbitmqCloudEvent = (RabbitmqCloudEvent)writer.writeBinary(event);
                byte[] data = RabbitmqCloudEvent.toByteArray(rabbitmqCloudEvent);
                this.rabbitmqClient.publish(this.channel, this.sinkConfig.getConnectorConfig().getExchangeName(), this.sinkConfig.getConnectorConfig().getRoutingKey(), data);
            }
            catch (InterruptedException e) {
                Thread currentThread = Thread.currentThread();
                log.warn("[RabbitMQSinkConnector] Interrupting thread {} due to exception {}", (Object)currentThread.getName(), (Object)e.getMessage());
                currentThread.interrupt();
            }
            catch (Exception e) {
                log.error("[RabbitMQSinkConnector] sendResult has error : ", (Throwable)e);
            }
        }
    }
}

