/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.spring.sink;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.eventmesh.common.ThreadPoolFactory;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.connector.spring.config.SpringConnectServerConfig;
import org.apache.eventmesh.connector.spring.sink.EventMeshConsumerMetadata;
import org.apache.eventmesh.connector.spring.sink.EventMeshListener;
import org.apache.eventmesh.connector.spring.sink.connector.SpringSinkConnector;
import org.apache.eventmesh.openconnect.Application;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.ConnectRecord;
import org.apache.eventmesh.openconnect.util.ConfigUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.ReflectionUtils;

public class EventMeshListenerBeanPostProcessor
implements ApplicationContextAware,
CommandLineRunner,
BeanPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(EventMeshListenerBeanPostProcessor.class);
    private static final String SPRING_SINK = "springSink";
    private static final ThreadPoolExecutor executor = ThreadPoolFactory.createThreadPoolExecutor((int)(Runtime.getRuntime().availableProcessors() * 2), (int)(Runtime.getRuntime().availableProcessors() * 2), (String)"EventMesh-MessageListenerBeanPostProcessor-");
    private ApplicationContext applicationContext;
    private List<EventMeshConsumerMetadata> metadataList = new ArrayList<EventMeshConsumerMetadata>();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public Object postProcessAfterInitialization(final Object bean, String beanName) throws BeansException {
        Class<?> targetClass = AopUtils.isAopProxy((Object)bean) ? AopUtils.getTargetClass((Object)bean) : bean.getClass();
        ReflectionUtils.doWithMethods(targetClass, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                EventMeshListener annotation = (EventMeshListener)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, EventMeshListener.class);
                if (annotation == null || method.isBridge()) {
                    return;
                }
                EventMeshListenerBeanPostProcessor.this.metadataList.add(new EventMeshConsumerMetadata(bean, method, annotation));
            }
        });
        return bean;
    }

    public void run(String ... args) throws Exception {
        this.runSinkConnector();
        this.metadataList.forEach(metadata -> {
            Object bean = metadata.getBean();
            Method method = metadata.getMethod();
            EventMeshListener annotation = metadata.getAnnotation();
            SpringSinkConnector sinkConnector = (SpringSinkConnector)this.applicationContext.getBean(SpringSinkConnector.class);
            executor.execute(() -> {
                while (sinkConnector.isRunning()) {
                    try {
                        ConnectRecord poll = sinkConnector.getQueue().poll(annotation.requestTimeout(), TimeUnit.SECONDS);
                        if (null == poll || null == poll.getData()) continue;
                        String messageBody = new String((byte[])poll.getData());
                        Type[] parameterizedTypes = method.getGenericParameterTypes();
                        if (parameterizedTypes.length == 0) {
                            throw new IllegalStateException("There has not any arguments for consumer method.");
                        }
                        if (parameterizedTypes.length > 1) {
                            throw new IllegalStateException("There has more than one arguments for consumer method.");
                        }
                        if (!(parameterizedTypes[0] instanceof Class)) {
                            throw new IllegalStateException("The arguments type for consumer method can't cast to be Class and ParameterizedTypeImpl");
                        }
                        Class rawType = (Class)parameterizedTypes[0];
                        if (rawType == String.class) {
                            metadata.getMethod().invoke(bean, messageBody);
                            continue;
                        }
                        metadata.getMethod().invoke(bean, (Object[])JsonUtils.parseObject((String)messageBody, (Type)parameterizedTypes[0]));
                    }
                    catch (Exception e) {
                        log.warn("Consume snapshot event error", (Throwable)e);
                    }
                }
            });
        });
    }

    public void runSinkConnector() {
        SpringConnectServerConfig springConnectServerConfig = (SpringConnectServerConfig)((Object)ConfigUtil.parse(SpringConnectServerConfig.class, (String)"server-config.yml"));
        if (springConnectServerConfig.isSinkEnable()) {
            HashMap<String, String> extensions = new HashMap<String, String>();
            extensions.put("createExtension", SPRING_SINK);
            Application application = new Application(extensions);
            application.run(SpringSinkConnector.class);
        }
    }
}

