/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.spring.sink.connector;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.eventmesh.connector.spring.sink.config.SpringSinkConfig;
import org.apache.eventmesh.openconnect.api.config.Config;
import org.apache.eventmesh.openconnect.api.connector.ConnectorContext;
import org.apache.eventmesh.openconnect.api.connector.SinkConnectorContext;
import org.apache.eventmesh.openconnect.api.sink.Sink;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.ConnectRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringSinkConnector
implements Sink {
    private static final Logger log = LoggerFactory.getLogger(SpringSinkConnector.class);
    private SpringSinkConfig sinkConfig;
    private BlockingQueue<ConnectRecord> queue;
    private volatile boolean isRunning = false;

    public Class<? extends Config> configClass() {
        return SpringSinkConfig.class;
    }

    public void init(Config config) throws Exception {
        this.sinkConfig = (SpringSinkConfig)config;
        this.queue = new LinkedBlockingQueue<ConnectRecord>(1000);
    }

    public void init(ConnectorContext connectorContext) throws Exception {
        SinkConnectorContext sinkConnectorContext = (SinkConnectorContext)connectorContext;
        this.sinkConfig = (SpringSinkConfig)sinkConnectorContext.getSinkConfig();
        this.queue = new LinkedBlockingQueue<ConnectRecord>(1000);
    }

    public void start() throws Exception {
        this.isRunning = true;
    }

    public void commit(ConnectRecord record) {
    }

    public String name() {
        return this.sinkConfig.getSinkConnectorConfig().getConnectorName();
    }

    public void stop() throws Exception {
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public BlockingQueue<ConnectRecord> getQueue() {
        return this.queue;
    }

    public void put(List<ConnectRecord> sinkRecords) {
        for (ConnectRecord connectRecord : sinkRecords) {
            try {
                this.queue.put(connectRecord);
            }
            catch (InterruptedException e) {
                Thread currentThread = Thread.currentThread();
                log.warn("[SpringSinkConnector] Interrupting thread {} due to exception {}", (Object)currentThread.getName(), (Object)e.getMessage());
                currentThread.interrupt();
            }
        }
    }
}

