/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.mongodb.sink.client;

import com.mongodb.ConnectionString;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import io.cloudevents.CloudEvent;
import org.apache.eventmesh.connector.mongodb.sink.client.Impl.MongodbSinkClient;
import org.apache.eventmesh.connector.mongodb.sink.config.SinkConnectorConfig;
import org.apache.eventmesh.connector.mongodb.utils.MongodbCloudEventUtil;
import org.bson.Document;

public class MongodbReplicaSetSinkClient
implements MongodbSinkClient {
    private final SinkConnectorConfig connectorConfig;
    private volatile boolean started = false;
    private MongoClient client;

    public MongodbReplicaSetSinkClient(SinkConnectorConfig connectorConfig) {
        this.connectorConfig = connectorConfig;
    }

    @Override
    public void init() {
        this.client = MongoClients.create((ConnectionString)new ConnectionString(this.connectorConfig.getUrl()));
    }

    @Override
    public void start() {
        if (!this.started) {
            this.started = true;
        }
    }

    @Override
    public void publish(CloudEvent cloudEvent) {
        Document document = MongodbCloudEventUtil.convertToDocument(cloudEvent);
        MongoCollection collection = this.client.getDatabase(this.connectorConfig.getDatabase()).getCollection(this.connectorConfig.getCollection());
        collection.insertOne((Object)document);
    }

    @Override
    public void stop() {
        if (this.started) {
            try {
                this.client.close();
            }
            finally {
                this.started = false;
            }
        }
    }
}

