/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.mongodb.source.client;

import com.mongodb.ConnectionString;
import com.mongodb.client.ChangeStreamIterable;
import com.mongodb.client.MongoChangeStreamCursor;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.changestream.ChangeStreamDocument;
import io.cloudevents.CloudEvent;
import java.util.concurrent.BlockingQueue;
import org.apache.eventmesh.connector.mongodb.source.client.Impl.MongodbSourceClient;
import org.apache.eventmesh.connector.mongodb.source.config.SourceConnectorConfig;
import org.apache.eventmesh.connector.mongodb.utils.MongodbCloudEventUtil;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongodbReplicaSetSourceClient
implements MongodbSourceClient {
    private static final Logger log = LoggerFactory.getLogger(MongodbReplicaSetSourceClient.class);
    private final SourceConnectorConfig connectorConfig;
    private volatile boolean started = false;
    private MongoClient client;
    private MongoChangeStreamCursor<ChangeStreamDocument<Document>> cursor;
    private final BlockingQueue<CloudEvent> queue;

    public MongodbReplicaSetSourceClient(SourceConnectorConfig connectorConfig, BlockingQueue<CloudEvent> queue) {
        this.queue = queue;
        this.connectorConfig = connectorConfig;
    }

    @Override
    public void init() {
        this.client = MongoClients.create((ConnectionString)new ConnectionString(this.connectorConfig.getUrl()));
    }

    @Override
    public void start() {
        if (!this.started) {
            MongoCollection collection = this.client.getDatabase(this.connectorConfig.getDatabase()).getCollection(this.connectorConfig.getCollection());
            ChangeStreamIterable changeStreamDocuments = collection.watch();
            this.cursor = changeStreamDocuments.cursor();
            this.handle();
            this.started = true;
        }
    }

    @Override
    public void stop() {
        if (this.started) {
            try {
                this.client.close();
                this.cursor.close();
            }
            finally {
                this.started = false;
            }
        }
    }

    private void handle() {
        while (this.cursor.hasNext()) {
            ChangeStreamDocument next = (ChangeStreamDocument)this.cursor.next();
            Document fullDocument = (Document)next.getFullDocument();
            if (fullDocument == null) continue;
            try {
                CloudEvent cloudEvent = MongodbCloudEventUtil.convertToCloudEvent(fullDocument);
                this.queue.add(cloudEvent);
            }
            catch (Exception e) {
                log.error("[MongodbReplicaSetSourceClient] happen exception.", (Throwable)e);
            }
        }
    }
}

