/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.mongodb.utils;

import io.cloudevents.CloudEvent;
import io.cloudevents.SpecVersion;
import io.cloudevents.core.builder.CloudEventBuilder;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.apache.eventmesh.common.Constants;
import org.bson.Document;

public class MongodbCloudEventUtil {
    public static CloudEvent convertToCloudEvent(Document document) throws Exception {
        io.cloudevents.core.v03.CloudEventBuilder builder;
        document.remove((Object)"_id");
        String versionStr = document.getString((Object)"version");
        SpecVersion version = SpecVersion.valueOf((String)versionStr);
        switch (version) {
            case V03: {
                builder = CloudEventBuilder.v03();
                break;
            }
            case V1: {
                builder = CloudEventBuilder.v1();
                break;
            }
            default: {
                throw new Exception(String.format("CloudEvent version %s does not support.", version));
            }
        }
        builder.withData(document.remove((Object)"data").toString().getBytes(Constants.DEFAULT_CHARSET)).withId(document.remove((Object)"id").toString()).withSource(URI.create(document.remove((Object)"source").toString())).withType(document.remove((Object)"type").toString()).withDataContentType(document.remove((Object)"datacontenttype").toString()).withSubject(document.remove((Object)"subject").toString());
        document.forEach((arg_0, arg_1) -> MongodbCloudEventUtil.lambda$convertToCloudEvent$0((CloudEventBuilder)builder, arg_0, arg_1));
        return builder.build();
    }

    public static Document convertToDocument(CloudEvent cloudEvent) {
        Document document = new Document();
        document.put("version", (Object)cloudEvent.getSpecVersion().name());
        document.put("data", (Object)(cloudEvent.getData() == null ? null : new String(cloudEvent.getData().toBytes(), StandardCharsets.UTF_8)));
        document.put("id", (Object)cloudEvent.getId());
        document.put("source", (Object)cloudEvent.getSource().toString());
        document.put("type", (Object)cloudEvent.getType());
        document.put("datacontenttype", (Object)cloudEvent.getDataContentType());
        document.put("subject", (Object)cloudEvent.getSubject());
        cloudEvent.getExtensionNames().forEach(key -> document.put(key, cloudEvent.getExtension(key)));
        return document;
    }

    private static /* synthetic */ void lambda$convertToCloudEvent$0(CloudEventBuilder builder, String key, Object value) {
        builder.withExtension(key, value.toString());
    }
}

