/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.redis.source.connector;

import io.cloudevents.CloudEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.eventmesh.connector.redis.cloudevent.CloudEventCodec;
import org.apache.eventmesh.connector.redis.source.config.RedisSourceConfig;
import org.apache.eventmesh.openconnect.api.config.Config;
import org.apache.eventmesh.openconnect.api.connector.ConnectorContext;
import org.apache.eventmesh.openconnect.api.connector.SourceConnectorContext;
import org.apache.eventmesh.openconnect.api.source.Source;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.ConnectRecord;
import org.apache.eventmesh.openconnect.util.CloudEventUtil;
import org.redisson.Redisson;
import org.redisson.api.RTopic;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;

public class RedisSourceConnector
implements Source {
    private static final int DEFAULT_BATCH_SIZE = 10;
    private RTopic topic;
    private RedisSourceConfig sourceConfig;
    private RedissonClient redissonClient;
    private BlockingQueue<CloudEvent> queue;

    public Class<? extends Config> configClass() {
        return RedisSourceConfig.class;
    }

    public void init(Config config) throws Exception {
        this.sourceConfig = (RedisSourceConfig)config;
        this.doInit();
    }

    public void init(ConnectorContext connectorContext) throws Exception {
        SourceConnectorContext sourceConnectorContext = (SourceConnectorContext)connectorContext;
        this.sourceConfig = (RedisSourceConfig)sourceConnectorContext.getSourceConfig();
        this.doInit();
    }

    private void doInit() {
        org.redisson.config.Config redisConfig = new org.redisson.config.Config();
        redisConfig.useSingleServer().setAddress(this.sourceConfig.connectorConfig.getServer());
        redisConfig.setCodec((Codec)CloudEventCodec.getInstance());
        this.redissonClient = Redisson.create((org.redisson.config.Config)redisConfig);
        this.queue = new LinkedBlockingQueue<CloudEvent>(1000);
    }

    public void start() throws Exception {
        this.topic = this.redissonClient.getTopic(this.sourceConfig.connectorConfig.getTopic());
        this.topic.addListener(CloudEvent.class, (channel, msg) -> this.queue.add((CloudEvent)msg));
    }

    public void commit(ConnectRecord record) {
    }

    public String name() {
        return this.sourceConfig.getConnectorConfig().getConnectorName();
    }

    public void stop() throws Exception {
        this.topic.removeAllListeners();
        this.redissonClient.shutdown();
    }

    public List<ConnectRecord> poll() {
        ArrayList<ConnectRecord> connectRecords = new ArrayList<ConnectRecord>(10);
        for (int count = 0; count < 10; ++count) {
            try {
                CloudEvent event = this.queue.poll(3L, TimeUnit.SECONDS);
                if (event == null) break;
                connectRecords.add(CloudEventUtil.convertEventToRecord((CloudEvent)event));
                continue;
            }
            catch (InterruptedException e) {
                break;
            }
        }
        return connectRecords;
    }
}

