/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.s3.source.connector;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.eventmesh.connector.s3.source.config.S3SourceConfig;
import org.apache.eventmesh.connector.s3.source.config.SourceConnectorConfig;
import org.apache.eventmesh.openconnect.api.config.Config;
import org.apache.eventmesh.openconnect.api.connector.ConnectorContext;
import org.apache.eventmesh.openconnect.api.connector.SourceConnectorContext;
import org.apache.eventmesh.openconnect.api.source.Source;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.ConnectRecord;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.RecordOffset;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.RecordPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.core.ResponseBytes;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3AsyncClientBuilder;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;

public class S3SourceConnector
implements Source {
    private static final Logger log = LoggerFactory.getLogger(S3SourceConnector.class);
    public static final String REGION = "region";
    public static final String BUCKET = "bucket";
    public static final String FILE_NAME = "fileName";
    public static final String POSITION = "position";
    private S3SourceConfig sourceConfig;
    private SourceConnectorConfig sourceConnectorConfig;
    private int eachRecordSize;
    private long fileSize;
    private S3AsyncClient s3Client;
    private long position;

    public Class<? extends Config> configClass() {
        return S3SourceConfig.class;
    }

    public void init(Config config) throws Exception {
        this.sourceConfig = (S3SourceConfig)config;
        this.doInit();
    }

    public void init(ConnectorContext connectorContext) throws Exception {
        SourceConnectorContext sourceConnectorContext = (SourceConnectorContext)connectorContext;
        this.sourceConfig = (S3SourceConfig)sourceConnectorContext.getSourceConfig();
        this.doInit();
    }

    private void doInit() {
        this.sourceConnectorConfig = this.sourceConfig.getSourceConnectorConfig();
        this.eachRecordSize = this.calculateEachRecordSize();
        AwsBasicCredentials basicCredentials = AwsBasicCredentials.create((String)this.sourceConnectorConfig.getAccessKey(), (String)this.sourceConnectorConfig.getSecretKey());
        this.s3Client = (S3AsyncClient)((S3AsyncClientBuilder)((S3AsyncClientBuilder)S3AsyncClient.builder().credentialsProvider(() -> basicCredentials)).region(Region.of((String)this.sourceConnectorConfig.getRegion()))).build();
    }

    private int calculateEachRecordSize() {
        Optional<Integer> sum = this.sourceConnectorConfig.getSchema().values().stream().reduce((x, y) -> x + y);
        return sum.orElse(0);
    }

    public void start() throws Exception {
        CompletableFuture headObjectResponseCompletableFuture = this.s3Client.headObject(builder -> builder.bucket(this.sourceConnectorConfig.getBucket()).key(this.sourceConnectorConfig.getFileName()));
        headObjectResponseCompletableFuture.get(this.sourceConnectorConfig.getTimeout(), TimeUnit.MILLISECONDS);
        this.fileSize = ((HeadObjectResponse)headObjectResponseCompletableFuture.get()).contentLength();
    }

    public void commit(ConnectRecord record) {
    }

    public String name() {
        return this.sourceConfig.getSourceConnectorConfig().getConnectorName();
    }

    public void stop() throws Exception {
    }

    public List<ConnectRecord> poll() {
        ResponseBytes resp;
        if (this.position >= this.fileSize) {
            return Collections.EMPTY_LIST;
        }
        long startPosition = this.position;
        long endPosition = Math.min(this.fileSize, this.position + (long)(this.eachRecordSize * this.sourceConnectorConfig.getBatchSize())) - 1L;
        GetObjectRequest request = (GetObjectRequest)GetObjectRequest.builder().bucket(this.sourceConnectorConfig.getBucket()).key(this.sourceConnectorConfig.getFileName()).range("bytes=" + startPosition + "-" + endPosition).build();
        try {
            resp = (ResponseBytes)this.s3Client.getObject(request, AsyncResponseTransformer.toBytes()).get(this.sourceConnectorConfig.getTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            log.error("poll records from S3 file, poll range {}-{}, but failed", new Object[]{startPosition, endPosition, e});
            return Collections.EMPTY_LIST;
        }
        byte[] bytes = resp.asByteArray();
        ArrayList<ConnectRecord> records = new ArrayList<ConnectRecord>(bytes.length / this.eachRecordSize);
        for (int i = 0; i < bytes.length; i += this.eachRecordSize) {
            byte[] body = new byte[this.eachRecordSize];
            System.arraycopy(bytes, i, body, 0, this.eachRecordSize);
            this.position += (long)this.eachRecordSize;
            ConnectRecord record = new ConnectRecord(this.getRecordPartition(), this.getRecordOffset(), Long.valueOf(System.currentTimeMillis()), (Object)body);
            records.add(record);
        }
        return records;
    }

    private RecordPartition getRecordPartition() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(REGION, this.sourceConnectorConfig.getRegion());
        map.put(BUCKET, this.sourceConnectorConfig.getBucket());
        map.put(FILE_NAME, this.sourceConnectorConfig.getFileName());
        return new RecordPartition(map);
    }

    private RecordOffset getRecordOffset() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(POSITION, String.valueOf(this.position));
        return new RecordOffset(map);
    }
}

