/*
 * Decompiled with CFR 0.152.
 */
package flash.swf.tags;

import flash.swf.Tag;
import flash.swf.TagHandler;

public class ProductInfo
extends Tag {
    private long build;
    private int product;
    private byte majorVersion;
    private byte minorVersion;
    private int edition;
    private long compileDate;
    public static final int UNKNOWN = 0;
    public static final int J2EE_PRODUCT = 1;
    public static final int NET_PRODUCT = 2;
    public static final int ABOBE_FLEX_PRODUCT = 3;
    protected static final String[] products = new String[]{"unknown", "Macromedia Flex for J2EE", "Macromedia Flex for .NET", "Apache Flex"};
    protected static final int DEVELOPER_EDITION = 0;
    protected static final int FULL_COMMERCIAL_EDITION = 1;
    protected static final int NON_COMMERCIAL_EDITION = 2;
    protected static final int EDUCATIONAL_EDITION = 3;
    protected static final int NFR_EDITION = 4;
    protected static final int TRIAL_EDITION = 5;
    protected static final int NO_EDITION = 6;
    public static final String[] editions = new String[]{"Developer Edition", "Full Commercial Edition", "Non-Commercial Edition", "Educational Edition", "NFR Edition", "Trial Edition", ""};

    public ProductInfo(int product, int edition, byte majorVersion, byte minorVersion, long build, long compileDate) {
        super(41);
        this.product = product;
        this.edition = edition;
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.build = build;
        this.compileDate = compileDate;
    }

    public ProductInfo(int product, byte majorVersion, byte minorVersion, long build, long compileDate) {
        super(41);
        this.product = product;
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.build = build;
        this.compileDate = compileDate;
    }

    public ProductInfo(long compileDate) {
        super(41);
        this.compileDate = compileDate;
    }

    public long getBuild() {
        return this.build;
    }

    public long getCompileDate() {
        return this.compileDate;
    }

    public boolean equals(Object object) {
        boolean isEqual = false;
        if (super.equals(object) && object instanceof ProductInfo) {
            ProductInfo productInfo = (ProductInfo)object;
            if (this.product == productInfo.product && this.edition == productInfo.edition && this.majorVersion == productInfo.majorVersion && this.minorVersion == productInfo.minorVersion && this.build == productInfo.build && this.compileDate == productInfo.compileDate) {
                isEqual = true;
            }
        }
        return isEqual;
    }

    public int getEdition() {
        return this.edition;
    }

    public void setEdition(int edition) {
        this.edition = edition;
    }

    public String getEditionString() {
        return editions[this.edition];
    }

    public int getProduct() {
        return this.product;
    }

    public String getProductString() {
        return products[this.product];
    }

    public byte getMajorVersion() {
        return this.majorVersion;
    }

    public byte getMinorVersion() {
        return this.minorVersion;
    }

    public void visit(TagHandler tagHandler) {
        tagHandler.productInfo(this);
    }
}

