/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.resource;

import java.io.IOException;
import java.net.URL;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.client.gateway.SqlExecutionException;
import org.apache.flink.table.resource.ResourceManager;
import org.apache.flink.table.resource.ResourceType;
import org.apache.flink.table.resource.ResourceUri;
import org.apache.flink.util.MutableURLClassLoader;

@Internal
public class ClientResourceManager
extends ResourceManager {
    public ClientResourceManager(Configuration config, MutableURLClassLoader userClassLoader) {
        super((ReadableConfig)config, userClassLoader);
    }

    @Nullable
    public URL unregisterJarResource(String jarPath) {
        Path path = new Path(jarPath);
        try {
            this.checkJarPath(path);
            return (URL)this.resourceInfos.remove(new ResourceUri(ResourceType.JAR, this.getURLFromPath(path).getPath()));
        }
        catch (IOException e) {
            throw new SqlExecutionException(String.format("Failed to unregister the jar resource [%s]", jarPath), e);
        }
    }
}

