/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.agents.plan.serializer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.agents.api.resource.ResourceDescriptor;
import org.apache.flink.agents.api.resource.ResourceType;
import org.apache.flink.agents.plan.resourceprovider.JavaResourceProvider;
import org.apache.flink.agents.plan.resourceprovider.JavaSerializableResourceProvider;
import org.apache.flink.agents.plan.resourceprovider.PythonResourceProvider;
import org.apache.flink.agents.plan.resourceprovider.PythonSerializableResourceProvider;
import org.apache.flink.agents.plan.resourceprovider.ResourceProvider;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.TreeNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.deser.std.StdDeserializer;

public class ResourceProviderJsonDeserializer
extends StdDeserializer<ResourceProvider> {
    private static ObjectMapper mapper = new ObjectMapper();

    public ResourceProviderJsonDeserializer() {
        super(ResourceProvider.class);
    }

    @Override
    public ResourceProvider deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        JsonNode marker = node.get("__resource_provider_type__");
        if (marker == null) {
            throw new IOException("Missing __resource_provider_type__ in ResourceProvider JSON");
        }
        String providerType = marker.asText();
        if (PythonResourceProvider.class.getSimpleName().equals(providerType)) {
            return this.deserializePythonResourceProvider(node);
        }
        if (PythonSerializableResourceProvider.class.getSimpleName().equals(providerType)) {
            return this.deserializePythonSerializableResourceProvider(node);
        }
        if (JavaResourceProvider.class.getSimpleName().equals(providerType)) {
            return this.deserializeJavaResourceProvider(node);
        }
        if (JavaSerializableResourceProvider.class.getSimpleName().equals(providerType)) {
            return this.deserializeJavaSerializableResourceProvider(node);
        }
        throw new IOException("Unsupported resource provider type: " + providerType);
    }

    private PythonResourceProvider deserializePythonResourceProvider(JsonNode node) {
        String name = node.get("name").asText();
        String type = node.get("type").asText();
        String module = node.get("module").asText();
        String clazz = node.get("clazz").asText();
        JsonNode kwargsNode = node.get("kwargs");
        HashMap<String, Object> kwargs = new HashMap();
        if (kwargsNode != null && kwargsNode.isObject()) {
            kwargs = (Map)this.parseJsonNode(kwargsNode);
        }
        return new PythonResourceProvider(name, ResourceType.fromValue(type), module, clazz, kwargs);
    }

    private PythonSerializableResourceProvider deserializePythonSerializableResourceProvider(JsonNode node) {
        String name = node.get("name").asText();
        String type = node.get("type").asText();
        String module = node.get("module").asText();
        String clazz = node.get("clazz").asText();
        JsonNode serializedNode = node.get("serialized");
        HashMap<String, Object> serialized = new HashMap();
        if (serializedNode != null && serializedNode.isObject()) {
            serialized = (Map)this.parseJsonNode(serializedNode);
        }
        return new PythonSerializableResourceProvider(name, ResourceType.fromValue(type), module, clazz, serialized);
    }

    private JavaResourceProvider deserializeJavaResourceProvider(JsonNode node) {
        String name = node.get("name").asText();
        String type = node.get("type").asText();
        try {
            ResourceDescriptor descriptor = mapper.treeToValue((TreeNode)node.get("descriptor"), ResourceDescriptor.class);
            return new JavaResourceProvider(name, ResourceType.fromValue(type), descriptor);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private JavaSerializableResourceProvider deserializeJavaSerializableResourceProvider(JsonNode node) {
        String name = node.get("name").asText();
        String type = node.get("type").asText();
        String module = node.get("module").asText();
        String clazz = node.get("clazz").asText();
        String serializedResource = node.get("serializedResource").asText();
        return new JavaSerializableResourceProvider(name, ResourceType.fromValue(type), module, clazz, serializedResource);
    }

    private Object parseJsonNode(JsonNode node) {
        if (node.isObject()) {
            HashMap map = new HashMap();
            node.fields().forEachRemaining(entry -> map.put((String)entry.getKey(), this.parseJsonNode((JsonNode)entry.getValue())));
            return map;
        }
        if (node.isArray()) {
            ArrayList list = new ArrayList();
            node.forEach(element -> list.add(this.parseJsonNode((JsonNode)element)));
            return list;
        }
        if (node.isValueNode()) {
            return node.asText();
        }
        throw new UnsupportedOperationException("Unsupported node type: " + String.valueOf((Object)node.getNodeType()));
    }
}

