/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.description.Description;
import org.apache.flink.configuration.description.InlineElement;
import org.apache.flink.configuration.description.TextElement;
import org.apache.flink.statefun.flink.core.FlinkConfigExtractor;
import org.apache.flink.statefun.flink.core.StatefulFunctionsUniverseProvider;
import org.apache.flink.statefun.flink.core.message.MessageFactoryKey;
import org.apache.flink.statefun.flink.core.message.MessageFactoryType;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.util.InstantiationUtil;

public class StatefulFunctionsConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String MODULE_CONFIG_PREFIX = "statefun.module.global-config.";
    public static final ConfigOption<String> MODULE_GLOBAL_DEFAULT = ConfigOptions.key((String)"statefun.module.global-config.<KEY>").stringType().noDefaultValue().withDescription(Description.builder().text("Adds the given key/value pair to the Stateful Functions global configuration.").text("These values will be available via the `globalConfigurations` parameter of StatefulFunctionModule#configure.").linebreak().text("Only the key <KEY> and value are added to the configuration. If the key/value pairs").list(new InlineElement[]{TextElement.code((String)"statefun.module.global-config.key1: value1"), TextElement.code((String)"statefun.module.global-config.key2: value2")}).text("are set, then the map").list(new InlineElement[]{TextElement.code((String)"key1: value1"), TextElement.code((String)"key2: value2")}).text("will be made available to your module at runtime.").build());
    public static final ConfigOption<MessageFactoryType> USER_MESSAGE_SERIALIZER = ConfigOptions.key((String)"statefun.message.serializer").enumType(MessageFactoryType.class).defaultValue((Object)MessageFactoryType.WITH_PROTOBUF_PAYLOADS).withDescription("The serializer to use for on the wire messages.");
    public static final ConfigOption<String> USER_MESSAGE_CUSTOM_PAYLOAD_SERIALIZER_CLASS = ConfigOptions.key((String)"statefun.message.custom-payload-serializer-class").stringType().noDefaultValue().withDescription("The custom payload serializer class to use with the WITH_CUSTOM_PAYLOADS serializer, which must implement MessagePayloadSerializer.");
    public static final ConfigOption<String> FLINK_JOB_NAME = ConfigOptions.key((String)"statefun.flink-job-name").stringType().defaultValue((Object)"StatefulFunctions").withDescription("The name to display at the Flink-UI");
    public static final ConfigOption<MemorySize> TOTAL_MEMORY_USED_FOR_FEEDBACK_CHECKPOINTING = ConfigOptions.key((String)"statefun.feedback.memory.size").memoryType().defaultValue((Object)MemorySize.ofMebiBytes((long)32L)).withDescription("The number of bytes to use for in memory buffering of the feedback channel, before spilling to disk.");
    public static final ConfigOption<Integer> ASYNC_MAX_OPERATIONS_PER_TASK = ConfigOptions.key((String)"statefun.async.max-per-task").intType().defaultValue((Object)32768).withDescription("The max number of async operations per task before backpressure is applied.");
    public static final ConfigOption<String> REMOTE_MODULE_NAME = ConfigOptions.key((String)"statefun.remote.module-name").stringType().defaultValue((Object)"classpath:module.yaml").withDescription("The name of the remote module entity to look for. Also supported, file:///...");
    private MessageFactoryType factoryType;
    private String customPayloadSerializerClassName;
    private String flinkJobName;
    private byte[] universeInitializerClassBytes;
    private MemorySize feedbackBufferSize;
    private int maxAsyncOperationsPerTask;
    private String remoteModuleName;
    private Map<String, String> globalConfigurations = new HashMap<String, String>();

    public static StatefulFunctionsConfig fromEnvironment(StreamExecutionEnvironment env) {
        Configuration configuration = FlinkConfigExtractor.reflectivelyExtractFromEnv(env);
        return new StatefulFunctionsConfig(configuration);
    }

    public static StatefulFunctionsConfig fromFlinkConfiguration(Configuration flinkConfiguration) {
        return new StatefulFunctionsConfig(flinkConfiguration);
    }

    private StatefulFunctionsConfig(Configuration configuration) {
        this.factoryType = (MessageFactoryType)((Object)configuration.get(USER_MESSAGE_SERIALIZER));
        this.customPayloadSerializerClassName = (String)configuration.get(USER_MESSAGE_CUSTOM_PAYLOAD_SERIALIZER_CLASS);
        this.flinkJobName = (String)configuration.get(FLINK_JOB_NAME);
        this.feedbackBufferSize = (MemorySize)configuration.get(TOTAL_MEMORY_USED_FOR_FEEDBACK_CHECKPOINTING);
        this.maxAsyncOperationsPerTask = (Integer)configuration.get(ASYNC_MAX_OPERATIONS_PER_TASK);
        this.remoteModuleName = (String)configuration.get(REMOTE_MODULE_NAME);
        for (String key : configuration.keySet()) {
            if (!key.startsWith(MODULE_CONFIG_PREFIX)) continue;
            String value = (String)configuration.get(ConfigOptions.key((String)key).stringType().noDefaultValue());
            String userKey = key.substring(MODULE_CONFIG_PREFIX.length());
            this.globalConfigurations.put(userKey, value);
        }
    }

    public MessageFactoryType getFactoryType() {
        return this.factoryType;
    }

    public String getCustomPayloadSerializerClassName() {
        return this.customPayloadSerializerClassName;
    }

    public MessageFactoryKey getFactoryKey() {
        return MessageFactoryKey.forType(this.factoryType, this.customPayloadSerializerClassName);
    }

    public void setFactoryType(MessageFactoryType factoryType) {
        this.factoryType = Objects.requireNonNull(factoryType);
    }

    public void setCustomPayloadSerializerClassName(String customPayloadSerializerClassName) {
        this.customPayloadSerializerClassName = customPayloadSerializerClassName;
    }

    public String getFlinkJobName() {
        return this.flinkJobName;
    }

    public void setFlinkJobName(String flinkJobName) {
        this.flinkJobName = Objects.requireNonNull(flinkJobName);
    }

    public MemorySize getFeedbackBufferSize() {
        return this.feedbackBufferSize;
    }

    public void setFeedbackBufferSize(MemorySize size) {
        this.feedbackBufferSize = Objects.requireNonNull(size);
    }

    public int getMaxAsyncOperationsPerTask() {
        return this.maxAsyncOperationsPerTask;
    }

    public void setMaxAsyncOperationsPerTask(int maxAsyncOperationsPerTask) {
        this.maxAsyncOperationsPerTask = maxAsyncOperationsPerTask;
    }

    public String getRemoteModuleName() {
        return this.remoteModuleName;
    }

    public void setRemoteModuleName(String remoteModuleName) {
        this.remoteModuleName = Objects.requireNonNull(remoteModuleName);
    }

    public StatefulFunctionsUniverseProvider getProvider(ClassLoader cl) {
        try {
            return (StatefulFunctionsUniverseProvider)InstantiationUtil.deserializeObject((byte[])this.universeInitializerClassBytes, (ClassLoader)cl, (boolean)false);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new IllegalStateException("Unable to initialize.", e);
        }
    }

    public void setProvider(StatefulFunctionsUniverseProvider provider) {
        try {
            this.universeInitializerClassBytes = InstantiationUtil.serializeObject((Object)provider);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public Map<String, String> getGlobalConfigurations() {
        return Collections.unmodifiableMap(this.globalConfigurations);
    }

    public void addAllGlobalConfigurations(Map<String, String> globalConfigurations) {
        this.globalConfigurations.putAll(globalConfigurations);
    }

    public void setGlobalConfiguration(String key, String value) {
        this.globalConfigurations.put(key, value);
    }
}

