/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.linalg;

import java.util.Arrays;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.typeinfo.TypeInfo;
import org.apache.flink.ml.linalg.SparseVector;
import org.apache.flink.ml.linalg.Vector;
import org.apache.flink.ml.linalg.typeinfo.DenseVectorTypeInfoFactory;

@TypeInfo(value=DenseVectorTypeInfoFactory.class)
@PublicEvolving
public class DenseVector
implements Vector {
    public final double[] values;

    public DenseVector(double[] values) {
        this.values = values;
    }

    public DenseVector(int size) {
        this.values = new double[size];
    }

    @Override
    public int size() {
        return this.values.length;
    }

    @Override
    public double get(int i) {
        return this.values[i];
    }

    @Override
    public void set(int i, double value) {
        this.values[i] = value;
    }

    @Override
    public double[] toArray() {
        return this.values;
    }

    @Override
    public DenseVector toDense() {
        return this;
    }

    @Override
    public SparseVector toSparse() {
        int numNonZeros = 0;
        for (double value : this.values) {
            if (value == 0.0) continue;
            ++numNonZeros;
        }
        int[] nonZeroIndices = new int[numNonZeros];
        double[] numZeroValues = new double[numNonZeros];
        int k = 0;
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] == 0.0) continue;
            nonZeroIndices[k] = i;
            numZeroValues[k] = this.values[i];
            ++k;
        }
        return new SparseVector(this.size(), nonZeroIndices, numZeroValues);
    }

    public String toString() {
        return Arrays.toString(this.values);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DenseVector)) {
            return false;
        }
        return Arrays.equals(this.values, ((DenseVector)obj).values);
    }

    public int hashCode() {
        return Arrays.hashCode(this.values);
    }

    @Override
    public DenseVector clone() {
        return new DenseVector((double[])this.values.clone());
    }
}

