/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.nettyclient;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.shaded.netty4.io.netty.util.concurrent.ScheduledFuture;
import org.apache.flink.statefun.flink.core.nettyclient.NettyRequestReplyHandler;
import org.apache.flink.statefun.flink.core.nettyclient.exceptions.RequestTimeoutException;
import org.apache.flink.util.Preconditions;

final class NettyRequestTimeoutTask
implements Runnable {
    private final NettyRequestReplyHandler handler;
    @Nullable
    private ScheduledFuture<?> future;
    @Nullable
    private ChannelHandlerContext ctx;

    public NettyRequestTimeoutTask(NettyRequestReplyHandler handler) {
        this.handler = Objects.requireNonNull(handler);
    }

    void schedule(ChannelHandlerContext ctx, long remainingRequestBudget) {
        this.ctx = Objects.requireNonNull(ctx);
        this.future = ctx.executor().schedule((Runnable)this, remainingRequestBudget, TimeUnit.NANOSECONDS);
    }

    void cancel() {
        if (this.future != null) {
            this.future.cancel(false);
            this.future = null;
        }
        this.ctx = null;
    }

    @Override
    public void run() {
        Preconditions.checkState((this.ctx != null ? 1 : 0) != 0);
        Preconditions.checkState((this.future != null ? 1 : 0) != 0);
        this.handler.exceptionCaught(this.ctx, RequestTimeoutException.INSTANCE);
    }
}

